/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.event.simplified;

import com.digiwin.app.common.DWPathUtils;
import com.digiwin.app.common.DWSimplifiedApplicationConfigUtils;
import com.digiwin.app.common.config.ConfigPolicy;
import com.digiwin.app.common.config.ConfigPool;
import com.digiwin.app.common.config.local.DWSimplifiedLocalReader;
import com.digiwin.app.common.config.reader.BaseReader;
import com.digiwin.resource.simplified.DWSimplifiedResourceManager;
import com.digiwin.resource.simplified.utils.DWSimplifiedResourceUtils;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.context.event.ApplicationStartedEvent;
import org.springframework.boot.context.event.ApplicationStartingEvent;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.event.SmartApplicationListener;

public class DWSimplifiedApolloApplicationListener
implements SmartApplicationListener {
    public boolean supportsEventType(Class<? extends ApplicationEvent> eventType) {
        return ApplicationStartingEvent.class.isAssignableFrom(eventType) || ApplicationStartedEvent.class.isAssignableFrom(eventType);
    }

    public boolean supportsSourceType(Class<?> sourceType) {
        return true;
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof ApplicationStartingEvent) {
            Log log = LogFactory.getLog(DWSimplifiedApolloApplicationListener.class);
            log.info((Object)"***DAP Simplified Mode starting...");
            this.initBusinessInfo();
            this.initConfigPool();
        } else if (event instanceof ApplicationStartedEvent) {
            Log log = LogFactory.getLog(DWSimplifiedApolloApplicationListener.class);
            log.info((Object)"***DAP Simplified Mode started.");
            ConfigPool pool = ConfigPool.getInstance();
            log.info((Object)pool);
            log.info((Object)("config center url: " + System.getProperty("configCenterUrl", "")));
            log.info((Object)("config center app ID: " + System.getProperty("app.id", "")));
            log.info((Object)("platform version: " + System.getProperty("platform.version", "")));
            log.info((Object)("application version: " + System.getProperty("application.version", "")));
            log.info((Object)("config center group app ID: " + System.getProperty("group.app.id", "")));
        }
    }

    public int getOrder() {
        return -2147483630;
    }

    private void initBusinessInfo() {
        DWPathUtils.enableClassPathMode();
        String extensionLayersString = DWSimplifiedApolloApplicationListener.getExtensionLayersString();
        DWSimplifiedResourceUtils.initBusinessExtensionLayers((String)extensionLayersString);
    }

    public static String getExtensionLayersString() {
        String relaxLayerKey;
        String layerKey;
        String extensionLayersString;
        block10: {
            extensionLayersString = null;
            layerKey = "dap.app.extension.layers";
            relaxLayerKey = "dap_app_extension_layers";
            try {
                URL url = DWSimplifiedApolloApplicationListener.class.getClassLoader().getResource("application.properties");
                if (url == null) break block10;
                try (InputStream propertyStream = url.openStream();){
                    Properties applicationProperties = new Properties();
                    applicationProperties.load(propertyStream);
                    extensionLayersString = applicationProperties.getProperty(layerKey);
                }
            }
            catch (Exception e) {
                Log log = LogFactory.getLog(DWSimplifiedApolloApplicationListener.class);
                log.error((Object)String.format("initBusinessInfo(get %s from application.properties) failed!", layerKey), (Throwable)e);
            }
        }
        if (extensionLayersString == null || extensionLayersString.isEmpty()) {
            extensionLayersString = System.getProperty(layerKey);
        }
        if ((extensionLayersString == null || extensionLayersString.isEmpty()) && ((extensionLayersString = System.getenv(layerKey)) == null || extensionLayersString.isEmpty())) {
            extensionLayersString = System.getenv(relaxLayerKey);
        }
        return extensionLayersString;
    }

    private void initConfigPool() {
        String appIdFromProperties;
        DWSimplifiedResourceManager.suspendCheckStatus();
        ConfigPool pool = new ConfigPool((BaseReader)new DWSimplifiedLocalReader());
        ConfigPool.setInstance((ConfigPool)pool);
        Properties localProperties = DWSimplifiedApplicationConfigUtils.getProperties();
        String configCenterUrl = localProperties.getProperty("configCenterUrl", "");
        String configPolicy = localProperties.getProperty("configPolicy", "local_first");
        String isRemoteConfigOn = localProperties.getProperty("isRemoteConfigOn", "false");
        String isGroupConfigOn = localProperties.getProperty("isGroupConfigOn", "false");
        String configGroup = localProperties.getProperty("configGroup", "");
        if (StringUtils.isBlank((CharSequence)configCenterUrl)) {
            return;
        }
        Map<String, String> env = System.getenv();
        String appIdFromEnv = env.getOrDefault("APPIMAGENAME", appIdFromProperties = localProperties.getProperty("APPIMAGENAME", ""));
        String appId = localProperties.getProperty("CUSTOM_APPIMAGENAME", appIdFromEnv);
        if (StringUtils.isBlank((CharSequence)appId)) {
            return;
        }
        String platformVersionFromProperties = localProperties.getProperty("PLATFORM", "");
        String platformVersionFromEnv = env.getOrDefault("PLATFORM", platformVersionFromProperties);
        String platformVersion = localProperties.getProperty("CUSTOM_PLATFORM", platformVersionFromEnv);
        if (StringUtils.isBlank((CharSequence)platformVersion)) {
            return;
        }
        String applicationVersionFromProperties = localProperties.getProperty("SMALLVERSION", "");
        String applicationVersionFromEnv = env.getOrDefault("SMALLVERSION", applicationVersionFromProperties);
        String applicationVersion = localProperties.getProperty("CUSTOM_SMALLVERSION", applicationVersionFromEnv);
        if (StringUtils.isBlank((CharSequence)applicationVersion)) {
            return;
        }
        if (configCenterUrl.contains("test") || configCenterUrl.contains("dev")) {
            System.setProperty("env", "dev");
            System.setProperty("dev_meta", configCenterUrl);
        } else {
            System.setProperty("env", "pro");
            System.setProperty("pro_meta", configCenterUrl);
        }
        System.setProperty("configCenterUrl", configCenterUrl);
        System.setProperty("app.id", appId);
        System.setProperty("platform.version", platformVersion);
        System.setProperty("application.version", applicationVersion);
        System.setProperty("group.app.id", configGroup);
        System.setProperty("group.version", "default");
        System.setProperty("apollo.loadConfigQPS", "20000");
        if (StringUtils.isBlank((CharSequence)configGroup)) {
            isGroupConfigOn = "false";
        }
        pool.init(ConfigPolicy.fromString((String)configPolicy), Boolean.valueOf(isRemoteConfigOn).booleanValue(), Boolean.valueOf(isGroupConfigOn).booleanValue());
        DWSimplifiedResourceManager.resumeCheckStatus();
    }
}

