/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.com.digiwin.app.extension.mybatisplus;

import com.baomidou.mybatisplus.autoconfigure.SqlSessionFactoryBeanCustomizer;
import com.baomidou.mybatisplus.core.MybatisConfiguration;
import com.baomidou.mybatisplus.extension.spring.MybatisSqlSessionFactoryBean;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ibatis.mapping.ResultMap;
import org.springframework.cglib.proxy.Callback;
import org.springframework.cglib.proxy.Enhancer;
import org.springframework.cglib.proxy.MethodInterceptor;
import org.springframework.cglib.proxy.MethodProxy;

public class DWSqlSessionFactoryBeanConfigurationCustomizer
implements SqlSessionFactoryBeanCustomizer {
    public static final String PROPERTY_KEY_ALLOW_ADD_RESULT_MAP_DUPLICATE_ID = "dap.mybatis.configuration.result-map.allow-add-duplicate-id";
    private static Log log = LogFactory.getLog(DWSqlSessionFactoryBeanConfigurationCustomizer.class);
    private boolean allowProcessDuplicateXMLFileName = false;
    private MybatisConfigurationInterceptor configurationInterceptor = new MybatisConfigurationInterceptor();

    public boolean isAllowProcessDuplicateXMLFileName() {
        return this.allowProcessDuplicateXMLFileName;
    }

    public void setAllowProcessDuplicateXMLFileName(boolean allowProcessDuplicateXMLFileName) {
        this.allowProcessDuplicateXMLFileName = allowProcessDuplicateXMLFileName;
    }

    public void customize(MybatisSqlSessionFactoryBean factoryBean) {
        log.info((Object)"digiwin extension-mybatisplus - ready to replace configuration...");
        MybatisConfiguration currentConfiguration = factoryBean.getConfiguration();
        if (currentConfiguration == null) {
            log.warn((Object)"current mybatis configuration is null!");
            return;
        }
        Enhancer enhancer = new Enhancer();
        enhancer.setSuperclass(MybatisConfiguration.class);
        enhancer.setCallback((Callback)this.configurationInterceptor);
        log.info((Object)"digiwin extension-mybatisplus - create configuration proxy..");
        MybatisConfiguration proxy = (MybatisConfiguration)enhancer.create();
        log.info((Object)"digiwin extension-mybatisplus - replace to configuration proxy finished!");
        factoryBean.setConfiguration(proxy);
    }

    public class MybatisConfigurationInterceptor
    implements MethodInterceptor {
        private final Pattern FILE_PATTERN = Pattern.compile("file \\[(.*?\\.xml)]");
        private final Pattern URL_PATTERN = Pattern.compile("URL \\[jar:file:(.*)!/(.*?\\.xml)]");
        private Map<String, String> loadedXmlFileNameMap = new HashMap<String, String>();

        public Object intercept(Object obj, Method method, Object[] args, MethodProxy methodProxy) throws Throwable {
            String resource;
            String xmlFileName;
            String methodName = method.getName();
            if (methodName.equals("addResultMap")) {
                MybatisConfiguration target = (MybatisConfiguration)obj;
                ResultMap rm = (ResultMap)args[0];
                String id = rm.getId();
                if (target.hasResultMap(id)) {
                    log.error((Object)("digiwin extension-mybatisplus configuration interceptor - mapper[" + rm.getId() + "] is ignored, because it exists, maybe from xml file"));
                    return null;
                }
            } else if (methodName.equals("addLoadedResource") && !DWSqlSessionFactoryBeanConfigurationCustomizer.this.allowProcessDuplicateXMLFileName) {
                String resource2 = (String)args[0];
                String xmlFileName2 = this.extractFileName(resource2);
                if (xmlFileName2 != null) {
                    this.loadedXmlFileNameMap.put(xmlFileName2, resource2);
                }
            } else if (methodName.equals("isResourceLoaded") && !DWSqlSessionFactoryBeanConfigurationCustomizer.this.allowProcessDuplicateXMLFileName && (xmlFileName = this.extractFileName(resource = (String)args[0])) != null && this.loadedXmlFileNameMap.containsKey(xmlFileName)) {
                log.error((Object)String.format("digiwin extension-mybatisplus configuration interceptor - resource[%s] is ignored, because the xml file name is already loaded(from %s)", resource, this.loadedXmlFileNameMap.get(xmlFileName)));
                return true;
            }
            return methodProxy.invokeSuper(obj, args);
        }

        public String extractFileName(String resourceString) {
            Matcher fileMatcher = this.FILE_PATTERN.matcher(resourceString);
            if (fileMatcher.find()) {
                return this.extractFileNameFromPath(fileMatcher.group(1));
            }
            Matcher urlMatcher = this.URL_PATTERN.matcher(resourceString);
            if (urlMatcher.find()) {
                return this.extractFileNameFromPath(urlMatcher.group(2));
            }
            return null;
        }

        private String extractFileNameFromPath(String path) {
            int lastSlashIndex = path.lastIndexOf(47);
            if (lastSlashIndex == -1) {
                lastSlashIndex = path.lastIndexOf(92);
            }
            if (lastSlashIndex != -1) {
                return path.substring(lastSlashIndex + 1);
            }
            return path;
        }

        public boolean isSameXMLFile(String resourceString1, String resourceString2) {
            String fileName1 = this.extractFileName(resourceString1);
            String fileName2 = this.extractFileName(resourceString2);
            return fileName1.equals(fileName2);
        }
    }
}

