/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.resource.simplified.spring;

import com.digiwin.app.common.config.ConfigPool;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.resource.simplified.DWSimplifiedResourceManager;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.NotImplementedException;
import org.springframework.context.HierarchicalMessageSource;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.context.NoSuchMessageException;
import org.springframework.context.i18n.LocaleContextHolder;

public class DWSimplifiedServiceGroupMessageSource
implements HierarchicalMessageSource {
    private MessageSource parentMessageSource;

    public String getGroupName() {
        return DWServiceContext.getContext().getGroupName();
    }

    public String getMessage(String code, Object[] args, String defaultMessage, Locale locale) {
        String groupName;
        String message = null;
        List groupNameList = DWSimplifiedResourceManager.getGroupNameList();
        Iterator iterator = groupNameList.iterator();
        while (iterator.hasNext() && (message = this.getStringByModuleWithDefaultMessage(groupName = (String)iterator.next(), "message", code, defaultMessage, args)) == null) {
        }
        if (message == null && this.parentMessageSource != null) {
            message = this.parentMessageSource.getMessage(code, args, defaultMessage, LocaleContextHolder.getLocale());
        }
        return message;
    }

    public String getMessage(String code, Object[] args, Locale locale) throws NoSuchMessageException {
        return this.getMessage(code, args, null, null);
    }

    public String getMessage(MessageSourceResolvable resolvable, Locale locale) throws NoSuchMessageException {
        throw new NotImplementedException("unknown purpose, operator not support yet!");
    }

    public void setParentMessageSource(MessageSource parent) {
        this.parentMessageSource = parent;
    }

    public MessageSource getParentMessageSource() {
        return this.parentMessageSource;
    }

    private String getStringByModuleWithDefaultMessage(String moduleName, String baseName, String code, String defaultMessage, Object[] args) {
        String result = ConfigPool.getInstance().getModuleString(moduleName, baseName, code, args);
        if (result == null && defaultMessage != null) {
            result = defaultMessage;
        }
        return result;
    }
}

