/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.resource.simplified.spring;

import com.digiwin.app.common.config.ConfigPool;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.resource.simplified.DWSimplifiedResourceUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.springframework.core.env.PropertySource;

public class DWCurrentGroupConfigUtilsPropertySource
extends PropertySource<Object> {
    public static final String DAP_GROUP_PROPERTY_SOURCE = "dap-group-propertysource";

    private DWCurrentGroupConfigUtilsPropertySource(String name, Map<String, Properties> groupProperties) {
        super(name, groupProperties);
    }

    public static DWCurrentGroupConfigUtilsPropertySource createInstance() {
        return DWCurrentGroupConfigUtilsPropertySource.createInstance(DAP_GROUP_PROPERTY_SOURCE);
    }

    public static DWCurrentGroupConfigUtilsPropertySource createInstance(String propertySourceName) {
        return new DWCurrentGroupConfigUtilsPropertySource(propertySourceName, new HashMap<String, Properties>());
    }

    public Object getProperty(String name) {
        String currentGroupName = DWServiceContext.getContext().getGroupName();
        if (currentGroupName == null) {
            return null;
        }
        String value = null;
        List currentGroupConfigOverrideNameList = DWSimplifiedResourceUtils.getGroupFileNameOverrideList((String)currentGroupName, (String)"config", null, null);
        for (String currentLayerConfigName : currentGroupConfigOverrideNameList) {
            Properties currentLayerProperties = ConfigPool.getInstance().getProperties("classpath:", currentLayerConfigName);
            value = currentLayerProperties.getProperty(name);
            if (value == null) continue;
            break;
        }
        return value;
    }

    public boolean containsProperty(String name) {
        String currentGroupName = DWServiceContext.getContext().getGroupName();
        if (currentGroupName == null) {
            return false;
        }
        boolean exists = false;
        List currentGroupConfigOverrideNameList = DWSimplifiedResourceUtils.getGroupFileNameOverrideList((String)currentGroupName, (String)"config", null, (String)"properties");
        for (String currentLayerConfigName : currentGroupConfigOverrideNameList) {
            Properties currentLayerProperties = ConfigPool.getInstance().getProperties("classpath:", currentLayerConfigName);
            exists = currentLayerProperties.containsKey(name);
            if (!exists) continue;
            break;
        }
        return exists;
    }
}

