/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.resource.simplified.spring;

import com.digiwin.app.common.config.ConfigPool;
import com.digiwin.resource.simplified.DWSimplifiedResourceManager;
import com.digiwin.resource.simplified.utils.DWSimplifiedConfigPropertiesUtils;
import com.digiwin.resource.simplified.utils.DWSimplifiedResourceUtils;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.springframework.core.env.EnumerablePropertySource;

public class DWGroupConfigUtilsPropertySource
extends EnumerablePropertySource<ConfigPool> {
    private static final String[] EMPTY_ARRAY = new String[0];
    public static final String DAP_GROUP_PROPERTY_SOURCE = "dap-group-propertysource";

    private DWGroupConfigUtilsPropertySource(String name) {
        super(name, (Object)ConfigPool.getInstance());
    }

    public static DWGroupConfigUtilsPropertySource createInstance() {
        return DWGroupConfigUtilsPropertySource.createInstance(DAP_GROUP_PROPERTY_SOURCE);
    }

    public static DWGroupConfigUtilsPropertySource createInstance(String propertySourceName) {
        return new DWGroupConfigUtilsPropertySource(propertySourceName);
    }

    private Properties getGroupProperties(String groupName) {
        Properties allProperties = new Properties();
        Properties standardProperties = DWSimplifiedConfigPropertiesUtils.getGroupProperties((String)groupName, (int)DWSimplifiedResourceUtils.BUSINESS_LAYER_STANDARD);
        if (standardProperties != null) {
            allProperties.putAll((Map<?, ?>)standardProperties);
        }
        for (int i = 0; i <= DWSimplifiedResourceUtils.getBusinessExtensionMaxLayerIndex(); ++i) {
            Properties extensionProperties = DWSimplifiedConfigPropertiesUtils.getGroupProperties((String)groupName, (int)i);
            allProperties.putAll((Map<?, ?>)extensionProperties);
        }
        return allProperties;
    }

    public Object getProperty(String name) {
        String groupName;
        if (!DWSimplifiedResourceManager.isInitializationCompleted((String)name)) {
            return null;
        }
        List groupNameList = DWSimplifiedResourceManager.getGroupNameList();
        Object value = null;
        Iterator iterator = groupNameList.iterator();
        while (iterator.hasNext() && (value = this.getGroupProperties(groupName = (String)iterator.next()).get(name)) == null) {
        }
        return value;
    }

    public String[] getPropertyNames() {
        if (!DWSimplifiedResourceManager.isInitializationCompleted((String)"DWGroupConfigUtilsPropertySource.getPropertyNames")) {
            return EMPTY_ARRAY;
        }
        Properties allProperties = new Properties();
        List groupNameList = DWSimplifiedResourceManager.getGroupNameList();
        for (String groupName : groupNameList) {
            allProperties.putAll((Map<?, ?>)this.getGroupProperties(groupName));
        }
        if (allProperties.keySet().isEmpty()) {
            return EMPTY_ARRAY;
        }
        return allProperties.keySet().toArray(new String[allProperties.size()]);
    }
}

