/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.common.config.local;

import com.digiwin.app.common.DWPathUtils;
import com.digiwin.app.common.config.Extension;
import com.digiwin.app.common.config.local.LocalReader;
import com.digiwin.app.common.config.reader.BaseReader;
import com.digiwin.resource.simplified.DWSimplifiedResourceInfo;
import com.digiwin.resource.simplified.DWSimplifiedResourceManager;
import com.digiwin.resource.simplified.utils.DWSimplifiedI18nPropertiesUtils;
import com.digiwin.resource.simplified.utils.DWSimplifiedResourceUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.function.Function;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.util.FileCopyUtils;

public class DWSimplifiedLocalReader
implements BaseReader {
    private static final String TAG = "[DWSimplifiedLocalReader] ";
    private static Log _log = LogFactory.getLog(DWSimplifiedLocalReader.class);
    private static Map<String, Properties> configFileCaches = new HashMap<String, Properties>();
    private static Map<String, Properties> i18nFileCaches = new HashMap<String, Properties>();

    public String getLog4j2Xml() {
        return this.loadContent("log4j2.xml");
    }

    public String getPlatformModuleSpringXml(String module, String xmlNameWithoutExtension) {
        String resourceName = DWSimplifiedResourceUtils.getGroupFileName(module, DWSimplifiedResourceUtils.BUSINESS_LAYER_STANDARD, xmlNameWithoutExtension, null, "xml");
        return this.loadContent(resourceName);
    }

    public String getModuleSpringXml(String module, String xmlNameWithoutExtension) {
        List<DWSimplifiedResourceInfo> resourceInfoList = DWSimplifiedResourceManager.createDefaultSpringXMLMappingInfoOverrideList(module, xmlNameWithoutExtension);
        return this.loadContent(module, xmlNameWithoutExtension, resourceInfoList);
    }

    public String getApplicationSpringXml(String xmlNameWithoutExtension) {
        String layerResourceName;
        List<String> resourceNameOverrideList = DWSimplifiedResourceUtils.getApplicationFileNameOverrideList(xmlNameWithoutExtension, null, "xml");
        String content = null;
        Iterator<String> iterator = resourceNameOverrideList.iterator();
        while (iterator.hasNext() && (content = this.loadContent(layerResourceName = iterator.next())) == null) {
        }
        return content;
    }

    public String getPlatformSpringXml(String xmlNameWithoutExtension) {
        String resourceName = DWSimplifiedResourceUtils.getPlatformFileName(xmlNameWithoutExtension, "xml");
        return this.loadContent(resourceName);
    }

    public String getModuleResource(String module, String nameWithoutExtension, Extension extension) {
        String layerResourceName;
        List<String> resourceNameOverrideList = DWSimplifiedResourceUtils.getGroupFileNameOverrideList(module, nameWithoutExtension, null, extension.getValue());
        String content = null;
        Iterator<String> iterator = resourceNameOverrideList.iterator();
        while (iterator.hasNext() && (content = this.loadContent(layerResourceName = iterator.next())) == null) {
        }
        return content;
    }

    public String getApplicationResource(String nameWithoutExtension, Extension extension) {
        String resourceName = DWSimplifiedResourceUtils.getApplicationFileName(DWSimplifiedResourceUtils.BUSINESS_LAYER_STANDARD, nameWithoutExtension, null, extension.getValue());
        return this.loadContent(resourceName);
    }

    public String getPlatformResource(String nameWithoutExtension, Extension extension) {
        String resourceName = DWSimplifiedResourceUtils.getPlatformFileName(nameWithoutExtension, null, extension.getValue());
        return this.loadContent(resourceName);
    }

    public String getResource(String resourceBaseName, Extension resourceExtension) {
        String resourceName = DWSimplifiedResourceUtils.getFileName(null, resourceBaseName, null, resourceExtension.getValue());
        return this.loadContent(resourceName);
    }

    public Properties getProperties(String path, String propertiesNameWithoutExtension) {
        String fullResourceName = path == null ? "" : path + File.separator;
        if (!(fullResourceName = fullResourceName + propertiesNameWithoutExtension + ".properties").toLowerCase().startsWith("classpath:")) {
            throw new UnsupportedOperationException("DWSimplifiedPropertiesUtils can only read classpath: resource!");
        }
        Properties properties = new Properties();
        DWSimplifiedResourceInfo resourceInfo = DWSimplifiedLocalReader.simplifiedResourceNameResolve(fullResourceName);
        if (resourceInfo == null) {
            return properties;
        }
        String conversionResourceName = resourceInfo.getSimplifiedResourceName();
        if (configFileCaches.containsKey(conversionResourceName)) {
            return configFileCaches.get(conversionResourceName);
        }
        if (conversionResourceName == null) {
            return properties;
        }
        InputStream inputStream = this.getResourceAsStream(DWSimplifiedResourceInfo.class.getClassLoader(), resourceInfo);
        if (inputStream != null) {
            try {
                properties.load(inputStream);
                inputStream.close();
            }
            catch (IOException e) {
                _log.error((Object)String.format("DWSimplifiedPropertiesUtils getProperties(resourceName=%s) failed!", fullResourceName), (Throwable)e);
            }
        }
        configFileCaches.put(conversionResourceName, properties);
        return properties;
    }

    private Properties loadI18nProperties(ClassLoader cl, String baseName, Locale locale, Function<Locale, List<DWSimplifiedResourceInfo>> i18nResourceInfoProvider) {
        String cachedKey;
        String cachedKeyPrefix = "";
        if (cl == null) {
            cl = DWSimplifiedResourceUtils.class.getClassLoader();
        }
        if (cl != DWSimplifiedResourceUtils.class.getClassLoader()) {
            cachedKeyPrefix = "[" + cl.hashCode() + "]";
        }
        if (i18nFileCaches.containsKey(cachedKey = String.format("%s(%s)%s", cachedKeyPrefix, locale == null ? LocaleContextHolder.getLocale() : locale, baseName))) {
            return i18nFileCaches.get(cachedKey);
        }
        List<DWSimplifiedResourceInfo> resourceInfoList = i18nResourceInfoProvider.apply(locale);
        Properties mergedProperties = new Properties();
        for (int j = resourceInfoList.size() - 1; j >= 0; --j) {
            DWSimplifiedResourceInfo i18nResourceInfo = resourceInfoList.get(j);
            Properties properties = new Properties();
            InputStream inputStream = this.getResourceAsStream(cl, i18nResourceInfo);
            if (inputStream != null) {
                try {
                    properties.load(inputStream);
                    inputStream.close();
                }
                catch (IOException e) {
                    _log.error((Object)String.format("DWSimplifiedPropertiesUtils getProperties(resourceName=%s) failed!", i18nResourceInfo.getSimplifiedResourceName()), (Throwable)e);
                }
            }
            mergedProperties.putAll((Map<?, ?>)properties);
        }
        i18nFileCaches.put(cachedKey, mergedProperties);
        return mergedProperties;
    }

    public String getPlatformString(String baseName, String key, Object ... patternArguments) {
        String realBaseName = DWSimplifiedI18nPropertiesUtils.getPlatformBaseName(baseName);
        Properties platformProperties = this.getPlatformI18nProperties(baseName, null);
        return this.getMessageFromProperties(realBaseName, platformProperties, true, key, patternArguments);
    }

    public String getApplicationString(String baseName, String key, Object ... patternArguments) {
        Properties applicationProperties;
        String applicationBaseName = DWSimplifiedI18nPropertiesUtils.getApplicationBaseName(DWSimplifiedResourceUtils.BUSINESS_LAYER_STANDARD, baseName);
        String message = this.getMessageFromProperties(applicationBaseName, applicationProperties = this.getApplicationI18nProperties(baseName, null), false, key, patternArguments);
        if (message == null) {
            Properties platformProperties = this.getPlatformI18nProperties(baseName, null);
            message = this.getMessageFromProperties(applicationBaseName, platformProperties, true, key, patternArguments);
        }
        return message;
    }

    public String getModuleString(String moduleName, String baseName, String key, Object ... patternArguments) {
        String groupBaseName = DWSimplifiedI18nPropertiesUtils.getGroupBaseName(moduleName, baseName, DWSimplifiedResourceUtils.BUSINESS_LAYER_STANDARD);
        Properties groupProperties = this.getModuleI18nProperties(moduleName, baseName, null);
        String message = this.getMessageFromProperties(groupBaseName, groupProperties, true, key, patternArguments);
        return message;
    }

    public String getString(ClassLoader cl, String baseName, Locale locale, String key, Object ... patternArguments) {
        Properties mergedProperties = new Properties();
        List<String> baseNameList = DWSimplifiedI18nPropertiesUtils.getBaseNameOverrideList(baseName);
        List<String> extensionBaseNameList = DWSimplifiedI18nPropertiesUtils.getBaseNameOverrideList(baseName);
        int maxLayerIndex = extensionBaseNameList.size() - 1;
        for (int i = extensionBaseNameList.size() - 1; i >= 0; --i) {
            int layerIndex = maxLayerIndex - i - 1;
            String cachedKey = extensionBaseNameList.get(i);
            Properties layerProperties = this.loadI18nProperties(cl, cachedKey, locale, processedLocale -> DWSimplifiedResourceManager.createI18nMappingInfo(layerIndex, baseName, processedLocale));
            mergedProperties.putAll((Map<?, ?>)layerProperties);
        }
        String message = this.getMessageFromProperties(baseName, mergedProperties, true, key, patternArguments);
        return message;
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    public String loadContent(String resourceName) {
        block30: {
            ClassLoader classLoader = DWSimplifiedLocalReader.class.getClassLoader();
            try {
                Throwable throwable = null;
                try (InputStream is = classLoader.getResourceAsStream(resourceName);){
                    if (is != null) {
                        try (InputStreamReader reader = new InputStreamReader(is, StandardCharsets.UTF_8);){
                            String string = FileCopyUtils.copyToString((Reader)reader);
                            return string;
                        }
                    }
                    break block30;
                    {
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            throw throwable3;
                        }
                    }
                }
            }
            catch (IOException e) {
                _log.error((Object)("[DWSimplifiedLocalReader] LocalReader loadFileContent failed! resource name = " + resourceName), (Throwable)e);
            }
        }
        return null;
    }

    private String loadContent(String module, String xmlNameWithoutExtension, List<DWSimplifiedResourceInfo> resourceInfoList) {
        String content = null;
        ClassLoader classLoader = DWSimplifiedLocalReader.class.getClassLoader();
        try {
            for (DWSimplifiedResourceInfo resourceInfo : resourceInfoList) {
                InputStream inputStream;
                block17: {
                    inputStream = this.getResourceAsStream(classLoader, resourceInfo);
                    if (inputStream == null) continue;
                    try (InputStreamReader reader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);){
                        content = FileCopyUtils.copyToString((Reader)reader);
                        if (content == null) break block17;
                        break;
                    }
                }
                inputStream.close();
            }
        }
        catch (IOException e) {
            _log.error((Object)("[DWSimplifiedLocalReader] LocalReader loadFileContent failed! group name = " + module + ", resource name = " + xmlNameWithoutExtension), (Throwable)e);
        }
        return content;
    }

    private InputStream getResourceAsStream(ClassLoader classLoader, DWSimplifiedResourceInfo resourceInfo) {
        String simplifiedResourceName = resourceInfo.getSimplifiedResourceName();
        InputStream inputStream = classLoader.getResourceAsStream(resourceInfo.getSimplifiedResourceName());
        if (inputStream == null && simplifiedResourceName.startsWith(File.separator)) {
            inputStream = classLoader.getResourceAsStream(simplifiedResourceName.substring(1));
        }
        if (inputStream == null) {
            inputStream = DWSimplifiedResourceManager.getModularMappingResourceAsStream(resourceInfo);
        }
        return inputStream;
    }

    private String getMessageFromProperties(String baseName, Properties properties, boolean keyNotFoundLogDebug, String key, Object ... patternArguments) {
        if (!properties.containsKey(key)) {
            if (keyNotFoundLogDebug) {
                _log.debug((Object)(LocalReader.class.getName() + " resource bundle " + baseName + ", key " + key + " not found"));
            }
            return null;
        }
        String result = (String)properties.get(key);
        if (patternArguments != null) {
            result = String.format(result, patternArguments);
        }
        return result;
    }

    private static DWSimplifiedResourceInfo simplifiedResourceNameResolve(String resourceName) {
        if (resourceName.startsWith("classpath:industry:customization:")) {
            return DWSimplifiedLocalReader.modularCompatibilityResourceNameResolve(resourceName, 1, "classpath:industry:customization:");
        }
        if (resourceName.startsWith("classpath:industry:")) {
            return DWSimplifiedLocalReader.modularCompatibilityResourceNameResolve(resourceName, 0, "classpath:industry:");
        }
        if (resourceName.contains(DWPathUtils.MODE_CLASS_PATH_MODULE_CONFIG_IDENTIFIER)) {
            return DWSimplifiedLocalReader.modularCompatibilityResourceNameResolve(resourceName, DWSimplifiedResourceUtils.BUSINESS_LAYER_STANDARD, "classpath:");
        }
        return DWSimplifiedResourceManager.createNoneMappingInfo(resourceName.substring("classpath:".length()));
    }

    private static DWSimplifiedResourceInfo modularCompatibilityResourceNameResolve(String modularCompatibilityResourceName, int layerIndex, String layerPathPrefix) {
        if (!DWSimplifiedResourceUtils.isBusinessLayerValid(layerIndex)) {
            return null;
        }
        String fileName = modularCompatibilityResourceName.substring(layerPathPrefix.length());
        String fileExtensionName = FilenameUtils.getExtension((String)fileName);
        String fileBaseName = fileName.substring(0, fileName.length() - fileExtensionName.length() - 1);
        if (fileBaseName.contains(DWPathUtils.MODE_CLASS_PATH_MODULE_CONFIG_IDENTIFIER)) {
            fileBaseName = fileBaseName.substring(fileBaseName.indexOf(DWPathUtils.MODE_CLASS_PATH_MODULE_CONFIG_IDENTIFIER) + DWPathUtils.MODE_CLASS_PATH_MODULE_CONFIG_IDENTIFIER.length());
            String groupName = fileName.substring(0, fileName.indexOf(DWPathUtils.MODE_CLASS_PATH_MODULE_CONFIG_IDENTIFIER));
            if (groupName.startsWith(File.separator)) {
                groupName = groupName.substring(1);
            }
            if (Objects.equals("module", fileBaseName)) {
                return DWSimplifiedResourceManager.createDefaultConfigMappingInfo(groupName, layerIndex);
            }
        }
        String extensionId = DWSimplifiedResourceUtils.getBusinessLayerIdentifier(layerIndex);
        return DWSimplifiedResourceManager.createNoneMappingInfo(fileBaseName + extensionId + "." + fileExtensionName);
    }

    private Properties getPlatformI18nProperties(String baseName, Locale locale) {
        String realBaseName = DWSimplifiedI18nPropertiesUtils.getPlatformBaseName(baseName);
        Properties platformI18nProperties = this.loadI18nProperties(null, realBaseName, locale, processedLocale -> DWSimplifiedResourceManager.createPlatformI18nMappingInfo(baseName, processedLocale));
        return platformI18nProperties;
    }

    public Properties getApplicationI18nProperties(String baseName, Locale locale) {
        Properties mergedProperties = new Properties();
        Properties layerProperties = this.getPlatformI18nProperties(baseName, locale);
        mergedProperties.putAll((Map<?, ?>)layerProperties);
        String realBaseName = DWSimplifiedI18nPropertiesUtils.getApplicationBaseName(DWSimplifiedResourceUtils.BUSINESS_LAYER_STANDARD, baseName);
        List<String> extensionBaseNameList = DWSimplifiedI18nPropertiesUtils.getBaseNameOverrideList(realBaseName);
        int maxLayerIndex = extensionBaseNameList.size() - 1;
        for (int i = extensionBaseNameList.size() - 1; i >= 0; --i) {
            int layerIndex = maxLayerIndex - i - 1;
            String cachedKey = extensionBaseNameList.get(i);
            layerProperties = this.loadI18nProperties(null, cachedKey, locale, processedLocale -> DWSimplifiedResourceManager.createApplicationI18nMappingInfo(layerIndex, baseName, processedLocale));
            mergedProperties.putAll((Map<?, ?>)layerProperties);
        }
        return mergedProperties;
    }

    public Properties getModuleI18nProperties(String groupName, String baseName, Locale locale) {
        Properties mergedProperties = new Properties();
        List<String> extensionBaseNameList = DWSimplifiedI18nPropertiesUtils.getGroupBaseNameOverrideList(groupName, baseName);
        int maxLayerIndex = extensionBaseNameList.size() - 1;
        for (int i = extensionBaseNameList.size() - 1; i >= 0; --i) {
            int layerIndex = maxLayerIndex - i - 1;
            String cachedKey = extensionBaseNameList.get(i);
            Properties layerProperties = this.loadI18nProperties(null, cachedKey, locale, processedLocale -> DWSimplifiedResourceManager.createGroupI18nMappingInfo(groupName, layerIndex, baseName, processedLocale));
            mergedProperties.putAll((Map<?, ?>)layerProperties);
        }
        return mergedProperties;
    }
}

