/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.resource.simplified.utils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class DWSimplifiedRuntimeConfigValueReplacer {
    private static String logName = "config-replacer.log";
    private static File logFile = new File(logName);
    private static FileOutputStream logOutputStream;

    public static void main(String[] args) throws Exception {
        try {
            logFile.createNewFile();
            logOutputStream = new FileOutputStream(logFile, true);
            DWSimplifiedRuntimeConfigValueReplacer.logStartProgress();
            DWSimplifiedRuntimeConfigValueReplacer.logLogInfo();
            if (args != null && args.length > 0 && Objects.equals("sedMode", args[0])) {
                DWSimplifiedRuntimeConfigValueReplacer.sedMode(args);
            } else {
                DWSimplifiedRuntimeConfigValueReplacer.replacerMode(args);
            }
            DWSimplifiedRuntimeConfigValueReplacer.logCompletedProgress();
        }
        catch (Exception e) {
            DWSimplifiedRuntimeConfigValueReplacer.logError(e);
        }
        finally {
            logOutputStream.close();
        }
    }

    private static Map<String, String> getEnvironmentVariableMap() throws IOException {
        String envVarInfo;
        DWSimplifiedRuntimeConfigValueReplacer.logCaption("Environment Variables");
        Map<String, String> envVariables = System.getenv();
        HashMap<String, String> realEnvVariables = new HashMap<String, String>();
        HashMap<String, String> beforeReplaceEnvVariableNameMap = new HashMap<String, String>();
        int count = 0;
        for (Map.Entry<String, String> sourceEnvVariable : envVariables.entrySet()) {
            String realEnvVariableValue;
            ++count;
            String realEnvVariableName = sourceEnvVariable.getKey();
            boolean recordOldVariableName = false;
            if (realEnvVariableName.contains("_")) {
                realEnvVariableName = realEnvVariableName.replaceAll("_", ".");
                recordOldVariableName = true;
            }
            if (realEnvVariableName.contains("DH")) {
                realEnvVariableName = realEnvVariableName.replaceAll("DH", "-");
            }
            envVarInfo = String.format("%03d.[ %s ]", count, realEnvVariableName);
            if (!Objects.equals(sourceEnvVariable.getKey(), realEnvVariableName)) {
                envVarInfo = envVarInfo + " <-" + sourceEnvVariable.getKey();
            }
            if ((realEnvVariableValue = sourceEnvVariable.getValue()).contains("@space@")) {
                realEnvVariableValue = realEnvVariableValue.replaceAll("@space@", " ");
            }
            envVarInfo = envVarInfo + String.format(" = [ %s ]", realEnvVariableValue);
            if (!Objects.equals(sourceEnvVariable.getValue(), realEnvVariableValue)) {
                envVarInfo = envVarInfo + " <- " + sourceEnvVariable.getValue();
            }
            String variableNameToken = "@" + realEnvVariableName + "@";
            realEnvVariables.put(variableNameToken, realEnvVariableValue);
            if (recordOldVariableName) {
                beforeReplaceEnvVariableNameMap.put(sourceEnvVariable.getKey(), variableNameToken);
            }
            DWSimplifiedRuntimeConfigValueReplacer.logInfo(envVarInfo);
        }
        if (beforeReplaceEnvVariableNameMap.size() > 0) {
            DWSimplifiedRuntimeConfigValueReplacer.logInfo("VVV Variable Contains '_' List VVV");
            for (Map.Entry item : beforeReplaceEnvVariableNameMap.entrySet()) {
                if (realEnvVariables.containsKey(item.getKey())) continue;
                String key = (String)item.getKey();
                String value = (String)realEnvVariables.get(item.getValue());
                envVarInfo = String.format("%03d.[ %s ]", ++count, key);
                envVarInfo = envVarInfo + String.format(" = [ %s ]", value);
                realEnvVariables.put("@" + key + "@", value);
                DWSimplifiedRuntimeConfigValueReplacer.logInfo(envVarInfo);
            }
            DWSimplifiedRuntimeConfigValueReplacer.logInfo("^^^ Variable Contains '_' List ^^^");
        }
        DWSimplifiedRuntimeConfigValueReplacer.logLineSeparator();
        return realEnvVariables;
    }

    private static List<File> getTargetFileList(File file, String fileExtension, List<String> excludeFileNameList) throws IOException {
        DWSimplifiedRuntimeConfigValueReplacer.logCaption("File List");
        List<Object> replaceTargetList = new ArrayList<File>();
        if (file.isDirectory()) {
            replaceTargetList = Files.walk(Paths.get(file.getAbsolutePath(), new String[0]), new FileVisitOption[0]).filter(f -> {
                File currentFile = f.toFile();
                return currentFile.isFile() && currentFile.getName().endsWith("." + fileExtension) && !excludeFileNameList.contains(currentFile.getName());
            }).map(f -> f.toFile()).collect(Collectors.toList());
        } else {
            file.getName().endsWith("." + fileExtension);
            replaceTargetList.add(file);
        }
        if (replaceTargetList.size() > 0) {
            List candidateList = replaceTargetList.stream().map(f -> f.getName()).collect(Collectors.toList());
            DWSimplifiedRuntimeConfigValueReplacer.logInfo(String.join((CharSequence)System.lineSeparator(), candidateList));
        } else {
            DWSimplifiedRuntimeConfigValueReplacer.logWarning("There is no any config file need to replace!");
        }
        DWSimplifiedRuntimeConfigValueReplacer.logLineSeparator();
        return replaceTargetList;
    }

    private static void replaceConfigVariableValue(List<File> fileList, String fileExtension, Map<String, String> envVarMap) throws IOException {
        if (fileList.size() == 0) {
            return;
        }
        DWSimplifiedRuntimeConfigValueReplacer.logCaption("Replacement Progress");
        boolean updateFile = false;
        boolean existVariables = false;
        ArrayList replacedLineList = new ArrayList();
        int i = 0;
        for (File targetFile : fileList) {
            DWSimplifiedRuntimeConfigValueReplacer.logInfo(++i + "." + targetFile.getName() + " - " + targetFile.getPath());
            replacedLineList.clear();
            try {
                List<String> fileContent = Files.readAllLines(Paths.get(targetFile.getAbsolutePath(), new String[0]), StandardCharsets.UTF_8);
                for (int j = 0; j < fileContent.size(); ++j) {
                    existVariables = false;
                    String singleLine = fileContent.get(j);
                    for (Map.Entry<String, String> item : envVarMap.entrySet()) {
                        if (!singleLine.contains(item.getKey())) continue;
                        updateFile = true;
                        existVariables = true;
                        String replacedLine = singleLine.replaceAll(Pattern.quote(item.getKey()), item.getValue());
                        DWSimplifiedRuntimeConfigValueReplacer.logInfo("   >>>" + replacedLine + " <- " + singleLine);
                        singleLine = replacedLine;
                    }
                    if (!existVariables) continue;
                    fileContent.set(j, singleLine);
                }
                if (updateFile) {
                    DWSimplifiedRuntimeConfigValueReplacer.logInfo("...New Content Write to file...");
                    FileWriter writer = new FileWriter(targetFile);
                    Object object = null;
                    try {
                        for (String line : fileContent) {
                            writer.write(line + System.lineSeparator());
                        }
                    }
                    catch (Throwable throwable) {
                        object = throwable;
                        throw throwable;
                    }
                    finally {
                        if (writer != null) {
                            if (object != null) {
                                try {
                                    writer.close();
                                }
                                catch (Throwable throwable) {
                                    ((Throwable)object).addSuppressed(throwable);
                                }
                            } else {
                                writer.close();
                            }
                        }
                    }
                    DWSimplifiedRuntimeConfigValueReplacer.logInfo("...Replacement is completed!");
                    continue;
                }
                DWSimplifiedRuntimeConfigValueReplacer.logInfo("...Nothing to replace...");
            }
            catch (Exception e) {
                DWSimplifiedRuntimeConfigValueReplacer.logError(e);
            }
        }
        DWSimplifiedRuntimeConfigValueReplacer.logLineSeparator();
    }

    private static void replacerMode(String[] args) throws IOException {
        DWSimplifiedRuntimeConfigValueReplacer.logInfo("- DAP Config File Variables Value Replacer v0.1 -");
        DWSimplifiedRuntimeConfigValueReplacer.logCaption("Input arguments");
        if (args == null || args.length < 2) {
            DWSimplifiedRuntimeConfigValueReplacer.logError("Your input args is null or total number is less than two!");
            return;
        }
        String targetPath = args[0];
        File targetPathFile = new File(targetPath);
        DWSimplifiedRuntimeConfigValueReplacer.logInfo("1.Target path = " + targetPath);
        DWSimplifiedRuntimeConfigValueReplacer.logInfo("   >>> absolute target path = " + targetPathFile.getAbsolutePath());
        DWSimplifiedRuntimeConfigValueReplacer.logInfo("   >>> is exist ? = " + targetPathFile.exists());
        if (!targetPathFile.exists()) {
            DWSimplifiedRuntimeConfigValueReplacer.logWarning("!Target path is not exists!");
            return;
        }
        if (targetPathFile.isDirectory()) {
            DWSimplifiedRuntimeConfigValueReplacer.logInfo("   >>> this is a directory!");
        } else {
            DWSimplifiedRuntimeConfigValueReplacer.logInfo("   >>> this is a file!");
        }
        String fileExtension = args[1];
        DWSimplifiedRuntimeConfigValueReplacer.logInfo("2.File extension = " + fileExtension);
        ArrayList<String> excludeFileNameList = new ArrayList<String>();
        for (int i = 0; i < 4; ++i) {
            if (args.length <= 2 + i) continue;
            excludeFileNameList.add(args[2 + i]);
        }
        DWSimplifiedRuntimeConfigValueReplacer.logInfo("3.Exclude file names = " + excludeFileNameList);
        DWSimplifiedRuntimeConfigValueReplacer.logLineSeparator();
        Map<String, String> envVarMap = DWSimplifiedRuntimeConfigValueReplacer.getEnvironmentVariableMap();
        List<File> targetFileList = DWSimplifiedRuntimeConfigValueReplacer.getTargetFileList(targetPathFile, fileExtension, excludeFileNameList);
        DWSimplifiedRuntimeConfigValueReplacer.replaceConfigVariableValue(targetFileList, fileExtension, envVarMap);
    }

    private static void sedMode(String[] args) throws IOException {
        DWSimplifiedRuntimeConfigValueReplacer.logCaption("*** Sed Mode ***");
        DWSimplifiedRuntimeConfigValueReplacer.logCaption("Input arguments");
        if (args.length < 4) {
            DWSimplifiedRuntimeConfigValueReplacer.logError("Your input args total number is less than four!");
        } else {
            String regex = args[1];
            String replacement = args[2];
            String fileName = args[3];
            File targetFile = new File(fileName);
            DWSimplifiedRuntimeConfigValueReplacer.logInfo("1.Target file = " + targetFile.getName() + " - " + targetFile.getPath());
            DWSimplifiedRuntimeConfigValueReplacer.logInfo("   >>> is exist ? = " + targetFile.exists());
            DWSimplifiedRuntimeConfigValueReplacer.logInfo("   >>> is file ? = " + targetFile.isFile());
            DWSimplifiedRuntimeConfigValueReplacer.logInfo("2.Regex = [ " + regex + " ]");
            DWSimplifiedRuntimeConfigValueReplacer.logInfo(String.format("3.Replacement = [ %s ]", replacement));
            if (targetFile.isFile()) {
                DWSimplifiedRuntimeConfigValueReplacer.logWarning("The function is not implementation yet!");
            } else {
                DWSimplifiedRuntimeConfigValueReplacer.logError("Your target file is not exist or not a file!");
            }
        }
    }

    private static void logWarning(String log) throws IOException {
        DWSimplifiedRuntimeConfigValueReplacer.log("WARN", log);
    }

    private static void logInfo(String log) throws IOException {
        DWSimplifiedRuntimeConfigValueReplacer.log("INFO", log);
    }

    private static void logError(Throwable e) throws IOException {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        String stackTrace = sw.toString();
        DWSimplifiedRuntimeConfigValueReplacer.logError(stackTrace);
    }

    private static void logError(String log) throws IOException {
        DWSimplifiedRuntimeConfigValueReplacer.log("ERROR", log);
    }

    private static void logLogInfo() throws IOException {
        DWSimplifiedRuntimeConfigValueReplacer.logLineSeparator();
        DWSimplifiedRuntimeConfigValueReplacer.logCaption("Log Info");
        DWSimplifiedRuntimeConfigValueReplacer.logInfo("Replacer Log Location = " + logFile.getAbsolutePath());
        DWSimplifiedRuntimeConfigValueReplacer.logLineSeparator();
    }

    private static void logCaption(String caption) throws IOException {
        DWSimplifiedRuntimeConfigValueReplacer.logInfo(String.format("< %s >", caption));
        DWSimplifiedRuntimeConfigValueReplacer.logInfo("--------------------------------");
    }

    private static void logLineSeparator() throws IOException {
        DWSimplifiedRuntimeConfigValueReplacer.log("INFO", "===========================================================");
    }

    private static void logStartProgress() throws IOException {
        DWSimplifiedRuntimeConfigValueReplacer.logInfo("++++++++++++++++++++ Progress Starting ++++++++++++++++++++");
    }

    private static void logCompletedProgress() throws IOException {
        DWSimplifiedRuntimeConfigValueReplacer.logInfo("++++++++++++++++++++ Progress Completed ++++++++++++++++++++");
    }

    private static void log(String caption, String log) throws IOException {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        String nowString = dateFormat.format(Calendar.getInstance().getTime());
        String message = String.format("%s [%5s] %s%s", nowString, caption, log, System.lineSeparator());
        System.out.print(message);
        logOutputStream.write(message.getBytes());
        logOutputStream.flush();
    }
}

