/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.resource.simplified;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Paths;
import java.util.function.Function;
import java.util.jar.JarFile;

public class DWSimplifiedGroupLocationInfo {
    private String name;
    private URL url;
    private int businessLayer;
    private Boolean isClassPath = null;

    public String getName() {
        return this.name;
    }

    public DWSimplifiedGroupLocationInfo(String groupName) {
        this.name = groupName;
    }

    public int getBusinessLayer() {
        return this.businessLayer;
    }

    public void setBusinessLayer(int businessLayer) {
        this.businessLayer = businessLayer;
    }

    public URL getData() {
        return this.url;
    }

    public void setData(URL url) {
        this.url = url;
    }

    public boolean isClassPath() throws URISyntaxException {
        if (this.isClassPath == null) {
            File targetFile = Paths.get(this.getData().toURI()).toFile();
            this.isClassPath = targetFile.isDirectory();
        }
        return this.isClassPath;
    }

    public static File createClassPath(DWSimplifiedGroupLocationInfo groupInfo) throws URISyntaxException {
        return Paths.get(groupInfo.getData().toURI()).toFile();
    }

    public static JarFile createJarFile(DWSimplifiedGroupLocationInfo groupInfo) throws IOException, URISyntaxException {
        return new JarFile(groupInfo.getData().toURI().getPath());
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(Function<Integer, String> layerNameProvider) {
        String layerName = null;
        if (layerNameProvider != null) {
            layerName = layerNameProvider.apply(this.businessLayer);
        }
        String layerDisplayName = layerName == null || layerName.isEmpty() ? String.format("%2d", this.businessLayer) : String.format("%2d", this.businessLayer) + " - " + layerName;
        try {
            return "Layer=" + layerDisplayName + ", Uri=" + this.url.toURI().getPath() + ", Name='" + this.name;
        }
        catch (URISyntaxException e) {
            return "Layer=" + layerDisplayName + ", Url=" + this.url + ", Name='" + this.name;
        }
    }
}

