/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.resource.simplified.utils;

import com.digiwin.app.container.exceptions.DWRuntimeException;
import com.digiwin.resource.simplified.DWSimplifiedGroupLocationInfo;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DWSimplifiedResourceUtils {
    private static Log log = LogFactory.getLog(DWSimplifiedResourceUtils.class);
    public static final String CATEGORY_PLATFORM = "platform";
    public static final String CATEGORY_APPLICATION = "application";
    public static final String RESOURCE_LOCATION_DAP_INFO = "META-INF/dap.info";
    public static final String RESOURCE_LOCATION_MODULAR_COMPATIBLE_GROUP_SPRING_XML = "spring-module.xml";
    public static final String DAP_INFO_KEY_GROUP_NAME = "group.name";
    public static final String DAP_INFO_KEY_BUSINESS_EXTENSION_LAYER = "business.extension.layer";
    private static final String CATEGORY_GROUP_FORMAT = "G_%s";
    public static String REGEX_IDENTIFIER_GROUP = "-G_(.{1,})\\.jar";
    private static Pattern PATTERN_IDENTIFIER_GROUP = Pattern.compile(REGEX_IDENTIFIER_GROUP);
    public static int BUSINESS_LAYER_STANDARD = -1;
    private static boolean init = false;
    private static List<String> businessExtLayers;
    private static List<String> businessExtLayersIdList;
    private static List<String> businessExtLayersOverrideIdList;

    public static void initBusinessExtensionLayers(String layersString) {
        List<String> layers = null;
        if (layersString != null && (layersString = layersString.trim()).length() > 0) {
            layers = Arrays.asList(layersString.split(","));
        }
        DWSimplifiedResourceUtils.initBusinessExtensionLayers(layers);
    }

    public static void initBusinessExtensionLayers(List<String> layers) {
        int i;
        if (layers == null) {
            businessExtLayers = Collections.emptyList();
        } else {
            for (i = 0; i < layers.size(); ++i) {
                String currentLayer = layers.get(i);
                if ((currentLayer = currentLayer.trim()).length() != 0) continue;
                throw new IllegalArgumentException(String.format("layer index=%s value can not be empty!", i));
            }
            businessExtLayers = Collections.unmodifiableList(layers);
        }
        ArrayList<String> idList = new ArrayList<String>();
        for (i = 0; i < businessExtLayers.size(); ++i) {
            idList.add("_" + String.join((CharSequence)"_", businessExtLayers.subList(0, i + 1)));
        }
        businessExtLayersIdList = Collections.unmodifiableList(idList);
        businessExtLayersOverrideIdList = Lists.reverse(businessExtLayersIdList);
        init = true;
    }

    public static boolean hasBusinessExtensionLayers() {
        return DWSimplifiedResourceUtils.getBusinessExtensionLayerNameList().size() > 0;
    }

    public static List<String> getBusinessExtensionLayerNameList() {
        if (!init) {
            throw new DWRuntimeException("DWSimplifiedResourceUtils is not initialized, please contact DAP for this issue.");
        }
        return businessExtLayers;
    }

    public static boolean isBusinessStandardLayer(int layerIndex) {
        return layerIndex <= BUSINESS_LAYER_STANDARD;
    }

    public static boolean isBusinessLayerValid(int layerIndex) {
        return layerIndex < DWSimplifiedResourceUtils.getBusinessExtensionLayerNameList().size();
    }

    public static void validateBusinessLayer(int layerIndex) throws IllegalArgumentException {
        if (!DWSimplifiedResourceUtils.isBusinessLayerValid(layerIndex)) {
            throw new IllegalArgumentException(String.format("validation layer=%s is larger than max layer=%s!", layerIndex, DWSimplifiedResourceUtils.getBusinessExtensionLayerNameList().size()));
        }
    }

    public static String getBusinessLayerName(int layerIndex) {
        if (layerIndex <= BUSINESS_LAYER_STANDARD) {
            return "";
        }
        if (layerIndex > DWSimplifiedResourceUtils.getBusinessExtensionLayerNameList().size()) {
            return null;
        }
        return DWSimplifiedResourceUtils.getBusinessExtensionLayerNameList().get(layerIndex);
    }

    public static Integer getBusinessLayerIndex(String layerName) {
        if (layerName == null || layerName.length() == 0) {
            return BUSINESS_LAYER_STANDARD;
        }
        int index = DWSimplifiedResourceUtils.getBusinessExtensionLayerNameList().indexOf(layerName);
        return index == -1 ? null : Integer.valueOf(index);
    }

    public static int getBusinessExtensionMaxLayerIndex() {
        return DWSimplifiedResourceUtils.getBusinessExtensionLayerNameList().size() - 1;
    }

    public static List<String> getBusinessExtensionLayersIdList() {
        DWSimplifiedResourceUtils.getBusinessExtensionLayerNameList();
        return businessExtLayersIdList;
    }

    public static List<String> getBusinessExtensionLayersIdOverrideList() {
        DWSimplifiedResourceUtils.getBusinessExtensionLayerNameList();
        return businessExtLayersOverrideIdList;
    }

    public static String getBusinessLayerIdentifier(int layerIndex) {
        if (DWSimplifiedResourceUtils.isBusinessStandardLayer(layerIndex)) {
            return "";
        }
        DWSimplifiedResourceUtils.validateBusinessLayer(layerIndex);
        return DWSimplifiedResourceUtils.getBusinessExtensionLayersIdList().get(layerIndex);
    }

    public static String getApplicationPropertiesName(int layerIndex, boolean withExtensionName) {
        return DWSimplifiedResourceUtils.getApplicationFileName(layerIndex, null, withExtensionName ? "properties" : null);
    }

    public static String getApplicationFileName(int layerIndex, String prefix) {
        return DWSimplifiedResourceUtils.getApplicationFileName(layerIndex, prefix, null);
    }

    public static String getApplicationFileName(int layerIndex, String prefix, String extensionName) {
        return DWSimplifiedResourceUtils.getApplicationFileName(layerIndex, prefix, null, extensionName);
    }

    public static String getApplicationFileName(int layerIndex, String prefix, String suffix, String extensionName) {
        String fileNameBase = CATEGORY_APPLICATION + DWSimplifiedResourceUtils.getBusinessLayerIdentifier(layerIndex);
        return DWSimplifiedResourceUtils.getFileName(prefix, fileNameBase, suffix, extensionName);
    }

    public static List<String> getApplicationFileNameOverrideList(String prefix, String suffix, String extensionName) {
        return DWSimplifiedResourceUtils.getFileNameOverrideList(prefix, CATEGORY_APPLICATION, suffix, extensionName);
    }

    public static List<String> getFileBaseNameOverrideList(String fileBaseName) {
        List<String> extensionLayerIdList = DWSimplifiedResourceUtils.getBusinessExtensionLayersIdOverrideList();
        List<String> allLayerBaseNameList = extensionLayerIdList.stream().map(n -> fileBaseName + n).collect(Collectors.toList());
        allLayerBaseNameList.add(fileBaseName);
        return allLayerBaseNameList;
    }

    public static String getPlatformFileName(String prefix) {
        return DWSimplifiedResourceUtils.getPlatformFileName(prefix, null);
    }

    public static String getPlatformFileName(String prefix, String extensionName) {
        return DWSimplifiedResourceUtils.getPlatformFileName(prefix, null, extensionName);
    }

    public static String getPlatformFileName(String prefix, String suffix, String extensionName) {
        String fileNameBase = CATEGORY_PLATFORM;
        return DWSimplifiedResourceUtils.getFileName(prefix, fileNameBase, suffix, extensionName);
    }

    public static String getGroupFileName(String groupName, int layerIndex, String prefix) {
        return DWSimplifiedResourceUtils.getGroupFileName(groupName, layerIndex, prefix, null);
    }

    public static String getGroupFileName(String groupName, int layerIndex, String prefix, String extensionName) {
        return DWSimplifiedResourceUtils.getGroupFileName(groupName, layerIndex, prefix, null, extensionName);
    }

    public static String getGroupFileName(String groupName, int layerIndex, String prefix, String suffix, String extensionName) {
        if (groupName == null || groupName.length() == 0) {
            throw new IllegalArgumentException("groupName is null or empty!");
        }
        String fileNameBase = String.format(CATEGORY_GROUP_FORMAT, groupName) + DWSimplifiedResourceUtils.getBusinessLayerIdentifier(layerIndex);
        return DWSimplifiedResourceUtils.getFileName(prefix, fileNameBase, suffix, extensionName);
    }

    public static List<String> getGroupFileNameOverrideList(String groupName, String prefix, String suffix, String extensionName) {
        if (groupName == null || groupName.length() == 0) {
            throw new IllegalArgumentException("groupName is null or empty!");
        }
        String fileNameBase = String.format(CATEGORY_GROUP_FORMAT, groupName);
        return DWSimplifiedResourceUtils.getFileNameOverrideList(prefix, fileNameBase, suffix, extensionName);
    }

    public static DWSimplifiedGroupLocationInfo getGroupName(URI uri) throws IOException {
        return DWSimplifiedResourceUtils.getGroupName(Paths.get(uri).toFile());
    }

    public static DWSimplifiedGroupLocationInfo getGroupName(File file) throws IOException {
        if (!file.exists()) {
            return null;
        }
        DWSimplifiedGroupLocationInfo groupInfo = null;
        if (file.isDirectory()) {
            Path dapInfoPath = Paths.get(file.getPath(), RESOURCE_LOCATION_DAP_INFO);
            if (Files.exists(dapInfoPath, new LinkOption[0])) {
                Properties dapInfo = new Properties();
                try (FileInputStream s = new FileInputStream(dapInfoPath.toString());){
                    dapInfo.load(s);
                    groupInfo = DWSimplifiedResourceUtils.createGroupInfo(dapInfo);
                }
                catch (Exception exception) {}
            }
        } else {
            DWSimplifiedGroupLocationInfo groupInfoInJar = null;
            groupInfo = DWSimplifiedResourceUtils.getGroupNameFromFileName(file.getName());
            if (file.getName().toLowerCase().endsWith("jar")) {
                groupInfoInJar = DWSimplifiedResourceUtils.getGroupNameInJar(file);
                if (groupInfo == null) {
                    groupInfo = groupInfoInJar;
                }
            }
            if (!(groupInfoInJar == null || groupInfo.getName().equals(groupInfoInJar.getName()) && groupInfo.getBusinessLayer() == groupInfoInJar.getBusinessLayer())) {
                throw new DWRuntimeException(String.format("dap info is different between jar file name(%s) and inside jar dap.info is different!", file.getAbsolutePath()));
            }
        }
        return groupInfo;
    }

    private static DWSimplifiedGroupLocationInfo createGroupInfo(Properties dapInfoProperties) throws IOException {
        DWSimplifiedGroupLocationInfo groupInfo = null;
        String groupName = dapInfoProperties.getProperty(DAP_INFO_KEY_GROUP_NAME);
        if (groupName != null && (groupName = groupName.trim()).length() > 0) {
            groupInfo = new DWSimplifiedGroupLocationInfo(groupName);
            String extensionLayerName = dapInfoProperties.getProperty(DAP_INFO_KEY_BUSINESS_EXTENSION_LAYER);
            int layerIndex = DWSimplifiedResourceUtils.getBusinessLayerIndex(extensionLayerName);
            groupInfo.setBusinessLayer(layerIndex);
        }
        return groupInfo;
    }

    private static DWSimplifiedGroupLocationInfo getGroupNameInJar(File file) throws IOException {
        DWSimplifiedGroupLocationInfo groupInfo = null;
        JarFile jarFile = new JarFile(file);
        ZipEntry dapInfoZip = jarFile.getEntry(RESOURCE_LOCATION_DAP_INFO);
        if (dapInfoZip != null) {
            Properties dapInfoProperties = new Properties();
            try (InputStream jarInputStream = jarFile.getInputStream(dapInfoZip);){
                dapInfoProperties.load(jarInputStream);
                groupInfo = DWSimplifiedResourceUtils.createGroupInfo(dapInfoProperties);
            }
        }
        return groupInfo;
    }

    public static DWSimplifiedGroupLocationInfo getGroupNameFromFileName(String fileName) throws IOException {
        if (fileName == null) {
            return null;
        }
        String nameWithoutPath = FilenameUtils.getName((String)fileName);
        String groupName = null;
        DWSimplifiedGroupLocationInfo groupInfo = null;
        int businessLayer = BUSINESS_LAYER_STANDARD;
        Matcher matcher = PATTERN_IDENTIFIER_GROUP.matcher(nameWithoutPath);
        if (matcher.find()) {
            String roughResult = matcher.group(1);
            groupName = roughResult.split("-")[0];
            List<String> extLayerIdList = DWSimplifiedResourceUtils.getBusinessExtensionLayersIdOverrideList();
            for (int i = 0; i < extLayerIdList.size(); ++i) {
                String layerId = extLayerIdList.get(i);
                if (!groupName.endsWith(layerId)) continue;
                groupName = groupName.substring(0, groupName.length() - layerId.length());
                businessLayer = extLayerIdList.size() - i - 1;
                break;
            }
            groupInfo = new DWSimplifiedGroupLocationInfo(groupName);
            groupInfo.setBusinessLayer(businessLayer);
        }
        if (matcher.find()) {
            log.warn((Object)String.format("DWSimplifiedResourceUtils getGroupName(%s) contains more than one group info", fileName));
        }
        return groupInfo;
    }

    public static String getFileName(String prefix, String baseNameBase, String suffix, String extensionName) {
        String fileName = baseNameBase;
        if (prefix != null && prefix.trim().length() > 0) {
            fileName = prefix.trim() + "-" + fileName;
        }
        if (suffix != null && suffix.trim().length() > 0) {
            fileName = fileName + suffix;
        }
        if (extensionName != null && extensionName.trim().length() > 0) {
            fileName = fileName + "." + extensionName.trim();
        }
        return fileName;
    }

    public static List<String> getFileNameOverrideList(String prefix, String fileBaseName, String suffix, String extensionName) {
        List<String> baseNameList = DWSimplifiedResourceUtils.getFileBaseNameOverrideList(fileBaseName);
        return baseNameList.stream().map(layerName -> DWSimplifiedResourceUtils.getFileName(prefix, layerName, suffix, extensionName)).collect(Collectors.toList());
    }
}

