/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.resource.simplified.utils;

import com.digiwin.resource.simplified.utils.DWSimplifiedResourceUtils;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.context.i18n.LocaleContextHolder;

public class DWSimplifiedI18nPropertiesUtils {
    public static final String DEFAULT_BASE_NAME = "message";
    private static ResourceBundle.Control rbc = ResourceBundle.Control.getControl(ResourceBundle.Control.FORMAT_PROPERTIES);

    public static String getApplicationDefaultBaseName(int layerIndex) {
        return DWSimplifiedI18nPropertiesUtils.getApplicationBaseName(layerIndex, DEFAULT_BASE_NAME);
    }

    public static String getApplicationBaseName(int layerIndex, String baseNameBase) {
        return DWSimplifiedResourceUtils.getApplicationFileName(layerIndex, baseNameBase);
    }

    public static List<String> getBaseNameOverrideList(String baseName) {
        List<String> extensionLayerIdList = DWSimplifiedResourceUtils.getBusinessExtensionLayersIdOverrideList();
        List<String> allLayerBaseNameList = extensionLayerIdList.stream().map(n -> baseName + n).collect(Collectors.toList());
        allLayerBaseNameList.add(baseName);
        return allLayerBaseNameList;
    }

    public static List<String> getGroupBaseNameOverrideList(String groupName, String baseNameBase) {
        String groupStandardLayerBaseName = DWSimplifiedResourceUtils.getGroupFileName(groupName, DWSimplifiedResourceUtils.BUSINESS_LAYER_STANDARD, baseNameBase);
        return DWSimplifiedI18nPropertiesUtils.getBaseNameOverrideList(groupStandardLayerBaseName);
    }

    public static String[] getApplicationDefaultI18nFileNames(int layerIndex, boolean withExtensionName) {
        return DWSimplifiedI18nPropertiesUtils.getApplicationDefaultI18nFileNames(layerIndex, withExtensionName, null);
    }

    public static String[] getApplicationDefaultI18nFileNames(int layerIndex, boolean withExtensionName, Locale locale) {
        return DWSimplifiedI18nPropertiesUtils.getApplicationI18nFileNames(layerIndex, DEFAULT_BASE_NAME, withExtensionName, locale);
    }

    public static String[] getApplicationI18nFileNames(int layerIndex, String baseNameBase, boolean withExtensionName) {
        return DWSimplifiedI18nPropertiesUtils.getApplicationI18nFileNames(layerIndex, baseNameBase, withExtensionName, null);
    }

    public static String[] getI18nFileNames(int layerIndex, String baseName, boolean withExtensionName, Locale locale) {
        Set<String> candidateLocaleStringList = DWSimplifiedI18nPropertiesUtils.getCandidateLocaleStringList(baseName, locale);
        return (String[])candidateLocaleStringList.stream().map(localeString -> baseName + (String)(localeString.isEmpty() ? "" : "_" + localeString) + (withExtensionName ? ".properties" : "")).toArray(String[]::new);
    }

    public static String[] getApplicationI18nFileNames(int layerIndex, String baseNameBase, boolean withExtensionName, Locale locale) {
        String baseName = DWSimplifiedI18nPropertiesUtils.getApplicationDefaultBaseName(layerIndex);
        Set<String> candidateLocaleStringList = DWSimplifiedI18nPropertiesUtils.getCandidateLocaleStringList(baseName, locale);
        return (String[])candidateLocaleStringList.stream().map(localeString -> DWSimplifiedResourceUtils.getApplicationFileName(layerIndex, baseNameBase, (String)(localeString.isEmpty() ? "" : "_" + localeString), withExtensionName ? "properties" : null)).toArray(String[]::new);
    }

    public static String getPlatformDefaultBaseName() {
        return DWSimplifiedResourceUtils.getPlatformFileName(DEFAULT_BASE_NAME);
    }

    public static String getPlatformBaseName(String baseNameBase) {
        return DWSimplifiedResourceUtils.getPlatformFileName(baseNameBase);
    }

    public static String[] getPlatformDefaultI18nFileNames(boolean withExtensionName) {
        return DWSimplifiedI18nPropertiesUtils.getPlatformDefaultI18nFileNames(withExtensionName, null);
    }

    public static String[] getPlatformDefaultI18nFileNames(boolean withExtensionName, Locale locale) {
        return DWSimplifiedI18nPropertiesUtils.getPlatformI18nFileNames(DEFAULT_BASE_NAME, withExtensionName, locale);
    }

    public static String[] getPlatformI18nFileNames(String baseNameBase, boolean withExtensionName) {
        return DWSimplifiedI18nPropertiesUtils.getPlatformI18nFileNames(baseNameBase, withExtensionName, null);
    }

    public static String[] getPlatformI18nFileNames(String baseNameBase, boolean withExtensionName, Locale locale) {
        String baseName = DWSimplifiedI18nPropertiesUtils.getPlatformBaseName(baseNameBase);
        Set<String> candidateLocaleStringList = DWSimplifiedI18nPropertiesUtils.getCandidateLocaleStringList(baseName, locale);
        return (String[])candidateLocaleStringList.stream().map(localeString -> DWSimplifiedResourceUtils.getPlatformFileName(baseNameBase, (String)(localeString.isEmpty() ? "" : "_" + localeString), withExtensionName ? "properties" : null)).toArray(String[]::new);
    }

    public static String getGroupBaseName(String groupName, String baseNameBase, int layerIndex) {
        return DWSimplifiedResourceUtils.getGroupFileName(groupName, layerIndex, baseNameBase);
    }

    public static String getGroupDefaultBaseName(String groupName, int layerIndex) {
        return DWSimplifiedResourceUtils.getGroupFileName(groupName, layerIndex, DEFAULT_BASE_NAME);
    }

    public static String[] getGroupDefaultI18nFileNames(String groupName, int layerIndex, boolean withExtensionName) {
        return DWSimplifiedI18nPropertiesUtils.getGroupDefaultI18nFileNames(groupName, layerIndex, withExtensionName, null);
    }

    public static String[] getGroupDefaultI18nFileNames(String groupName, int layerIndex, boolean withExtensionName, Locale locale) {
        return DWSimplifiedI18nPropertiesUtils.getGroupI18nFileNames(groupName, DEFAULT_BASE_NAME, layerIndex, withExtensionName, locale);
    }

    public static String[] getGroupI18nFileNames(String groupName, String baseNameBase, int layerIndex, boolean withExtensionName) {
        return DWSimplifiedI18nPropertiesUtils.getGroupI18nFileNames(groupName, baseNameBase, layerIndex, withExtensionName, null);
    }

    public static String[] getGroupI18nFileNames(String groupName, String baseNameBase, int layerIndex, boolean withExtensionName, Locale locale) {
        String groupBaseName = DWSimplifiedI18nPropertiesUtils.getGroupBaseName(groupName, baseNameBase, layerIndex);
        Set<String> candidateLocaleStringList = DWSimplifiedI18nPropertiesUtils.getCandidateLocaleStringList(groupBaseName, locale);
        return (String[])candidateLocaleStringList.stream().map(localeString -> DWSimplifiedResourceUtils.getGroupFileName(groupName, layerIndex, DEFAULT_BASE_NAME, (String)(localeString.isEmpty() ? "" : "_" + localeString), withExtensionName ? "properties" : null)).toArray(String[]::new);
    }

    public static Set<String> getCandidateLocaleStringList(String baseName, Locale locale) {
        if (locale == null) {
            locale = LocaleContextHolder.getLocale();
        }
        List<Locale> localeList = rbc.getCandidateLocales(baseName, locale);
        Set candidateSet = localeList.stream().filter(l -> l.getScript().length() == 0 && l.getVariant().length() == 0).map(Locale::toString).collect(Collectors.toCollection(LinkedHashSet::new));
        return candidateSet;
    }
}

