/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.resource.simplified;

import com.digiwin.app.container.exceptions.DWRuntimeException;
import com.digiwin.resource.simplified.DWSimplifiedGroupLocationInfo;
import com.digiwin.resource.simplified.DWSimplifiedResourceInfo;
import com.digiwin.resource.simplified.utils.DWSimplifiedConfigPropertiesUtils;
import com.digiwin.resource.simplified.utils.DWSimplifiedI18nPropertiesUtils;
import com.digiwin.resource.simplified.utils.DWSimplifiedResourceUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DWSimplifiedResourceManager {
    private static Log log = LogFactory.getLog(DWSimplifiedResourceManager.class);
    private static boolean completed = false;
    private static ThreadLocal<Boolean> suspendCheckStatus = new ThreadLocal();
    private static Map<String, DWGroupLocationManager> locationInfoMap = new HashMap<String, DWGroupLocationManager>();
    private static final String RESOURCE_NAME_MODULAR_MODULE_PROPERTIES = "module.properties";
    private static final String RESOURCE_NAME_MODULAR_MODULE_DEFAULT_SPRING_XML_NAME = "spring-module";
    private static final String RESOURCE_NAME_SIMPLIFIED_GROUP_DEFAULT_SPRING_XML_NAME = "spring";
    private static Map<String, DWSimplifiedResourceInfo> groupDefaultResourceInfo = new HashMap<String, DWSimplifiedResourceInfo>();
    private static List<String> excludedGroupList;
    private static Set<String> incompleteRequestPropertyNameSet;

    public DWSimplifiedResourceManager(List<String> excludeGroupList) {
        if (excludeGroupList == null) {
            excludeGroupList = Collections.emptyList();
        }
        excludedGroupList = excludeGroupList;
        log.warn((Object)String.format("*** DAP Excluded Group List: %s", excludeGroupList));
    }

    public void registerGroup(DWSimplifiedGroupLocationInfo groupInfo) {
        if (completed) {
            throw new DWRuntimeException("DWSimplifiedResourceManager is completed, you can not register group any more, please contact DAP for this issue.");
        }
        DWGroupLocationManager groupResourceInfo = locationInfoMap.computeIfAbsent(groupInfo.getName(), key -> new DWGroupLocationManager(groupInfo.getName()));
        this.createResourceInfo(groupInfo, groupResourceInfo);
    }

    private void createResourceInfo(DWSimplifiedGroupLocationInfo groupInfo, DWGroupLocationManager groupResourceInfo) {
        String simplifiedResourcePrefix = File.separator;
        DWSimplifiedResourceInfo resourceInfo = DWSimplifiedResourceManager.createDefaultConfigMappingInfo(groupInfo.getName(), DWSimplifiedResourceUtils.BUSINESS_LAYER_STANDARD);
        groupDefaultResourceInfo.put(simplifiedResourcePrefix + resourceInfo.getSimplifiedResourceName(), resourceInfo);
        for (int i = 0; i <= DWSimplifiedResourceUtils.getBusinessExtensionMaxLayerIndex(); ++i) {
            resourceInfo = DWSimplifiedResourceManager.createDefaultConfigMappingInfo(groupInfo.getName(), i);
            groupDefaultResourceInfo.put(simplifiedResourcePrefix + resourceInfo.getSimplifiedResourceName(), resourceInfo);
        }
        groupResourceInfo.registerSource(groupInfo);
    }

    public synchronized void completeInitialization() {
        completed = true;
        Log log = LogFactory.getLog(DWSimplifiedResourceManager.class);
        log.warn((Object)("Before DWSimplifiedResourceManager Reday, there are some request for theses property: " + String.valueOf(incompleteRequestPropertyNameSet)));
    }

    public static boolean isInitializationCompleted(String propertyName) {
        if (!completed) {
            incompleteRequestPropertyNameSet.add(propertyName);
        }
        return completed;
    }

    public static boolean isGroupExcluded(String groupName) {
        return excludedGroupList.contains(groupName);
    }

    public static void suspendCheckStatus() {
        suspendCheckStatus.set(true);
    }

    public static void resumeCheckStatus() {
        suspendCheckStatus.remove();
    }

    private static void checkInitStatus() {
        if (Boolean.TRUE.equals(suspendCheckStatus.get())) {
            return;
        }
        if (!completed) {
            throw new DWRuntimeException("DWSimplifiedResourceManager is not ready, please contact DAP for this issue.");
        }
    }

    public static List<String> getGroupNameList() {
        DWSimplifiedResourceManager.checkInitStatus();
        return new ArrayList<String>(locationInfoMap.keySet());
    }

    public static List<URL> getGroupSourcePriorityList() {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (DWGroupLocationManager locationManager : locationInfoMap.values()) {
            List subUrlList = locationManager.layerMap.entrySet().stream().sorted(Map.Entry.comparingByKey(Comparator.reverseOrder())).flatMap(entry -> ((List)entry.getValue()).stream()).map(locationInfo -> locationInfo.getData()).collect(Collectors.toList());
            urls.addAll(subUrlList);
        }
        return urls;
    }

    public static InputStream getModularMappingResourceAsStream(DWSimplifiedResourceInfo resourceInfo) {
        DWSimplifiedResourceManager.checkInitStatus();
        DWGroupLocationManager groupResourceInfo = locationInfoMap.get(resourceInfo.getGroupName());
        if (groupResourceInfo == null) {
            return null;
        }
        return groupResourceInfo.getModularMappingResourceAsStream(resourceInfo.getLayerIndex(), resourceInfo.getModularResourceName());
    }

    public static DWSimplifiedResourceInfo createNoneMappingInfo(String simplifiedResourceName) {
        DWSimplifiedResourceInfo resourceInfo = groupDefaultResourceInfo.computeIfAbsent(simplifiedResourceName, key -> new DWSimplifiedResourceInfo((String)key));
        return resourceInfo;
    }

    public static DWSimplifiedResourceInfo createConvertingInfo(String simplifiedResourceName, String convertingName) {
        DWSimplifiedResourceInfo resourceInfo = groupDefaultResourceInfo.computeIfAbsent(simplifiedResourceName, key -> new DWSimplifiedResourceInfo(convertingName));
        return resourceInfo;
    }

    public static DWSimplifiedResourceInfo createDefaultConfigMappingInfo(String groupName, int layerIndex) {
        DWSimplifiedResourceInfo mappingInfo = new DWSimplifiedResourceInfo(groupName, layerIndex);
        String groupResourceName = DWSimplifiedConfigPropertiesUtils.getServiceGroupConfigFileName(groupName, layerIndex, true);
        mappingInfo.setMapping(groupResourceName, "conf" + File.separator + RESOURCE_NAME_MODULAR_MODULE_PROPERTIES);
        return mappingInfo;
    }

    public static List<DWSimplifiedResourceInfo> createI18nMappingInfo(int layerIndex, String baseName, Locale locale) {
        String[] i18nNames = DWSimplifiedI18nPropertiesUtils.getI18nFileNames(layerIndex, baseName, true, locale);
        return Arrays.stream(i18nNames).map(i18nName -> new DWSimplifiedResourceInfo((String)i18nName)).collect(Collectors.toList());
    }

    public static List<DWSimplifiedResourceInfo> createGroupI18nMappingInfo(String groupName, int layerIndex, String baseName, Locale locale) {
        Set<String> localeStringSet = DWSimplifiedI18nPropertiesUtils.getCandidateLocaleStringList(baseName, locale);
        String[] localeStringArray = new String[localeStringSet.size()];
        localeStringSet.toArray(localeStringArray);
        String[] groupI18nFileNames = DWSimplifiedI18nPropertiesUtils.getGroupI18nFileNames(groupName, baseName, layerIndex, true, locale);
        ArrayList<DWSimplifiedResourceInfo> result = new ArrayList<DWSimplifiedResourceInfo>();
        for (int i = 0; i < groupI18nFileNames.length; ++i) {
            DWSimplifiedResourceInfo mappingInfo = new DWSimplifiedResourceInfo(groupName, layerIndex);
            String modularI18nFileName = DWSimplifiedResourceUtils.getFileName(null, baseName, (String)(localeStringArray[i].isEmpty() ? "" : "_" + localeStringArray[i]), "properties");
            mappingInfo.setMapping(groupI18nFileNames[i], "lang" + File.separator + modularI18nFileName);
            result.add(mappingInfo);
        }
        return result;
    }

    public static List<DWSimplifiedResourceInfo> createPlatformI18nMappingInfo(String baseName, Locale locale) {
        String[] i18nNames = DWSimplifiedI18nPropertiesUtils.getPlatformI18nFileNames(baseName, true, locale);
        return Arrays.stream(i18nNames).map(i18nName -> new DWSimplifiedResourceInfo((String)i18nName)).collect(Collectors.toList());
    }

    public static List<DWSimplifiedResourceInfo> createApplicationI18nMappingInfo(int layerIndex, String baseName, Locale locale) {
        String[] i18nNames = DWSimplifiedI18nPropertiesUtils.getApplicationI18nFileNames(layerIndex, baseName, true, locale);
        return Arrays.stream(i18nNames).map(i18nName -> new DWSimplifiedResourceInfo((String)i18nName)).collect(Collectors.toList());
    }

    public static List<DWSimplifiedResourceInfo> createDefaultSpringXMLMappingInfoOverrideList(String groupName, String springXmlFileName) {
        String simplifiedGroupDefaultXMLFileName = springXmlFileName;
        if (RESOURCE_NAME_MODULAR_MODULE_DEFAULT_SPRING_XML_NAME.equals(springXmlFileName)) {
            simplifiedGroupDefaultXMLFileName = RESOURCE_NAME_SIMPLIFIED_GROUP_DEFAULT_SPRING_XML_NAME;
        }
        List<String> resourceNameOverrideList = DWSimplifiedResourceUtils.getGroupFileNameOverrideList(groupName, simplifiedGroupDefaultXMLFileName, null, "xml");
        ArrayList<DWSimplifiedResourceInfo> result = new ArrayList<DWSimplifiedResourceInfo>();
        for (int i = 0; i < resourceNameOverrideList.size(); ++i) {
            int layerIndex = resourceNameOverrideList.size() - i - 2;
            DWSimplifiedResourceInfo mappingInfo = new DWSimplifiedResourceInfo(groupName, layerIndex);
            String fileExtension = FilenameUtils.getExtension((String)springXmlFileName);
            if (fileExtension.length() == 0) {
                springXmlFileName = (String)springXmlFileName + ".xml";
            }
            mappingInfo.setMapping(resourceNameOverrideList.get(i), "conf" + File.separator + (String)springXmlFileName);
            result.add(mappingInfo);
        }
        return result;
    }

    static {
        incompleteRequestPropertyNameSet = new HashSet<String>();
    }

    private static class DWGroupLocationManager {
        private String name;
        private Map<Integer, List<DWSimplifiedGroupLocationInfo>> layerMap = new HashMap<Integer, List<DWSimplifiedGroupLocationInfo>>();

        private DWGroupLocationManager(String name) {
            this.name = name;
        }

        private void registerSource(DWSimplifiedGroupLocationInfo groupInfo) {
            if (!Objects.equals(this.name, groupInfo.getName())) {
                throw new IllegalStateException("You can not register different group location info! please contact DAP for this issue.");
            }
            List list = this.layerMap.computeIfAbsent(groupInfo.getBusinessLayer(), key -> new ArrayList());
            list.add(groupInfo);
        }

        private InputStream getModularMappingResourceAsStream(int layerIndex, String modularResourceName) {
            DWSimplifiedGroupLocationInfo groupSource;
            List<DWSimplifiedGroupLocationInfo> groupSourceList = this.layerMap.get(layerIndex);
            if (groupSourceList == null) {
                return null;
            }
            InputStream inputStream = null;
            Iterator<DWSimplifiedGroupLocationInfo> iterator = groupSourceList.iterator();
            while (iterator.hasNext() && (inputStream = this.getModularMappingResourceAsStream(groupSource = iterator.next(), modularResourceName)) == null) {
            }
            return inputStream;
        }

        private InputStream getModularMappingResourceAsStream(DWSimplifiedGroupLocationInfo groupSource, String modularResourceName) {
            try {
                if (groupSource.isClassPath()) {
                    return this.getModularMappingResourceAsStreamInClassPath(DWSimplifiedGroupLocationInfo.createClassPath(groupSource), modularResourceName);
                }
                modularResourceName = modularResourceName.replaceAll(Pattern.quote(File.separator), Matcher.quoteReplacement("/"));
                return this.getModularMappingResourceAsStreamInJarFile(DWSimplifiedGroupLocationInfo.createJarFile(groupSource), modularResourceName);
            }
            catch (IOException | URISyntaxException e) {
                log.warn((Object)"Can't not get modular mapping resource input stream", (Throwable)e);
                return null;
            }
        }

        private InputStream getModularMappingResourceAsStreamInClassPath(File classPath, String resourceName) throws FileNotFoundException {
            File resourceFile = new File(classPath, resourceName);
            if (resourceFile.isFile()) {
                return new FileInputStream(resourceFile);
            }
            return null;
        }

        private InputStream getModularMappingResourceAsStreamInJarFile(JarFile jarFile, String resourceName) throws IOException {
            ZipEntry zipEntry = jarFile.getEntry(resourceName);
            InputStream inputStream = null;
            if (zipEntry != null) {
                InputStream zipInputStream = jarFile.getInputStream(zipEntry);
                inputStream = IOUtils.toBufferedInputStream((InputStream)zipInputStream);
            }
            jarFile.close();
            return inputStream;
        }
    }
}

