/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.resource.simplified.utils;

import com.digiwin.app.common.DWPathUtils;
import com.digiwin.app.common.config.ConfigPool;
import com.digiwin.resource.simplified.utils.DWSimplifiedResourceUtils;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DWSimplifiedConfigPropertiesUtils {
    private static Log log = LogFactory.getLog(DWSimplifiedConfigPropertiesUtils.class);
    private static ConfigPool pool = ConfigPool.getInstance();
    public static final String GROUP_CONFIG_PREFIX = "config";

    public static Properties getApplicationProperties(int layer) {
        String resourceName = DWSimplifiedResourceUtils.getApplicationPropertiesName(layer, false);
        if (resourceName == null) {
            return null;
        }
        return pool.getProperties("classpath:", resourceName);
    }

    public static Properties getGroupProperties(String groupName, int layer) {
        if (layer == DWSimplifiedResourceUtils.BUSINESS_LAYER_STANDARD) {
            return pool.getProperties(DWPathUtils.getApplicationModuleConfPath((String)groupName), "module");
        }
        String resourceName = DWSimplifiedConfigPropertiesUtils.getServiceGroupConfigFileName(groupName, layer, false);
        if (resourceName == null) {
            return null;
        }
        return pool.getProperties("classpath:", resourceName);
    }

    public static Properties getPlatformProperties() {
        String propertiesName = "platform";
        return pool.getProperties(DWPathUtils.getPlatformConfPath(), propertiesName);
    }

    public static String getServiceGroupConfigFileName(String groupName, int businessLayer, boolean withExtensionName) {
        return DWSimplifiedResourceUtils.getGroupFileName(groupName, businessLayer, GROUP_CONFIG_PREFIX, withExtensionName ? "properties" : null);
    }
}

