/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.resource.simplified.utils;

import com.digiwin.resource.simplified.utils.replacer.DWDapReplacementListProvider;
import com.digiwin.resource.simplified.utils.replacer.DWMiddlewareReplacementListProvider;
import com.digiwin.resource.simplified.utils.replacer.DWReplacementContext;
import com.digiwin.resource.simplified.utils.replacer.DWReplacementListProvider;
import com.digiwin.resource.simplified.utils.replacer.DWTomcatWebappReplacementContext;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.invoke.CallSite;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class DWSimplifiedRuntimeConfigValueReplacer {
    private static String logName = "config-replacer.log";
    private static File logFile = new File(logName);
    private static FileOutputStream logOutputStream;

    public static void main(String[] args) throws Exception {
        try {
            logFile.createNewFile();
            logOutputStream = new FileOutputStream(logFile, true);
            DWSimplifiedRuntimeConfigValueReplacer.logStartProgress();
            DWSimplifiedRuntimeConfigValueReplacer.logLogInfo();
            if (args != null && args.length > 0 && Objects.equals("sedMode", args[0])) {
                DWSimplifiedRuntimeConfigValueReplacer.sedMode(args);
            } else {
                boolean runningInStandaloneTomcat = Boolean.parseBoolean(System.getProperty("runningInStandaloneTomcat"));
                if (runningInStandaloneTomcat) {
                    DWSimplifiedRuntimeConfigValueReplacer.replacerInTomcatMode(args);
                } else {
                    DWReplacementContext context = new DWReplacementContext();
                    context.setArguments(args);
                    DWSimplifiedRuntimeConfigValueReplacer.replacerMode(context);
                }
            }
            DWSimplifiedRuntimeConfigValueReplacer.logCompletedProgress();
        }
        catch (Exception e) {
            DWSimplifiedRuntimeConfigValueReplacer.logError(e);
        }
        finally {
            logOutputStream.close();
        }
    }

    private static Map<String, String> getEnvironmentVariableMap(DWReplacementContext context) throws IOException {
        Object envVarInfo;
        DWSimplifiedRuntimeConfigValueReplacer.logCaption("Environment Variables");
        Map<String, String> envVariables = System.getenv();
        if (context instanceof DWTomcatWebappReplacementContext) {
            String appId = ((DWTomcatWebappReplacementContext)context).getAppFolder().getName();
            appId = appId.replace("-", "_").toUpperCase();
            String prefix = appId + "_";
            DWSimplifiedRuntimeConfigValueReplacer.logInfo(String.format("*** variable name prefix: %s ***", prefix));
            envVariables = envVariables.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith(prefix)).collect(Collectors.toMap(e -> ((String)e.getKey()).substring(prefix.length()), Map.Entry::getValue));
            envVariables.put("dap-tomcat-webapp-name", appId);
        }
        boolean skip_spring_redis_password = false;
        if (envVariables.containsKey("spring.redis.password") && envVariables.containsKey("spring_redis_password")) {
            skip_spring_redis_password = true;
        }
        HashMap<String, String> realEnvVariables = new HashMap<String, String>();
        HashMap<String, CallSite> beforeReplaceEnvVariableNameMap = new HashMap<String, CallSite>();
        int count = 0;
        for (Map.Entry<String, String> sourceEnvVariable : envVariables.entrySet()) {
            String realEnvVariableValue;
            ++count;
            String realEnvVariableName = sourceEnvVariable.getKey();
            if (realEnvVariableName.equals("spring_redis_password") && skip_spring_redis_password) continue;
            boolean recordOldVariableName = false;
            if (realEnvVariableName.contains("_")) {
                realEnvVariableName = realEnvVariableName.replaceAll("_", ".");
                recordOldVariableName = true;
            }
            if (realEnvVariableName.contains("DH")) {
                realEnvVariableName = realEnvVariableName.replaceAll("DH", "-");
            }
            envVarInfo = String.format("%03d.[ %s ]", count, realEnvVariableName);
            if (!Objects.equals(sourceEnvVariable.getKey(), realEnvVariableName)) {
                envVarInfo = (String)envVarInfo + " <-" + sourceEnvVariable.getKey();
            }
            if ((realEnvVariableValue = sourceEnvVariable.getValue()).contains("@space@")) {
                realEnvVariableValue = realEnvVariableValue.replaceAll("@space@", " ");
            }
            envVarInfo = (String)envVarInfo + String.format(" = [ %s ]", realEnvVariableValue);
            if (!Objects.equals(sourceEnvVariable.getValue(), realEnvVariableValue)) {
                envVarInfo = (String)envVarInfo + " <- " + sourceEnvVariable.getValue();
            }
            String variableNameToken = "@" + realEnvVariableName + "@";
            realEnvVariables.put(variableNameToken, realEnvVariableValue);
            if (recordOldVariableName) {
                beforeReplaceEnvVariableNameMap.put(sourceEnvVariable.getKey(), (CallSite)((Object)variableNameToken));
            }
            DWSimplifiedRuntimeConfigValueReplacer.logInfo((String)envVarInfo);
        }
        if (beforeReplaceEnvVariableNameMap.size() > 0) {
            DWSimplifiedRuntimeConfigValueReplacer.logInfo("VVV Variable Contains '_' List VVV");
            for (Map.Entry item : beforeReplaceEnvVariableNameMap.entrySet()) {
                if (realEnvVariables.containsKey(item.getKey())) continue;
                String key = (String)item.getKey();
                String value = (String)realEnvVariables.get(item.getValue());
                envVarInfo = String.format("%03d.[ %s ]", ++count, key);
                envVarInfo = (String)envVarInfo + String.format(" = [ %s ]", value);
                realEnvVariables.put("@" + key + "@", value);
                DWSimplifiedRuntimeConfigValueReplacer.logInfo((String)envVarInfo);
            }
            DWSimplifiedRuntimeConfigValueReplacer.logInfo("^^^ Variable Contains '_' List ^^^");
        }
        DWSimplifiedRuntimeConfigValueReplacer.logLineSeparator();
        return realEnvVariables;
    }

    private static List<File> getTargetFileList(File file, String fileExtension, List<String> excludeFileNameList) throws IOException {
        DWSimplifiedRuntimeConfigValueReplacer.logCaption("File List");
        List<File> replaceTargetList = new ArrayList<File>();
        if (file.isDirectory()) {
            try (Stream<Path> pathStream = Files.walk(Paths.get(file.getAbsolutePath(), new String[0]), new FileVisitOption[0]);){
                replaceTargetList = pathStream.filter(f -> {
                    File currentFile = f.toFile();
                    return currentFile.isFile() && currentFile.getName().endsWith("." + fileExtension) && !excludeFileNameList.contains(currentFile.getName());
                }).map(f -> f.toFile()).collect(Collectors.toList());
            }
        } else if (file.getName().endsWith("." + fileExtension) && !excludeFileNameList.contains(file.getName())) {
            replaceTargetList.add(file);
        }
        if (replaceTargetList.size() > 0) {
            List candidateList = replaceTargetList.stream().map(f -> f.getName()).collect(Collectors.toList());
            DWSimplifiedRuntimeConfigValueReplacer.logInfo(String.join((CharSequence)System.lineSeparator(), candidateList));
        } else {
            DWSimplifiedRuntimeConfigValueReplacer.logWarning("There is no any config file need to replace!");
        }
        DWSimplifiedRuntimeConfigValueReplacer.logLineSeparator();
        return replaceTargetList;
    }

    private static void replaceConfigVariableValue(List<File> fileList, String fileExtension, Map<String, String> envVarMap) throws IOException {
        if (fileList.isEmpty()) {
            return;
        }
        DWSimplifiedRuntimeConfigValueReplacer.logCaption("Replacement Progress");
        boolean updateFile = false;
        boolean existVariables = false;
        ArrayList replacedLineList = new ArrayList();
        int i = 0;
        for (File targetFile : fileList) {
            DWSimplifiedRuntimeConfigValueReplacer.logInfo(++i + "." + targetFile.getName() + " - " + targetFile.getPath());
            updateFile = false;
            replacedLineList.clear();
            try {
                List<String> fileContent = Files.readAllLines(Paths.get(targetFile.getAbsolutePath(), new String[0]), StandardCharsets.UTF_8);
                for (int j = 0; j < fileContent.size(); ++j) {
                    existVariables = false;
                    String singleLine = fileContent.get(j);
                    for (Map.Entry entry : envVarMap.entrySet()) {
                        if (!singleLine.contains((CharSequence)entry.getKey())) continue;
                        updateFile = true;
                        existVariables = true;
                        String itemValue = (String)entry.getValue();
                        itemValue = Matcher.quoteReplacement(itemValue);
                        String replacedLine = singleLine.replaceAll(Pattern.quote((String)entry.getKey()), itemValue);
                        DWSimplifiedRuntimeConfigValueReplacer.logInfo("   >>>" + replacedLine + " <- " + singleLine);
                        singleLine = replacedLine;
                    }
                    if (!existVariables) continue;
                    fileContent.set(j, singleLine);
                }
                if (updateFile) {
                    DWSimplifiedRuntimeConfigValueReplacer.logInfo("...New Content Write to file...");
                    try (FileWriter writer = new FileWriter(targetFile);){
                        for (String string : fileContent) {
                            writer.write(string + System.lineSeparator());
                        }
                    }
                    DWSimplifiedRuntimeConfigValueReplacer.logInfo("...Replacement is completed!");
                    continue;
                }
                DWSimplifiedRuntimeConfigValueReplacer.logInfo("...Nothing to replace...");
            }
            catch (Exception e) {
                DWSimplifiedRuntimeConfigValueReplacer.logError(e);
            }
        }
        DWSimplifiedRuntimeConfigValueReplacer.logLineSeparator();
    }

    private static void replacerInTomcatMode(String[] args) throws IOException {
        File[] appCandidates;
        File webAppsFolder;
        DWSimplifiedRuntimeConfigValueReplacer.logInfo("*****VVV Standalone Tomcat web application config value replacer VVV*****");
        String assignedTomcatLocation = System.getProperty("tomcatLocation");
        if (assignedTomcatLocation != null && !assignedTomcatLocation.isEmpty()) {
            webAppsFolder = new File(assignedTomcatLocation, "webapps");
            if (!webAppsFolder.exists() || !webAppsFolder.isDirectory()) {
                DWSimplifiedRuntimeConfigValueReplacer.logError("webapps folder does not exist! -> tomcatLocation = " + assignedTomcatLocation);
                return;
            }
        } else {
            String userDir = System.getProperty("user.dir");
            File workingDirectory = new File(userDir);
            if (!workingDirectory.getName().equalsIgnoreCase("webapps")) {
                DWSimplifiedRuntimeConfigValueReplacer.logError("The replacer tool must be executed within Tomcat\u2019s webapps directory -> execute location = " + String.valueOf(workingDirectory));
                return;
            }
            webAppsFolder = workingDirectory;
        }
        if ((appCandidates = webAppsFolder.listFiles()) != null) {
            for (File appCandidate : appCandidates) {
                DWTomcatWebappReplacementContext replacementContext = null;
                if (appCandidate.isDirectory()) {
                    DWSimplifiedRuntimeConfigValueReplacer.logInfo(">> found directory: " + appCandidate.getName());
                    replacementContext = new DWTomcatWebappReplacementContext(appCandidate);
                } else if (appCandidate.getName().endsWith(".war")) {
                    DWSimplifiedRuntimeConfigValueReplacer.logInfo(">> found war: " + appCandidate.getName());
                    String appName = appCandidate.getName().replace(".war", "");
                    File explodedDir = new File(webAppsFolder, appName);
                    if (!explodedDir.exists()) {
                        DWSimplifiedRuntimeConfigValueReplacer.logInfo(">> >> extracting war...");
                        DWSimplifiedRuntimeConfigValueReplacer.extractWar(appCandidate, explodedDir);
                    }
                    replacementContext = new DWTomcatWebappReplacementContext(explodedDir);
                }
                if (replacementContext == null) continue;
                DWSimplifiedRuntimeConfigValueReplacer.processApp(replacementContext);
            }
        }
        DWSimplifiedRuntimeConfigValueReplacer.logInfo("*****^^^ Standalone Tomcat web application config value replacer ^^^*****");
    }

    private static void extractWar(File warFile, File targetDir) throws IOException {
        try (ZipInputStream zis = new ZipInputStream(new FileInputStream(warFile));){
            ZipEntry entry;
            while ((entry = zis.getNextEntry()) != null) {
                File outFile = new File(targetDir, entry.getName());
                if (entry.isDirectory()) {
                    outFile.mkdirs();
                } else {
                    outFile.getParentFile().mkdirs();
                    try (FileOutputStream fos = new FileOutputStream(outFile);){
                        int len;
                        byte[] buffer = new byte[4096];
                        while ((len = zis.read(buffer)) > 0) {
                            fos.write(buffer, 0, len);
                        }
                    }
                }
                zis.closeEntry();
            }
        }
    }

    private static boolean processApp(DWTomcatWebappReplacementContext context) throws IOException {
        DWSimplifiedRuntimeConfigValueReplacer.logInfo(String.format("########## VVV APP: %s VVV ##########", context.getAppFolder().getName()));
        List<List<String>> replacementList = DWSimplifiedRuntimeConfigValueReplacer.getReplacementList(context);
        if (replacementList.size() > 0) {
            String currentUserDir = System.getProperty("user.dir");
            System.setProperty("user.dir", context.getAppFolder().getAbsolutePath());
            for (List<String> args : replacementList) {
                context.setArguments(args.toArray(new String[0]));
                DWSimplifiedRuntimeConfigValueReplacer.replacerMode(context);
            }
            System.setProperty("user.dir", currentUserDir);
        }
        DWSimplifiedRuntimeConfigValueReplacer.logInfo(String.format("########## ^^^ APP: %s ^^^ ##########", context.getAppFolder().getName()));
        return true;
    }

    private static List<List<String>> getReplacementList(DWTomcatWebappReplacementContext context) throws IOException {
        ArrayList<DWReplacementListProvider> providers = new ArrayList<DWReplacementListProvider>();
        providers.add(new DWDapReplacementListProvider());
        providers.add(new DWMiddlewareReplacementListProvider(context));
        for (DWReplacementListProvider provider : providers) {
            if (!provider.match(context)) continue;
            return provider.get(context);
        }
        DWSimplifiedRuntimeConfigValueReplacer.logWarning("...can not found replacement list provider!");
        return Collections.emptyList();
    }

    private static boolean checkAndPrintTitle(String[] args) throws IOException {
        DWSimplifiedRuntimeConfigValueReplacer.logInfo("- DAP Config File Variables Value Replacer v0.1 -");
        DWSimplifiedRuntimeConfigValueReplacer.logCaption("Input arguments");
        if (args == null || args.length < 2) {
            DWSimplifiedRuntimeConfigValueReplacer.logError("Your input args is null or total number is less than two!");
            return false;
        }
        return true;
    }

    private static void replacerMode(DWReplacementContext context) throws IOException {
        String[] args = context.getArguments();
        if (!DWSimplifiedRuntimeConfigValueReplacer.checkAndPrintTitle(args)) {
            return;
        }
        String targetPath = args[0];
        File targetPathFile = new File(targetPath);
        String customBaseDir = context.customBaseDir();
        if (customBaseDir != null && !customBaseDir.isEmpty()) {
            DWSimplifiedRuntimeConfigValueReplacer.logInfo("0.custom.base.dir = " + customBaseDir);
            String removeStartDotSlashPath = targetPath;
            if (removeStartDotSlashPath.startsWith("./") || removeStartDotSlashPath.startsWith(".\\")) {
                removeStartDotSlashPath = removeStartDotSlashPath.substring(2);
                targetPathFile = new File(customBaseDir, removeStartDotSlashPath);
            }
        } else {
            DWSimplifiedRuntimeConfigValueReplacer.logInfo("0.user.dir = " + System.getProperty("user.dir"));
        }
        targetPathFile = targetPathFile.getAbsoluteFile();
        DWSimplifiedRuntimeConfigValueReplacer.logInfo("1.Target path = " + targetPath);
        DWSimplifiedRuntimeConfigValueReplacer.logInfo("   >>> absolute target path = " + targetPathFile.getAbsoluteFile().getAbsolutePath());
        DWSimplifiedRuntimeConfigValueReplacer.logInfo("   >>> is exist ? = " + targetPathFile.exists());
        if (!targetPathFile.exists()) {
            DWSimplifiedRuntimeConfigValueReplacer.logWarning("!Target path is not exists!");
            return;
        }
        if (targetPathFile.isDirectory()) {
            DWSimplifiedRuntimeConfigValueReplacer.logInfo("   >>> this is a directory!");
        } else {
            DWSimplifiedRuntimeConfigValueReplacer.logInfo("   >>> this is a file!");
        }
        String fileExtension = args[1];
        DWSimplifiedRuntimeConfigValueReplacer.logInfo("2.File extension = " + fileExtension);
        ArrayList<String> excludeFileNameList = new ArrayList<String>();
        for (int i = 0; i < 4; ++i) {
            if (args.length <= 2 + i) continue;
            excludeFileNameList.add(args[2 + i]);
        }
        DWSimplifiedRuntimeConfigValueReplacer.logInfo("3.Exclude file names = " + String.valueOf(excludeFileNameList));
        DWSimplifiedRuntimeConfigValueReplacer.logLineSeparator();
        Map<String, String> envVarMap = DWSimplifiedRuntimeConfigValueReplacer.getEnvironmentVariableMap(context);
        List<File> targetFileList = DWSimplifiedRuntimeConfigValueReplacer.getTargetFileList(targetPathFile, fileExtension, excludeFileNameList);
        DWSimplifiedRuntimeConfigValueReplacer.replaceConfigVariableValue(targetFileList, fileExtension, envVarMap);
    }

    private static void sedMode(String[] args) throws IOException {
        DWSimplifiedRuntimeConfigValueReplacer.logCaption("*** Sed Mode ***");
        DWSimplifiedRuntimeConfigValueReplacer.logCaption("Input arguments");
        if (args.length < 4) {
            DWSimplifiedRuntimeConfigValueReplacer.logError("Your input args total number is less than four!");
        } else {
            String regex = args[1];
            String replacement = args[2];
            String fileName = args[3];
            File targetFile = new File(fileName);
            DWSimplifiedRuntimeConfigValueReplacer.logInfo("1.Target file = " + targetFile.getName() + " - " + targetFile.getPath());
            DWSimplifiedRuntimeConfigValueReplacer.logInfo("   >>> is exist ? = " + targetFile.exists());
            DWSimplifiedRuntimeConfigValueReplacer.logInfo("   >>> is file ? = " + targetFile.isFile());
            DWSimplifiedRuntimeConfigValueReplacer.logInfo("2.Regex = [ " + regex + " ]");
            DWSimplifiedRuntimeConfigValueReplacer.logInfo(String.format("3.Replacement = [ %s ]", replacement));
            if (targetFile.isFile()) {
                DWSimplifiedRuntimeConfigValueReplacer.logWarning("The function is not implementation yet!");
            } else {
                DWSimplifiedRuntimeConfigValueReplacer.logError("Your target file is not exist or not a file!");
            }
        }
    }

    public static void logWarning(String log) throws IOException {
        DWSimplifiedRuntimeConfigValueReplacer.log("WARN", log);
    }

    public static void logInfo(String log) throws IOException {
        DWSimplifiedRuntimeConfigValueReplacer.log("INFO", log);
    }

    public static void logError(Throwable e) throws IOException {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        String stackTrace = sw.toString();
        DWSimplifiedRuntimeConfigValueReplacer.logError(stackTrace);
    }

    public static void logError(String log) throws IOException {
        DWSimplifiedRuntimeConfigValueReplacer.log("ERROR", log);
    }

    private static void logLogInfo() throws IOException {
        DWSimplifiedRuntimeConfigValueReplacer.logLineSeparator();
        DWSimplifiedRuntimeConfigValueReplacer.logCaption("Log Info");
        DWSimplifiedRuntimeConfigValueReplacer.logInfo("Replacer Log Location = " + logFile.getAbsolutePath());
        DWSimplifiedRuntimeConfigValueReplacer.logLineSeparator();
    }

    private static void logCaption(String caption) throws IOException {
        DWSimplifiedRuntimeConfigValueReplacer.logInfo(String.format("< %s >", caption));
        DWSimplifiedRuntimeConfigValueReplacer.logInfo("--------------------------------");
    }

    private static void logLineSeparator() throws IOException {
        DWSimplifiedRuntimeConfigValueReplacer.log("INFO", "===========================================================");
    }

    private static void logStartProgress() throws IOException {
        DWSimplifiedRuntimeConfigValueReplacer.logInfo("++++++++++++++++++++ Progress Starting ++++++++++++++++++++");
    }

    private static void logCompletedProgress() throws IOException {
        DWSimplifiedRuntimeConfigValueReplacer.logInfo("++++++++++++++++++++ Progress Completed ++++++++++++++++++++");
    }

    private static void logStartSpecificAppProgress() throws IOException {
        DWSimplifiedRuntimeConfigValueReplacer.logInfo("++++++++++++++++++++ Progress Starting ++++++++++++++++++++");
    }

    private static void logCompletedSpecificAppProgress() throws IOException {
        DWSimplifiedRuntimeConfigValueReplacer.logInfo("++++++++++++++++++++ Progress Completed ++++++++++++++++++++");
    }

    public static void log(String caption, String log) throws IOException {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        String nowString = dateFormat.format(Calendar.getInstance().getTime());
        String message = String.format("%s [%5s] %s%s", nowString, caption, log, System.lineSeparator());
        System.out.print(message);
        logOutputStream.write(message.getBytes());
        logOutputStream.flush();
    }
}

