/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.resource.simplified.utils.replacer;

import com.digiwin.resource.simplified.utils.DWSimplifiedRuntimeConfigValueReplacer;
import com.digiwin.resource.simplified.utils.replacer.DWTomcatWebappReplacementContext;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public abstract class DWReplacementListProvider {
    public abstract String getTemplateLocation();

    public boolean match(DWTomcatWebappReplacementContext context) {
        return this.getTemplateLocationFile(context) != null;
    }

    public File getTemplateLocationFile(DWTomcatWebappReplacementContext context) {
        File dapDockerEnvReplaceSh = new File(context.getAppFolder(), this.getTemplateLocation());
        if (dapDockerEnvReplaceSh.exists()) {
            return dapDockerEnvReplaceSh;
        }
        return null;
    }

    public List<List<String>> get(DWTomcatWebappReplacementContext context) throws IOException {
        return this.getCore(context, this.getTemplateLocationFile(context));
    }

    public List<List<String>> getCore(DWTomcatWebappReplacementContext context, File templateFile) throws IOException {
        ArrayList<List<String>> replacementList = new ArrayList<List<String>>();
        try {
            if (!templateFile.exists()) {
                DWSimplifiedRuntimeConfigValueReplacer.logWarning(String.format("template file not found! expected location=%s", templateFile.getAbsolutePath()));
                return replacementList;
            }
            DWSimplifiedRuntimeConfigValueReplacer.logInfo("found replace list template: " + templateFile.getAbsolutePath());
            Pattern pattern = Pattern.compile("java\\s+-jar\\s+\\$jarLocation\\s+(.+)", 2);
            try (BufferedReader br = new BufferedReader(new FileReader(templateFile));){
                String line;
                while ((line = br.readLine()) != null) {
                    Matcher matcher = pattern.matcher(line.trim());
                    if (!matcher.find()) continue;
                    String argStr = matcher.group(1);
                    List argsList = Arrays.stream(argStr.split("\\s+")).filter(s -> !s.isEmpty()).collect(Collectors.toList());
                    replacementList.add(argsList);
                }
            }
            int i = 0;
            for (List list : replacementList) {
                DWSimplifiedRuntimeConfigValueReplacer.logInfo(String.format("%02d.%s", ++i, list));
            }
        }
        catch (Exception e) {
            DWSimplifiedRuntimeConfigValueReplacer.logError(String.format("process app=%s failed!", context.getAppFolder().getName()));
            DWSimplifiedRuntimeConfigValueReplacer.logError(e);
        }
        if (replacementList.size() > 0) {
            ArrayList<String> contextXmlArguments = new ArrayList<String>();
            contextXmlArguments.add("./META-INF/context.xml");
            contextXmlArguments.add("xml");
            replacementList.add(contextXmlArguments);
        }
        return replacementList;
    }
}

