/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.gateway.controller;

import com.digiwin.app.container.DWMethod;
import com.digiwin.app.container.DWParameters;
import com.digiwin.app.container.DWRestfulHeader;
import com.digiwin.app.container.DWRestfulParameters;
import com.digiwin.app.container.restful.DWRestfulRequestInfo;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.app.service.restful.DWRestfulRequest;
import com.digiwin.gateway.controller.ServiceInvoker;
import com.digiwin.gateway.http.DWRequestWrapper;
import com.digiwin.gateway.utils.HttpServerletUtil;
import java.util.Collections;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Profile;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.async.DeferredResult;

@RestController
@Profile(value={"nio"})
public class GatewayNioController {
    @Autowired
    private ServiceInvoker serviceInvoker;

    @RequestMapping(method={RequestMethod.GET, RequestMethod.POST, RequestMethod.PATCH, RequestMethod.PUT, RequestMethod.DELETE}, path={"/restful/service/**"})
    public DeferredResult<Object> execute() throws Exception {
        HttpServletRequest httpRequest = HttpServerletUtil.getRequest();
        String moduleName = (String)httpRequest.getAttribute("moduleName");
        String serviceName = (String)httpRequest.getAttribute("serviceName");
        String methodName = (String)httpRequest.getAttribute("methodName");
        DWParameters parameters = (DWParameters)httpRequest.getAttribute("DWParameters");
        Map<String, Object> profile = DWServiceContext.getContext().getProfile();
        if (profile == null) {
            profile = Collections.emptyMap();
        }
        DeferredResult<Object> deferredResult = this.serviceInvoker.service(moduleName, serviceName, methodName, parameters, profile);
        return deferredResult;
    }

    @RequestMapping(path={"/restful/standard/**"})
    public DeferredResult<Object> restful() throws Exception {
        HttpServletRequest httpRequest = HttpServerletUtil.getRequest();
        DWRestfulHeader header = (DWRestfulHeader)httpRequest.getAttribute("DWHeader");
        DWMethod method = (DWMethod)httpRequest.getAttribute("DWMethod");
        String moduleName = (String)httpRequest.getAttribute("moduleName");
        String serviceName = (String)httpRequest.getAttribute("serviceName");
        DWRestfulRequestInfo restfulRequestInfo = (DWRestfulRequestInfo)httpRequest.getAttribute("DWRestfulRequestInfo");
        Map pathVariable = restfulRequestInfo.getPathVariable();
        Map requestParam = restfulRequestInfo.getRequestParam();
        DWRequestWrapper requestWrapper = new DWRequestWrapper((ServletRequest)httpRequest);
        byte[] body = requestWrapper.getBody();
        String path = (String)httpRequest.getAttribute("path");
        String queryString = (String)httpRequest.getAttribute("queryString");
        DWRestfulRequest restfulRequest = new DWRestfulRequest(body, path, queryString, pathVariable, requestParam);
        DWRestfulParameters restfulParameters = new DWRestfulParameters(method, httpRequest, restfulRequest);
        Map<String, Object> profile = DWServiceContext.getContext().getProfile();
        if (profile == null) {
            profile = Collections.emptyMap();
        }
        DeferredResult<Object> deferredResult = this.serviceInvoker.restful(header, moduleName, serviceName, restfulParameters, profile);
        return deferredResult;
    }
}

