/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.gateway.event;

import com.digiwin.app.common.DWApplicationConfigUtils;
import com.digiwin.app.container.exceptions.DWRuntimeException;
import com.digiwin.gateway.event.DWInitEntryPointConfig;
import com.digiwin.gateway.event.DWInitEventParameters;
import com.digiwin.gateway.event.DWInitEventResult;
import com.digiwin.gateway.event.DWInitializationEvent;
import com.digiwin.iam.HttpRequestModel;
import com.digiwin.iam.HttpRequester;
import com.digiwin.iam.HttpResponseModel;
import com.digiwin.iam.IAMHttpRequester;
import com.digiwin.iam.ServiceModel;
import com.google.gson.Gson;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.annotation.Configuration;

@Configuration
public class DWMobileInitializationEvent
implements DWInitializationEvent {
    public static int ORDER = 100;
    private static final Log log = LogFactory.getLog(DWMobileInitializationEvent.class);
    public static String KEY_MOBILE_URL = "mobileUrl";
    public static String KEY_MOBILE_API_INIT = "mobileApiInit";

    @Override
    public DWInitEventResult onInitialize(DWInitEventParameters initParams) throws Exception {
        return this.invokeMobileInitApi(initParams);
    }

    private DWInitEventResult invokeMobileInitApi(DWInitEventParameters initParams) throws Exception {
        String initUrl = this.getInitUrl();
        Map<String, Object> mobileInitApiParams = this.convertToMobileInitApiParams(initParams);
        log.info((Object)("DWMobileInitializationEvent onInitialize...mobile init url = " + initUrl));
        Map requestHeader = IAMHttpRequester.createRequestHeader((ServiceModel)new ServiceModel());
        Gson gson = new Gson();
        String requestBody = gson.toJson(mobileInitApiParams);
        log.info((Object)("...request body = " + requestBody));
        HttpRequestModel requestModel = IAMHttpRequester.getHttpRequestModel();
        requestModel.setRequestBody(requestBody);
        requestModel.setRequestHeader(requestHeader);
        requestModel.setUrl(initUrl);
        HttpResponseModel responseModel = HttpRequester.submitRequest((HttpRequestModel)requestModel);
        int httpStatusCode = responseModel.getHttpStatusCode();
        Map invocationResult = (Map)gson.fromJson(responseModel.getResponseBody(), Map.class);
        boolean success = httpStatusCode == 200;
        String message = success ? "done!" : "failed! mobile init api status code = " + httpStatusCode;
        log.info((Object)("...invocation completed, status code = " + httpStatusCode));
        DWInitEventResult initResult = new DWInitEventResult(this, success, message, invocationResult);
        return initResult;
    }

    private Map<String, Object> convertToMobileInitApiParams(DWInitEventParameters initParams) throws Exception {
        HashMap<String, Object> conversionParams = new HashMap<String, Object>();
        conversionParams.put("userID", initParams.getUserId());
        conversionParams.put("userName", initParams.getUserName());
        conversionParams.put("tenantSid", initParams.getTenantSid());
        conversionParams.put("tenantId", initParams.getTenantId());
        conversionParams.put("tenantName", initParams.getTenantName());
        conversionParams.put("goodsCode", initParams.getGoodsCode());
        conversionParams.put("moduleIds", initParams.getEnabledModules());
        return conversionParams;
    }

    private String getInitUrl() {
        String url = DWApplicationConfigUtils.getProperty((String)KEY_MOBILE_URL, (String)"");
        String api = DWApplicationConfigUtils.getProperty((String)KEY_MOBILE_API_INIT, (String)"");
        String initUrl = url + api;
        return initUrl;
    }

    static {
        try {
            String api = DWApplicationConfigUtils.getProperty((String)KEY_MOBILE_API_INIT, (String)"");
            log.info((Object)("-DWMobileInitializationEvent-check required property's key->" + KEY_MOBILE_API_INIT + "=" + api));
            if (!api.isEmpty()) {
                log.info((Object)"-DWMobileInitializationEvent-register initialization event.");
                DWInitEntryPointConfig.register(new DWMobileInitializationEvent(), ORDER);
            }
        }
        catch (Exception e) {
            throw new DWRuntimeException("register initialization event failed. check logs for details!", (Throwable)e);
        }
    }
}

