/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.gateway;

import com.digiwin.app.common.DWApplicationConfigUtils;
import com.digiwin.app.common.config.ConfigPolicy;
import com.digiwin.app.common.config.ConfigPool;
import com.digiwin.app.common.config.DWConfigFileChangeListener;
import com.digiwin.app.log.ConfigurationUpdater;
import com.digiwin.app.log.DWLoggerContext;
import com.digiwin.app.log.DWLoggerContextFactory;
import com.digiwin.app.log.Log4j2FileChangeListener;
import com.digiwin.app.log.Log4j2XmlHolder;
import com.digiwin.app.log.LogFactoryImplement;
import com.digiwin.app.schedule.quartz.DWQuartz;
import com.digiwin.gateway.DWApiGatewayEnvironment;
import com.digiwin.gateway.spring.DWServerSpringResourceReader;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.annotation.PreDestroy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.spi.LoggerContextFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.data.mongo.MongoDataAutoConfiguration;
import org.springframework.boot.autoconfigure.mongo.MongoAutoConfiguration;
import org.springframework.boot.context.ApplicationPidFileWriter;
import org.springframework.boot.context.logging.LoggingApplicationListener;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.ImportResource;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.util.StringUtils;

@SpringBootApplication(exclude={MongoAutoConfiguration.class, MongoDataAutoConfiguration.class})
@ImportResource(value={"dwweb:platform.properties"}, reader=DWServerSpringResourceReader.class)
@EnableCaching
public class DWApiGatewayApplication {
    private static String appName = "";
    private static ConfigPool pool = null;
    private static Log log;
    private static List<String> profile;

    public static void main(String[] args) throws Exception {
        DWApiGatewayApplication.defineLogFactoryimplement();
        DWApiGatewayApplication.initConfigPool();
        DWApiGatewayApplication.initLog4j();
        log.info((Object)("LogFactory implement: " + LogFactoryImplement.getLogFactoryimplementName()));
        log.info((Object)("Log implement: " + log.getClass().getSimpleName()));
        log.info((Object)pool);
        DWApiGatewayApplication.initQueue();
        DWApiGatewayApplication.initCache();
        DWApiGatewayApplication.initTracing();
        DWApiGatewayApplication.initFilter();
        DWApiGatewayApplication.initAppSetting();
        DWApiGatewayApplication.initServerSetting();
        DWApiGatewayApplication.initProfile();
        SpringApplication springApplication = new SpringApplication(new Class[]{DWApiGatewayApplication.class});
        springApplication.setEnvironment((ConfigurableEnvironment)new DWApiGatewayEnvironment());
        springApplication.addListeners(new ApplicationListener[]{new ApplicationPidFileWriter("DWApiGatewayApplication.pid")});
        ArrayList<ApplicationListener> listeners = new ArrayList<ApplicationListener>();
        for (ApplicationListener listener : springApplication.getListeners()) {
            if (listener instanceof LoggingApplicationListener) continue;
            listeners.add(listener);
        }
        springApplication.setListeners(listeners);
        springApplication.setMainApplicationClass(DWApiGatewayApplication.class);
        springApplication.run(args);
    }

    private static void defineLogFactoryimplement() throws Exception {
        try {
            Class.forName("org.apache.commons.logging.LogFactory$Log4jLog");
            LogFactoryImplement.setLogFactoryimplement((LogFactoryImplement.Implement)LogFactoryImplement.Implement.SPRING_JCL);
        }
        catch (Throwable t) {
            LogFactoryImplement.setLogFactoryimplement((LogFactoryImplement.Implement)LogFactoryImplement.Implement.APACHE_COMMONS_LOGGING);
        }
    }

    private static void initConfigPool() throws Exception {
        ConfigPool.getInstance((ConfigPolicy)ConfigPolicy.LOCAL_FIRST, (boolean)false);
        appName = DWApplicationConfigUtils.getProperty((String)"appId", (String)"");
        String configCenterUrl = DWApplicationConfigUtils.getProperty((String)"configCenterUrl", (String)"");
        String configPolicy = DWApplicationConfigUtils.getProperty((String)"configPolicy", (String)"local_first");
        String isRemoteConfigOn = DWApplicationConfigUtils.getProperty((String)"isRemoteConfigOn", (String)"false");
        System.setProperty("app.id", appName);
        System.setProperty("apollo.meta", configCenterUrl);
        pool = ConfigPool.getInstance((ConfigPolicy)ConfigPolicy.fromString((String)configPolicy), (boolean)Boolean.valueOf(isRemoteConfigOn));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initLog4j() throws Exception {
        Class<LogFactory> clazz = LogFactory.class;
        synchronized (LogFactory.class) {
            String xml = pool.getLog4j2Xml();
            Log4j2XmlHolder.setXml((String)xml);
            DWLoggerContext dwContext = new DWLoggerContext("DWLoggerContext");
            DWLoggerContextFactory factory = new DWLoggerContextFactory(dwContext);
            LogManager.setFactory((LoggerContextFactory)factory);
            if (LogFactoryImplement.getLogFactoryimplement().equals((Object)LogFactoryImplement.Implement.SPRING_JCL)) {
                Class<?> log4jLogClass = Class.forName("org.apache.commons.logging.LogFactory$Log4jLog");
                Field loggerContextField = log4jLogClass.getDeclaredField("loggerContext");
                loggerContextField.setAccessible(true);
                Field modifiersField = Field.class.getDeclaredField("modifiers");
                modifiersField.setAccessible(true);
                modifiersField.setInt(loggerContextField, loggerContextField.getModifiers() & 0xFFFFFFEF);
                loggerContextField.set(null, dwContext);
            }
            ConfigurationUpdater.execute((String)xml);
            log = LogFactory.getLog(DWApiGatewayApplication.class);
            boolean isHookRemote = pool.addLog4j2XmlChangeListener((DWConfigFileChangeListener)new Log4j2FileChangeListener());
            log.info((Object)("is hook remote log4j2.xml: " + isHookRemote));
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private static void initQueue() throws Exception {
        String queueRoleProfile = DWApplicationConfigUtils.getProperty((String)"queueRole", (String)"");
        String isHeartbeat = DWApplicationConfigUtils.getProperty((String)"queueHeartbeat", (String)"false");
        if (!StringUtils.isEmpty((Object)queueRoleProfile)) {
            profile.add(queueRoleProfile);
        }
        if (Boolean.valueOf(isHeartbeat).booleanValue()) {
            profile.add("Heartbeat");
        }
    }

    private static void initCache() throws Exception {
        if (DWApplicationConfigUtils.isClosedCache()) {
            System.setProperty("spring.cache.type", "NONE");
        } else {
            profile.add("openCache");
        }
    }

    private static void initTracing() throws Exception {
        if (!DWApplicationConfigUtils.isClosedTracing()) {
            profile.add("DWTracing");
        }
    }

    private static void initFilter() throws Exception {
        String filterProfile = DWApplicationConfigUtils.getProperty((String)"httpRequestFilters", (String)"");
        if (!StringUtils.isEmpty((Object)filterProfile)) {
            profile.add(filterProfile);
        }
    }

    private static void initServerSetting() throws Exception {
        String ioProfile = DWApplicationConfigUtils.getProperty((String)"serverHttpControllerIo", (String)"nio");
        String server = DWApplicationConfigUtils.getProperty((String)"serverType", (String)"tomcat");
        DWApiGatewayApplication.setTenantEnv();
        profile.add(ioProfile);
        profile.add(server);
    }

    private static void initAppSetting() throws Exception {
        Properties allAppProperties = DWApplicationConfigUtils.getProperties();
        Properties filteredSpringBootProperties = DWApiGatewayApplication.filterSpringBootProperties(allAppProperties);
        for (Map.Entry<Object, Object> entry : filteredSpringBootProperties.entrySet()) {
            String key = entry.getKey().toString();
            String value = entry.getValue().toString();
            System.setProperty(key, value);
        }
        String appName = DWApplicationConfigUtils.getProperty((String)"appId", (String)"");
        System.setProperty("appName", appName);
        System.setProperty("spring.application.name", appName);
        log.info((Object)("appId=" + appName));
        String appToken = DWApplicationConfigUtils.getProperty((String)"iamApToken", (String)"");
        System.setProperty("appToken", appToken);
        log.info((Object)("appToken=" + appToken));
    }

    private static Properties filterSpringBootProperties(Properties properties) {
        Properties result = new Properties();
        boolean isClosedCache = DWApplicationConfigUtils.isClosedCache();
        String cacheKeyPrefix = "spring.redis";
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String key = entry.getKey().toString();
            String value = entry.getValue().toString();
            if (isClosedCache && key.startsWith(cacheKeyPrefix) || !DWApiGatewayApplication.isSpringBootProperties(key)) continue;
            result.put(key, value);
        }
        return result;
    }

    private static boolean isSpringBootProperties(String key) {
        String[] springBootPropertiesPrefixs;
        boolean result = false;
        for (String prefix : springBootPropertiesPrefixs = new String[]{"spring.", "logging.", "server.", "management."}) {
            if (!key.startsWith(prefix)) continue;
            result = true;
            break;
        }
        return result;
    }

    private static void initProfile() throws Exception {
        System.setProperty("spring.profiles.active", String.join((CharSequence)",", profile));
    }

    @PreDestroy
    public void onDestroy() throws Exception {
        DWQuartz.shutdown();
    }

    private static void setTenantEnv() {
        String dwapiTokenMode = DWApplicationConfigUtils.getProperty((String)"serverHttpTokenmode", (String)"DWApiGateway");
        System.setProperty("serverHttpTokenmode", dwapiTokenMode);
        log.info((Object)("dw-server:serverHttpTokenmode:" + dwapiTokenMode));
        String dwapiTenantEnable = DWApplicationConfigUtils.getProperty((String)"tenantEnabled", (String)"true");
        System.setProperty("tenantEnabled", dwapiTenantEnable);
        log.info((Object)("dw-server:tenantEnabled=" + dwapiTenantEnable));
        String dwapiTenantColumnName = DWApplicationConfigUtils.getProperty((String)"tenantColumnname", (String)"tenantsid");
        System.setProperty("tenantColumnname", dwapiTenantColumnName);
        log.info((Object)("dw-server:tenantColumnname=" + dwapiTenantColumnName));
    }

    static {
        profile = new ArrayList<String>();
    }
}

