/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.gateway.result;

import com.digiwin.app.common.DWApplicationConfigUtils;
import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.app.service.DWLoginResult;
import com.digiwin.app.service.DWTokenBean;
import com.digiwin.gateway.result.DWResultHandler;
import com.digiwin.gateway.result.DWServiceStandardResult;
import com.digiwin.gateway.token.JwtTokenBean;
import com.digiwin.gateway.token.TokenService;
import com.google.gson.Gson;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;

public class DWLoginResultHandler
extends DWResultHandler {
    private Gson _gson = new Gson();
    @Autowired
    private TokenService tokenService;

    @Override
    public Object process(Object result) throws Exception {
        DWTokenBean tokenBean = null;
        if (result instanceof DWTokenBean) {
            tokenBean = (DWTokenBean)result;
        } else if (result instanceof DWLoginResult) {
            DWLoginResult loginResult = (DWLoginResult)result;
            tokenBean = new DWTokenBean(loginResult.getProfile(), loginResult.getResult());
        } else {
            return super.process(result);
        }
        return this.convertToJSONString(tokenBean);
    }

    private String convertToJSONString(DWTokenBean<?> tokenBean) throws Exception {
        Map profile = tokenBean.getProfile();
        Object result = tokenBean.getResult();
        JwtTokenBean jwtTokenBean = new JwtTokenBean(profile, result);
        JSONObject subject = new JSONObject();
        subject.put("profile", (Object)new JSONObject(profile));
        jwtTokenBean.setSubject(subject.toString());
        Long tokenExpiredMillis = null;
        try {
            tokenExpiredMillis = Long.parseLong(DWApplicationConfigUtils.getProperty((String)"serverTokenExpiredTime", (String)"600000"));
            Date issuedAt = jwtTokenBean.getIssuedAt();
            long issuedAtMillis = issuedAt.getTime();
            long expiredMillis = issuedAtMillis + tokenExpiredMillis;
            Date expiration = new Date(expiredMillis);
            jwtTokenBean.setExpiration(expiration);
        }
        catch (NumberFormatException e) {
            throw new DWException("serverTokenExpiredTime format exception, value is " + DWApplicationConfigUtils.getProperty((String)"serverTokenExpiredTime", (String)"600000"));
        }
        String token = this.tokenService.generateToken(jwtTokenBean);
        HashMap<String, Object> loginContent = new HashMap<String, Object>();
        loginContent.put("data", result);
        loginContent.put("token", token);
        Object standardResult = DWServiceStandardResult.create(loginContent);
        String jsonString = this._gson.toJson(standardResult);
        return jsonString;
    }
}

