/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.gateway.controller;

import com.digiwin.app.common.DWApplicationConfigUtils;
import com.digiwin.app.container.DWContainerContext;
import com.digiwin.app.container.DWDefaultParameters;
import com.digiwin.app.container.DWHeader;
import com.digiwin.app.container.DWMethod;
import com.digiwin.app.container.DWParameters;
import com.digiwin.app.json.gson.DWGsonProvider;
import com.digiwin.app.service.DWEAIResult;
import com.digiwin.app.service.DWServiceContext;
import java.net.InetAddress;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Calendar;
import java.util.Collections;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Profile;
import org.springframework.core.env.Environment;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@RestController
@Profile(value={"bio"})
public class EaiController {
    @Autowired
    private DWContainerContext containerContext;
    @Autowired
    Environment environment;

    @RequestMapping(method={RequestMethod.POST}, path={"/eai/callback"})
    public Object callback() throws Exception {
        HttpServletRequest request = this.getRequest();
        HttpServletResponse response = this.getResponse();
        DWHeader header = (DWHeader)request.getAttribute("DWHeader");
        DWMethod method = (DWMethod)request.getAttribute("DWMethod");
        String moduleName = (String)request.getAttribute("moduleName");
        String serviceName = (String)request.getAttribute("serviceName");
        Map profile = DWServiceContext.getContext().getProfile();
        if (profile == null) {
            profile = Collections.emptyMap();
        }
        DWDefaultParameters invokeParameters = this.getDWParameters(request);
        String digiSrvver = DWApplicationConfigUtils.getProperty((String)"eaiHostVer");
        Object result = null;
        Object invokeResult = null;
        try {
            invokeResult = this.containerContext.invokeEai(header, method, moduleName, serviceName, (DWParameters)invokeParameters, profile);
            if (invokeResult instanceof DWEAIResult) {
                result = DWGsonProvider.getGson().toJson(invokeResult, invokeResult.getClass());
            } else if (invokeResult instanceof Map) {
                Map mapResult = (Map)invokeResult;
                if (mapResult.containsKey("std_data")) {
                    result = DWGsonProvider.getGson().toJson(invokeResult);
                } else {
                    DWEAIResult dwEaiResult = new DWEAIResult("0", "", "", (Map)invokeResult);
                    result = DWGsonProvider.getGson().toJson((Object)dwEaiResult, dwEaiResult.getClass());
                }
            } else {
                result = invokeResult;
            }
            response.addHeader("digi-srvver", digiSrvver);
            response.addHeader("digi-srvcode", "000");
        }
        catch (Throwable e) {
            response.addHeader("digi-srvver", digiSrvver);
            response.addHeader("digi-srvcode", "100");
            DWEAIResult dwEaiResult = new DWEAIResult("-1", "", this.getRootCauseMessage(e), new HashMap());
            result = DWGsonProvider.getGson().toJson((Object)dwEaiResult, dwEaiResult.getClass());
        }
        return result;
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/eai"})
    public Object eai() throws Exception {
        HttpServletRequest request = this.getRequest();
        HttpServletResponse response = this.getResponse();
        DWHeader header = (DWHeader)request.getAttribute("DWHeader");
        DWMethod method = (DWMethod)request.getAttribute("DWMethod");
        String moduleName = (String)request.getAttribute("moduleName");
        String serviceName = (String)request.getAttribute("serviceName");
        Map profile = DWServiceContext.getContext().getProfile();
        if (profile == null) {
            profile = Collections.emptyMap();
        }
        DWDefaultParameters invokeParameters = this.getDWParameters(request);
        String digiSrvver = DWApplicationConfigUtils.getProperty((String)"eaiHostVer");
        Object result = null;
        Object invokeResult = null;
        try {
            invokeResult = this.containerContext.invokeEai(header, method, moduleName, serviceName, (DWParameters)invokeParameters, profile);
            if (invokeResult instanceof DWEAIResult) {
                result = DWGsonProvider.getGson().toJson(invokeResult, invokeResult.getClass());
            } else if (invokeResult instanceof Map) {
                Map mapResult = (Map)invokeResult;
                if (mapResult.containsKey("std_data")) {
                    result = DWGsonProvider.getGson().toJson(invokeResult);
                } else {
                    DWEAIResult dwEaiResult = new DWEAIResult("0", "", "", (Map)invokeResult);
                    result = DWGsonProvider.getGson().toJson((Object)dwEaiResult, dwEaiResult.getClass());
                }
            } else {
                result = invokeResult;
            }
            response.addHeader("digi-srvver", digiSrvver);
            response.addHeader("digi-srvcode", "000");
        }
        catch (Throwable e) {
            response.addHeader("digi-srvver", digiSrvver);
            response.addHeader("digi-srvcode", "100");
            DWEAIResult dwEaiResult = new DWEAIResult("-1", "", this.getRootCauseMessage(e), new HashMap());
            result = DWGsonProvider.getGson().toJson((Object)dwEaiResult, dwEaiResult.getClass());
        }
        return result;
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/eai/syncProd"})
    public Object syncProd() throws Exception {
        HttpServletRequest request = this.getRequest();
        String digiService = request.getHeader("digi-service");
        JSONObject digiServiceJo = new JSONObject(digiService);
        String name = digiServiceJo.getString("name");
        Map<Object, Object> result = new HashMap();
        HttpServletResponse response = this.getResponse();
        response.addHeader("Content-Type", "application/json; charset=UTF-8");
        switch (name) {
            case "getProdRegInfo": {
                response.addHeader("action", "reg");
                result = this.getProdRegInfo();
                break;
            }
            case "getSrvRegInfo": {
                response.addHeader("action", "reg");
                result = this.getSrvRegInfo();
                break;
            }
            case "doSyncProcess": {
                response.addHeader("digi-srvcode", "000");
                break;
            }
        }
        return result;
    }

    public Map<String, Object> getProdRegInfo() throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String ip = this.getIP();
        String port = this.environment.getProperty("local.server.port");
        String offset = this.getTimezoneOffset();
        String appId = DWApplicationConfigUtils.getProperty((String)"appId");
        String prod = DWApplicationConfigUtils.getProperty((String)"eaiHostProd", (String)appId);
        String ver = DWApplicationConfigUtils.getProperty((String)"eaiHostVer");
        String id = DWApplicationConfigUtils.getProperty((String)"eaiHostId", (String)appId);
        String uid = DWApplicationConfigUtils.getProperty((String)"eaiHostUid", (String)appId);
        String retrytimes = DWApplicationConfigUtils.getProperty((String)"eaiHostRetrytimes", (String)"");
        String retryinterval = DWApplicationConfigUtils.getProperty((String)"eaiHostRetryinterval", (String)"");
        String concurrence = DWApplicationConfigUtils.getProperty((String)"eaiHostConcurrence", (String)"");
        HashMap<String, String> host = new HashMap<String, String>();
        host.put("prod", prod);
        host.put("ver", ver);
        host.put("ip", ip);
        host.put("id", id);
        host.put("uid", uid);
        host.put("timezone", offset);
        host.put("restful", "http://" + ip + ":" + port + "/eai");
        if (!StringUtils.isBlank((CharSequence)retrytimes)) {
            host.put("retrytimes", retrytimes);
        }
        if (!StringUtils.isBlank((CharSequence)retryinterval)) {
            host.put("retryinterval", retryinterval);
        }
        if (!StringUtils.isBlank((CharSequence)concurrence)) {
            host.put("concurrence", concurrence);
        }
        result.put("host", host);
        return result;
    }

    public Map<String, Object> getSrvRegInfo() throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String ip = this.getIP();
        String appId = DWApplicationConfigUtils.getProperty((String)"appId");
        String prod = DWApplicationConfigUtils.getProperty((String)"eaiHostProd", (String)appId);
        String ver = DWApplicationConfigUtils.getProperty((String)"eaiHostVer");
        String id = DWApplicationConfigUtils.getProperty((String)"eaiHostId", (String)appId);
        String uid = DWApplicationConfigUtils.getProperty((String)"eaiHostUid", (String)appId);
        HashMap<String, String> host = new HashMap<String, String>();
        host.put("prod", prod);
        host.put("ver", ver);
        host.put("ip", ip);
        host.put("id", id);
        host.put("uid", uid);
        HashMap<String, List> service = new HashMap<String, List>();
        List srvname = this.containerContext.getEaiServiceList();
        service.put("srvname", srvname);
        result.put("service", service);
        result.put("host", host);
        return result;
    }

    private HttpServletRequest getRequest() {
        RequestAttributes requestAttributes = RequestContextHolder.currentRequestAttributes();
        HttpServletRequest request = ((ServletRequestAttributes)requestAttributes).getRequest();
        return request;
    }

    private DWDefaultParameters getDWParameters(HttpServletRequest request) throws Exception {
        JSONObject headerJo = new JSONObject();
        Enumeration headerNames = request.getHeaderNames();
        for (String headerName : Collections.list(headerNames)) {
            if (!headerName.startsWith("digi-")) continue;
            if ("digi-message".equalsIgnoreCase(headerName)) {
                headerJo.put(headerName, (Object)new String(Base64.getDecoder().decode(request.getHeader(headerName)), StandardCharsets.UTF_8));
                continue;
            }
            headerJo.put(headerName, (Object)request.getHeader(headerName));
        }
        String body = request.getReader().lines().collect(Collectors.joining(System.lineSeparator()));
        JSONObject invokeParameterJo = new JSONObject();
        invokeParameterJo.put("headers", (Object)headerJo);
        invokeParameterJo.put("messageBody", (Object)body);
        DWDefaultParameters invokeParameters = new DWDefaultParameters(invokeParameterJo.toMap());
        return invokeParameters;
    }

    private HttpServletResponse getResponse() {
        RequestAttributes requestAttributes = RequestContextHolder.currentRequestAttributes();
        HttpServletResponse response = ((ServletRequestAttributes)requestAttributes).getResponse();
        return response;
    }

    private String getTimezoneOffset() {
        TimeZone timeZone = TimeZone.getDefault();
        Calendar calendar = GregorianCalendar.getInstance(timeZone);
        int offsetInMillis = timeZone.getOffset(calendar.getTimeInMillis());
        String offset = String.format("%d", Math.abs(offsetInMillis / 3600000));
        offset = (offsetInMillis >= 0 ? "+" : "-") + offset;
        return offset;
    }

    private String getIP() throws Exception {
        String defaultIp = InetAddress.getLocalHost().getHostAddress();
        String ip = DWApplicationConfigUtils.getProperty((String)"eaiHostIp", (String)defaultIp);
        return ip;
    }

    private Throwable getRootCause(Throwable exception) {
        return ExceptionUtils.getRootCause((Throwable)exception);
    }

    private String getRootCauseMessage(Throwable exception) {
        Throwable targetCause = null;
        Throwable rootCause = this.getRootCause(exception);
        targetCause = rootCause != null ? rootCause : exception;
        String message = null;
        message = targetCause.getMessage();
        if (message == null || message.isEmpty()) {
            message = targetCause.toString();
        }
        return message;
    }
}

