/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.gateway.controller;

import com.digiwin.app.common.DWApplicationConfigUtils;
import com.digiwin.app.container.DWContainerContext;
import com.digiwin.app.container.DWParameters;
import com.digiwin.app.container.DWTargetAPI;
import com.digiwin.app.eai.CallbackTask;
import com.digiwin.app.eai.DWEAICallback;
import com.digiwin.app.eai.DigiSrvcode;
import com.digiwin.app.eai.FasyncTask;
import com.digiwin.app.json.gson.DWGsonProvider;
import com.digiwin.app.service.DWEAIFasyncResult;
import com.digiwin.app.service.DWEAIFasyncTaskResult;
import com.digiwin.app.service.DWEAIResult;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.app.service.eai.DWEAIHeaderRepository;
import com.digiwin.gateway.controller.EaiInfoUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Profile;
import org.springframework.core.env.Environment;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Profile(value={"bio"})
public class EaiController {
    @Autowired
    private DWContainerContext containerContext;
    @Autowired
    private DWEAIHeaderRepository eaiHeaderRepository;
    @Autowired
    Environment environment;

    @RequestMapping(method={RequestMethod.POST}, path={"/eai/callback"})
    public Object callback() throws Exception {
        Object result;
        HttpServletRequest request = EaiInfoUtils.getRequest();
        HttpServletResponse response = EaiInfoUtils.getResponse();
        Map profile = DWServiceContext.getContext().getProfile();
        if (profile == null) {
            profile = Collections.emptyMap();
        }
        String digiSrvver = DWApplicationConfigUtils.getProperty((String)"eaiHostVer");
        DigiSrvcode digiSrvcode = DigiSrvcode.success;
        try {
            DWTargetAPI api = (DWTargetAPI)request.getAttribute("targetAPI");
            DWParameters apiParameters = (DWParameters)request.getAttribute("targetParameters");
            Object invokeResult = this.containerContext.invoke(api, apiParameters, profile);
            if (invokeResult instanceof DWEAIResult) {
                digiSrvcode = ((DWEAIResult)invokeResult).getDigiSrvcodeOrDefault(DigiSrvcode.success);
                result = DWGsonProvider.getGson().toJson(invokeResult, DWEAIResult.class);
            } else if (invokeResult instanceof Map) {
                DWEAIResult dwEaiResult = new DWEAIResult("0", "", "", (Map)invokeResult);
                result = DWGsonProvider.getGson().toJson((Object)dwEaiResult, DWEAIResult.class);
            } else {
                result = invokeResult;
            }
            response.addHeader("digi-srvver", digiSrvver);
            response.addHeader("digi-srvcode", digiSrvcode.value());
        }
        catch (Throwable e) {
            response.addHeader("digi-srvver", digiSrvver);
            response.addHeader("digi-srvcode", DigiSrvcode.failure.value());
            DWEAIResult dwEaiResult = new DWEAIResult("-1", "", this.getRootCauseMessage(e), new HashMap());
            result = DWGsonProvider.getGson().toJson((Object)dwEaiResult, dwEaiResult.getClass());
        }
        return result;
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/eai"})
    public Object eai() {
        Object result;
        HttpServletRequest request = EaiInfoUtils.getRequest();
        HttpServletResponse response = EaiInfoUtils.getResponse();
        Map profile = DWServiceContext.getContext().getProfile();
        if (profile == null) {
            profile = Collections.emptyMap();
        }
        String digiSrvver = DWApplicationConfigUtils.getProperty((String)"eaiHostVer");
        DigiSrvcode digiSrvcode = DigiSrvcode.success;
        try {
            DWTargetAPI api = (DWTargetAPI)request.getAttribute("targetAPI");
            DWParameters apiParameters = (DWParameters)request.getAttribute("targetParameters");
            Object invokeResult = this.containerContext.invoke(api, apiParameters, profile);
            if (invokeResult.getClass().equals(DWEAIResult.class)) {
                digiSrvcode = ((DWEAIResult)invokeResult).getDigiSrvcodeOrDefault(DigiSrvcode.success);
                result = DWGsonProvider.getGson().toJson(invokeResult, DWEAIResult.class);
            } else if (invokeResult.getClass().equals(DWEAIFasyncResult.class)) {
                digiSrvcode = ((DWEAIFasyncResult)invokeResult).getDigiSrvcodeOrDefault(DigiSrvcode.success);
                DWEAIFasyncResult fasyncResult = (DWEAIFasyncResult)invokeResult;
                FasyncTask fasyncTask = fasyncResult.getFasyncTask();
                CallbackTask callbackTask = fasyncResult.getCallbackTask();
                String digiReqid = DWServiceContext.getContext().getRequestHeader().getOrDefault("digi-reqid", "");
                DWServiceContext finalContext = DWServiceContext.getContext();
                Executors.newSingleThreadExecutor().submit(() -> {
                    block3: {
                        try {
                            DWServiceContext.setContext((DWServiceContext)finalContext);
                            DWEAIFasyncTaskResult eaiFasyncTaskResult = fasyncTask.execute();
                            DWEAICallback eaiCallback = new DWEAICallback(digiReqid, eaiFasyncTaskResult);
                            eaiCallback.setDigiDatakey(eaiFasyncTaskResult.getDigiDatakey());
                            eaiCallback.setCustomHeader(eaiFasyncTaskResult.getCustomHeader());
                            eaiCallback.setCustomCallbackHeader(eaiFasyncTaskResult.getCustomCallbackHeader());
                            Map callbackResult = eaiCallback.execute();
                            if (callbackTask != null) {
                                Map headers = (Map)callbackResult.get("headers");
                                String messageBody = (String)callbackResult.get("messageBody");
                                callbackTask.execute(headers, messageBody);
                            }
                        }
                        catch (Throwable e) {
                            String code = "-1";
                            String sqlCode = "";
                            String description = this.getRootCauseMessage(e);
                            DWEAICallback eaiCallback = new DWEAICallback(DigiSrvcode.failure.value(), digiReqid, code, sqlCode, description, new HashMap());
                            Map callbackResult = eaiCallback.execute();
                            if (callbackTask == null) break block3;
                            Map headers = (Map)callbackResult.get("headers");
                            String messageBody = (String)callbackResult.get("messageBody");
                            callbackTask.execute(headers, messageBody);
                        }
                    }
                });
                String code = fasyncResult.getCode();
                String sqlCode = fasyncResult.getSqlCode();
                String description = fasyncResult.getDescription();
                Map parameter = fasyncResult.getParameter();
                DWEAIResult dwEaiResult = new DWEAIResult(code, sqlCode, description, parameter);
                result = DWGsonProvider.getGson().toJson((Object)dwEaiResult, DWEAIResult.class);
            } else if (invokeResult instanceof Map) {
                DWEAIResult dwEaiResult = new DWEAIResult("0", "", "", (Map)invokeResult);
                result = DWGsonProvider.getGson().toJson((Object)dwEaiResult, dwEaiResult.getClass());
            } else {
                result = invokeResult;
            }
            response.addHeader("digi-srvver", digiSrvver);
            response.addHeader("digi-srvcode", digiSrvcode.value());
        }
        catch (Throwable e) {
            response.addHeader("digi-srvver", digiSrvver);
            response.addHeader("digi-srvcode", DigiSrvcode.failure.value());
            DWEAIResult dwEaiResult = new DWEAIResult("-1", "", this.getRootCauseMessage(e), new HashMap());
            result = DWGsonProvider.getGson().toJson((Object)dwEaiResult, dwEaiResult.getClass());
        }
        return result;
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/eai/syncProd"})
    public Object syncProd() throws Exception {
        HttpServletRequest request = EaiInfoUtils.getRequest();
        String digiService = request.getHeader("digi-service");
        JSONObject digiServiceJo = new JSONObject(digiService);
        String name = digiServiceJo.getString("name");
        Map<Object, Object> result = new HashMap();
        HttpServletResponse response = EaiInfoUtils.getResponse();
        response.addHeader("Content-Type", "application/json; charset=UTF-8");
        switch (name) {
            case "getProdRegInfo": {
                response.addHeader("action", "reg");
                result = EaiInfoUtils.getProdRegInfo(this.environment);
                break;
            }
            case "getSrvRegInfo": {
                response.addHeader("action", "reg");
                result = EaiInfoUtils.getSrvRegInfo(() -> ((DWEAIHeaderRepository)this.eaiHeaderRepository).getEaiServiceIdList());
                break;
            }
            case "doSyncProcess": {
                response.addHeader("digi-srvcode", "000");
                break;
            }
        }
        return result;
    }

    private Throwable getRootCause(Throwable exception) {
        return ExceptionUtils.getRootCause((Throwable)exception);
    }

    private String getRootCauseMessage(Throwable exception) {
        Throwable rootCause = this.getRootCause(exception);
        Throwable targetCause = rootCause != null ? rootCause : exception;
        String message = targetCause.getMessage();
        if (message == null || message.isEmpty()) {
            message = targetCause.toString();
        }
        return message;
    }
}

