/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.gateway.controller;

import com.digiwin.app.common.DWApplicationConfigUtils;
import com.digiwin.app.container.DWContainerContext;
import com.digiwin.app.container.DWParameters;
import com.digiwin.app.container.DWRestfulParameters;
import com.digiwin.app.container.DWTargetAPI;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.gateway.controller.EaiInfoUtils;
import com.digiwin.gateway.result.DWResultHandlerList;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.async.DeferredResult;

@Service
public class ServiceInvoker {
    private static final String TIMEOUT_MESSAGE = "timeout";
    private static final long DEFAULT_TIMEOUT = 120000L;
    @Autowired
    private DWContainerContext containerContext;

    public DeferredResult<Object> eai(DWTargetAPI api, String digiSrvver, DWParameters parameters, Map<String, Object> profile) throws Exception {
        DeferredResult<Object> deferredResult = this.getDeferredResult();
        HttpServletResponse response = EaiInfoUtils.getResponse();
        DWServiceContext context = DWServiceContext.getContext();
        new Thread(() -> {
            try {
                DWServiceContext.setContext((DWServiceContext)context);
                Object result = this.containerContext.invoke(api, parameters, profile == null ? Collections.emptyMap() : profile);
                response.addHeader("digi-srvver", digiSrvver);
                response.addHeader("digi-srvcode", "000");
                deferredResult.setResult(result);
            }
            catch (Throwable e) {
                response.addHeader("digi-srvver", digiSrvver);
                response.addHeader("digi-srvcode", "100");
                deferredResult.setErrorResult((Object)e);
                e.printStackTrace();
            }
        }, this.getThreadName()).start();
        return deferredResult;
    }

    public DeferredResult<Object> restful(DWTargetAPI api, DWRestfulParameters restfulParameters, Map<String, Object> profile) throws Exception {
        DeferredResult<Object> deferredResult = this.getDeferredResult();
        DWServiceContext context = DWServiceContext.getContext();
        new Thread(() -> {
            try {
                DWServiceContext.setContext((DWServiceContext)context);
                Object result = this.containerContext.invoke(api, (DWParameters)restfulParameters, profile == null ? Collections.emptyMap() : profile);
                DWResultHandlerList handler = DWResultHandlerList.getInstance();
                result = handler.process(result);
                Map headerMap = DWServiceContext.getContext().getResponseHeader();
                HttpHeaders responseHeaders = new HttpHeaders();
                for (String key : headerMap.keySet()) {
                    responseHeaders.add(key, String.valueOf(headerMap.getOrDefault(key, "")));
                }
                deferredResult.setResult((Object)((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(responseHeaders)).body(result));
            }
            catch (Throwable e) {
                deferredResult.setErrorResult((Object)e);
                e.printStackTrace();
            }
        }, this.getThreadName()).start();
        return deferredResult;
    }

    public DeferredResult<Object> service(DWTargetAPI api, DWParameters parameters, Map<String, Object> profile) throws Exception {
        DeferredResult<Object> deferredResult = this.getDeferredResult();
        DWServiceContext context = DWServiceContext.getContext();
        new Thread(() -> {
            try {
                DWServiceContext.setContext((DWServiceContext)context);
                Object result = this.containerContext.invoke(api, parameters, profile == null ? Collections.emptyMap() : profile);
                DWResultHandlerList handler = DWResultHandlerList.getInstance();
                result = handler.process(result);
                Map headerMap = DWServiceContext.getContext().getResponseHeader();
                HttpHeaders responseHeaders = new HttpHeaders();
                for (String key : headerMap.keySet()) {
                    responseHeaders.add(key, String.valueOf(headerMap.getOrDefault(key, "")));
                }
                deferredResult.setResult((Object)((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(responseHeaders)).body(result));
            }
            catch (Throwable e) {
                deferredResult.setErrorResult((Object)e);
                e.printStackTrace();
            }
        }, this.getThreadName()).start();
        return deferredResult;
    }

    private DeferredResult<Object> getDeferredResult() throws Exception {
        long timeout = this.getTimeout();
        Object timeoutResult = this.getTimeoutResult();
        DeferredResult deferredResult = new DeferredResult(Long.valueOf(timeout), timeoutResult);
        return deferredResult;
    }

    private Object getTimeoutResult() throws Exception {
        Object timeoutResult = DWResultHandlerList.getInstance().process(TIMEOUT_MESSAGE);
        return timeoutResult;
    }

    private long getTimeout() {
        String timeout = DWApplicationConfigUtils.getProperty((String)"serverAsyncTimeout", (String)String.valueOf(120000L));
        return Long.valueOf(timeout);
    }

    private String getThreadName() {
        return "DWWorker-" + UUID.randomUUID().toString();
    }
}

