/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.gateway.event;

import com.digiwin.app.container.exceptions.DWArgumentException;
import com.digiwin.gateway.event.DWScheduleEvent;
import com.digiwin.gateway.filter.StandardHeaderFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.context.annotation.Configuration;

@Configuration
public class DWScheduleEventConfig {
    public static final String PATH_SCHEDULE_STOP = "/api/app/tenant/expired/notices";
    public static final String PATH_SCHEDULE_START = "/api/app/tenant/renew/notices";
    private static Map<DWScheduleEvent, Integer> eventMap;

    public static void register(DWScheduleEvent event) throws Exception {
        DWScheduleEventConfig.register(event, Integer.MAX_VALUE);
    }

    public static void register(DWScheduleEvent event, int order) throws Exception {
        if (event == null) {
            throw new DWArgumentException("event", "event is null!");
        }
        eventMap.put(event, order);
    }

    public static List<DWScheduleEvent> getEventList() {
        LinkedHashMap sortedMap = eventMap.entrySet().stream().sorted(Map.Entry.comparingByValue()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e2, LinkedHashMap::new));
        ArrayList<DWScheduleEvent> sortedList = new ArrayList<DWScheduleEvent>(sortedMap.keySet());
        return sortedList;
    }

    public static Integer getOrder(DWScheduleEvent event) {
        return eventMap.get(event);
    }

    static {
        StandardHeaderFilter.addExtraUrlPatterns((String[])new String[]{PATH_SCHEDULE_STOP});
        StandardHeaderFilter.addExtraUrlPatterns((String[])new String[]{PATH_SCHEDULE_START});
        eventMap = new HashMap<DWScheduleEvent, Integer>();
    }
}

