/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.gateway.controller;

import com.digiwin.app.container.DWParameters;
import com.digiwin.app.container.DWRestfulParameters;
import com.digiwin.app.container.DWTargetAPI;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.gateway.controller.ServiceInvoker;
import com.digiwin.gateway.utils.HttpServerletUtil;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Profile;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.async.DeferredResult;

@RestController
@Profile(value={"nio"})
public class GatewayNioController {
    @Autowired
    private ServiceInvoker serviceInvoker;

    @RequestMapping(method={RequestMethod.GET, RequestMethod.POST, RequestMethod.PATCH, RequestMethod.PUT, RequestMethod.DELETE}, path={"/restful/service/**"})
    public DeferredResult<Object> execute() throws Exception {
        HttpServletRequest httpRequest = HttpServerletUtil.getRequest();
        Map profile = DWServiceContext.getContext().getProfile();
        DWTargetAPI api = (DWTargetAPI)httpRequest.getAttribute("targetAPI");
        DWParameters parameters = (DWParameters)httpRequest.getAttribute("targetParameters");
        DeferredResult<Object> deferredResult = this.serviceInvoker.service(api, parameters, profile);
        return deferredResult;
    }

    @RequestMapping(path={"/restful/standard/**"})
    public DeferredResult<Object> restful() throws Exception {
        HttpServletRequest httpRequest = HttpServerletUtil.getRequest();
        Map profile = DWServiceContext.getContext().getProfile();
        DWTargetAPI api = (DWTargetAPI)httpRequest.getAttribute("targetAPI");
        DWRestfulParameters restfulParameters = (DWRestfulParameters)httpRequest.getAttribute("targetParameters");
        DeferredResult<Object> deferredResult = this.serviceInvoker.restful(api, restfulParameters, profile);
        return deferredResult;
    }
}

