/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.gateway;

import com.digiwin.app.common.DWApplicationConfigUtils;
import com.digiwin.app.common.config.ConfigPolicy;
import com.digiwin.app.common.config.ConfigPool;
import com.digiwin.app.log.LogFactoryImplement;
import com.digiwin.app.schedule.quartz.DWQuartz;
import com.digiwin.gateway.DWApiGatewayEnvironment;
import com.digiwin.gateway.spring.DWServerSpringResourceReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.PreDestroy;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.data.mongo.MongoDataAutoConfiguration;
import org.springframework.boot.autoconfigure.mongo.MongoAutoConfiguration;
import org.springframework.boot.context.ApplicationPidFileWriter;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.ImportResource;
import org.springframework.core.env.ConfigurableEnvironment;

@SpringBootApplication(exclude={MongoAutoConfiguration.class, MongoDataAutoConfiguration.class})
@ImportResource(value={"dwweb:platform.properties"}, reader=DWServerSpringResourceReader.class)
@EnableCaching
public class DWApiGatewayApplication {
    private static ConfigPool pool = null;
    private static Log log;
    private static List<String> profile;

    public static void main(String[] args) throws Exception {
        DWApiGatewayApplication.defineLogFactoryimplement();
        DWApiGatewayApplication.initConfigPool();
        log = LogFactory.getLog(DWApiGatewayApplication.class);
        log.info((Object)pool);
        log.info((Object)("config center url: " + System.getProperty("configCenterUrl", "")));
        log.info((Object)("config center app ID: " + System.getProperty("app.id", "")));
        log.info((Object)("platform version: " + System.getProperty("platform.version", "")));
        log.info((Object)("application version: " + System.getProperty("application.version", "")));
        log.info((Object)("config center group app ID: " + System.getProperty("group.app.id", "")));
        SpringApplication springApplication = new SpringApplication(new Class[]{DWApiGatewayApplication.class});
        springApplication.setEnvironment((ConfigurableEnvironment)new DWApiGatewayEnvironment());
        springApplication.addListeners(new ApplicationListener[]{new ApplicationPidFileWriter("DWApiGatewayApplication.pid")});
        springApplication.setMainApplicationClass(DWApiGatewayApplication.class);
        ConfigurableApplicationContext context = springApplication.run(args);
    }

    private static void defineLogFactoryimplement() throws Exception {
        try {
            Class.forName("org.apache.commons.logging.LogFactory$Log4jLog");
            LogFactoryImplement.setLogFactoryimplement((LogFactoryImplement.Implement)LogFactoryImplement.Implement.SPRING_JCL);
        }
        catch (Throwable t) {
            LogFactoryImplement.setLogFactoryimplement((LogFactoryImplement.Implement)LogFactoryImplement.Implement.APACHE_COMMONS_LOGGING);
        }
    }

    private static void initConfigPool() throws Exception {
        String appIdFromProperties;
        pool = ConfigPool.getInstance();
        String configCenterUrl = DWApplicationConfigUtils.getProperty((String)"configCenterUrl", (String)"");
        String configPolicy = DWApplicationConfigUtils.getProperty((String)"configPolicy", (String)"local_first");
        String isRemoteConfigOn = DWApplicationConfigUtils.getProperty((String)"isRemoteConfigOn", (String)"false");
        String isGroupConfigOn = DWApplicationConfigUtils.getProperty((String)"isGroupConfigOn", (String)"false");
        String configGroup = DWApplicationConfigUtils.getProperty((String)"configGroup", (String)"");
        if (StringUtils.isBlank((CharSequence)configCenterUrl)) {
            isRemoteConfigOn = "false";
            return;
        }
        Map<String, String> env = System.getenv();
        String appIdFromEnv = env.getOrDefault("APPIMAGENAME", appIdFromProperties = DWApplicationConfigUtils.getProperty((String)"APPIMAGENAME", (String)""));
        String appId = DWApplicationConfigUtils.getProperty((String)"CUSTOM_APPIMAGENAME", (String)appIdFromEnv);
        if (StringUtils.isBlank((CharSequence)appId)) {
            return;
        }
        String platformVersionFromProperties = DWApplicationConfigUtils.getProperty((String)"PLATFORM", (String)"");
        String platformVersionFromEnv = env.getOrDefault("PLATFORM", platformVersionFromProperties);
        String platformVersion = DWApplicationConfigUtils.getProperty((String)"CUSTOM_PLATFORM", (String)platformVersionFromEnv);
        if (StringUtils.isBlank((CharSequence)platformVersion)) {
            return;
        }
        String applicationVersionFromProperties = DWApplicationConfigUtils.getProperty((String)"SMALLVERSION", (String)"");
        String applicationVersionFromEnv = env.getOrDefault("SMALLVERSION", applicationVersionFromProperties);
        String applicationVersion = DWApplicationConfigUtils.getProperty((String)"CUSTOM_SMALLVERSION", (String)applicationVersionFromEnv);
        if (StringUtils.isBlank((CharSequence)applicationVersion)) {
            return;
        }
        if (configCenterUrl.contains("test") || configCenterUrl.contains("dev")) {
            System.setProperty("env", "dev");
            System.setProperty("dev_meta", configCenterUrl);
        } else {
            System.setProperty("env", "pro");
            System.setProperty("pro_meta", configCenterUrl);
        }
        System.setProperty("configCenterUrl", configCenterUrl);
        System.setProperty("app.id", appId);
        System.setProperty("platform.version", platformVersion);
        System.setProperty("application.version", applicationVersion);
        System.setProperty("group.app.id", configGroup);
        System.setProperty("group.version", "default");
        System.setProperty("apollo.loadConfigQPS", "20000");
        if (StringUtils.isBlank((CharSequence)configGroup)) {
            isGroupConfigOn = "false";
        }
        pool.init(ConfigPolicy.fromString((String)configPolicy), Boolean.valueOf(isRemoteConfigOn).booleanValue(), Boolean.valueOf(isGroupConfigOn).booleanValue());
    }

    @PreDestroy
    public void onDestroy() throws Exception {
        DWQuartz.shutdown();
    }

    static {
        profile = new ArrayList<String>();
    }
}

