/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.gateway.server;

import com.digiwin.app.common.DWApplicationConfigUtils;
import org.apache.catalina.connector.Connector;
import org.springframework.boot.web.embedded.tomcat.TomcatConnectorCustomizer;
import org.springframework.boot.web.embedded.tomcat.TomcatServletWebServerFactory;

public class DWTomcat
extends TomcatServletWebServerFactory {
    private static final String DEFAULT_PORT = "8085";
    private static final String ACCEPT_COUNT = "100";
    private static final String MAX_CONNECTIONS = "10000";
    private static final String MIN_SPARE_THREADS = "10";
    private static final String MAX_THREADS = "200";

    public DWTomcat() {
        this.initialize();
    }

    private void initialize() {
        super.addConnectorCustomizers(new TomcatConnectorCustomizer[]{new DWTomcatConnectorCustomizer()});
    }

    private class DWTomcatConnectorCustomizer
    implements TomcatConnectorCustomizer {
        private DWTomcatConnectorCustomizer() {
        }

        public void customize(Connector connector) {
            String port = DWApplicationConfigUtils.getProperty((String)"serverPort", (String)DWTomcat.DEFAULT_PORT);
            String acceptCount = DWApplicationConfigUtils.getProperty((String)"serverTomcatAcceptCount", (String)DWTomcat.ACCEPT_COUNT);
            String maxConnections = DWApplicationConfigUtils.getProperty((String)"serverTomcatMaxConnections", (String)DWTomcat.MAX_CONNECTIONS);
            String minSpareThreads = DWApplicationConfigUtils.getProperty((String)"serverTomcatMinSpareThreads", (String)DWTomcat.MIN_SPARE_THREADS);
            String maxThreads = DWApplicationConfigUtils.getProperty((String)"serverTomcatMaxThreads", (String)DWTomcat.MAX_THREADS);
            connector.setPort(Integer.valueOf(port).intValue());
            connector.setAttribute("acceptCount", (Object)acceptCount);
            connector.setAttribute("maxConnections", (Object)maxConnections);
            connector.setAttribute("minSpareThreads", (Object)minSpareThreads);
            connector.setAttribute("maxThreads", (Object)maxThreads);
        }
    }
}

