/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.gateway.controller;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.container.exceptions.DWRuntimeException;
import com.digiwin.app.dao.DWServiceResultBuilder;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.gateway.event.DWInitEntryPointConfig;
import com.digiwin.gateway.event.DWInitEventParameters;
import com.digiwin.gateway.event.DWInitEventResult;
import com.digiwin.gateway.event.DWInitializationEvent;
import com.digiwin.gateway.http.DWRequestWrapper;
import com.digiwin.gateway.result.DWResultHandlerList;
import com.digiwin.gateway.utils.HttpServerletUtil;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class DWInitializationController {
    private static Log log = LogFactory.getLog(DWInitializationController.class);

    @RequestMapping(method={RequestMethod.POST}, path={"/api/app/initialize"})
    public Object initialize() throws Exception {
        boolean success;
        HttpServletRequest httpRequest = HttpServerletUtil.getRequest();
        DWRequestWrapper requestWrapper = new DWRequestWrapper((ServletRequest)httpRequest);
        String body = new String(requestWrapper.getBody(), StandardCharsets.UTF_8);
        DWInitEventParameters parameters = new DWInitEventParameters(body);
        try {
            parameters.getTenantSid();
        }
        catch (Exception e) {
            throw new DWRuntimeException(String.format("please check tenantSid(actual value=%s) parameter", parameters.getTenantSidString(), e));
        }
        DWResultHandlerList handler = DWResultHandlerList.getInstance();
        List<DWInitializationEvent> eventList = DWInitEntryPointConfig.getInitEventList();
        ArrayList<DWInitEventResult> resultList = new ArrayList<DWInitEventResult>();
        for (DWInitializationEvent event : eventList) {
            DWInitEventResult result;
            try {
                result = event.onInitialize(parameters);
                resultList.add(result);
            }
            catch (Exception e) {
                log.error((Object)(event.getClass().getName() + ".onInitialize exception occured!"), (Throwable)e);
                result = new DWInitEventResult(event, e);
                resultList.add(result);
            }
        }
        boolean bl = success = !resultList.stream().anyMatch(item -> !item.isSuccess());
        if (!success) {
            DWBusinessException exception = new DWBusinessException("initialize has error occured, please check logs for details.");
            exception.getInstructors().put("result", resultList);
            throw exception;
        }
        Object finalResult = DWServiceResultBuilder.build((boolean)success, (String)"done!", resultList);
        finalResult = handler.process(finalResult);
        Map headerMap = DWServiceContext.getContext().getResponseHeader();
        HttpHeaders responseHeaders = new HttpHeaders();
        for (String key : headerMap.keySet()) {
            responseHeaders.add(key, String.valueOf(headerMap.getOrDefault(key, "")));
        }
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(responseHeaders)).body(finalResult);
    }
}

