/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.gateway.event;

import com.digiwin.gateway.event.DWInitEventParameters;
import com.digiwin.gateway.event.DWInitEventResult;
import com.digiwin.gateway.event.DWInitializationEvent;
import com.digiwin.iam.HttpRequestModel;
import com.digiwin.iam.HttpRequester;
import com.digiwin.iam.HttpResponseModel;
import com.digiwin.iam.IAMHttpRequester;
import com.digiwin.iam.ServiceModel;
import com.google.gson.Gson;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DWMobileInitializationEvent
implements DWInitializationEvent {
    public static int ORDER = 100;
    private static final Log log = LogFactory.getLog(DWMobileInitializationEvent.class);
    private String mobileUrl = null;
    private String mobileApiInitPath = null;

    public void setMobileUrl(String mobileUrl) {
        this.mobileUrl = mobileUrl;
    }

    public void setMobileApiInitPath(String mobileApiInitPath) {
        this.mobileApiInitPath = mobileApiInitPath;
    }

    @Override
    public DWInitEventResult onInitialize(DWInitEventParameters initParams) throws Exception {
        return this.invokeMobileInitApi(initParams);
    }

    private DWInitEventResult invokeMobileInitApi(DWInitEventParameters initParams) throws Exception {
        String message;
        String initUrl = this.mobileUrl + this.mobileApiInitPath;
        Map<String, Object> mobileInitApiParams = this.convertToMobileInitApiParams(initParams);
        log.info((Object)("DWMobileInitializationEvent onInitialize...mobile init url = " + initUrl));
        Map requestHeader = IAMHttpRequester.createRequestHeader((ServiceModel)new ServiceModel());
        Gson gson = new Gson();
        String requestBody = gson.toJson(mobileInitApiParams);
        log.info((Object)("...request body = " + requestBody));
        HttpRequestModel requestModel = IAMHttpRequester.getHttpRequestModel();
        requestModel.setRequestBody(requestBody);
        requestModel.setRequestHeader(requestHeader);
        requestModel.setUrl(initUrl);
        HttpResponseModel responseModel = HttpRequester.submitRequest((HttpRequestModel)requestModel);
        int httpStatusCode = responseModel.getHttpStatusCode();
        boolean success = httpStatusCode == 200;
        String string = message = success ? "done!" : "failed! mobile init api status code = " + httpStatusCode;
        if (!success) {
            log.error((Object)(message + String.format(" ... mobile init url = %s ... request body = %s ... response body = %s", initUrl, requestBody, responseModel.getResponseBody())));
        }
        Map invocationResult = (Map)gson.fromJson(responseModel.getResponseBody(), Map.class);
        log.info((Object)("...invocation completed, status code = " + httpStatusCode));
        DWInitEventResult initResult = new DWInitEventResult(this, success, message, invocationResult);
        return initResult;
    }

    private Map<String, Object> convertToMobileInitApiParams(DWInitEventParameters initParams) throws Exception {
        HashMap<String, Object> conversionParams = new HashMap<String, Object>();
        conversionParams.put("userID", initParams.getUserId());
        conversionParams.put("userName", initParams.getUserName());
        conversionParams.put("tenantSid", initParams.getTenantSid());
        conversionParams.put("tenantId", initParams.getTenantId());
        conversionParams.put("tenantName", initParams.getTenantName());
        conversionParams.put("goodsCode", initParams.getGoodsCode());
        conversionParams.put("moduleIds", initParams.getEnabledModules());
        return conversionParams;
    }
}

