/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.gateway.controller;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.dao.DWServiceResultBuilder;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.gateway.event.DWDataSourceEvent;
import com.digiwin.gateway.event.DWDataSourceEventConfig;
import com.digiwin.gateway.event.DWDataSourceEventParameters;
import com.digiwin.gateway.event.DWDataSourceEventResult;
import com.digiwin.gateway.http.DWRequestWrapper;
import com.digiwin.gateway.result.DWResultHandlerList;
import com.digiwin.gateway.utils.HttpServerletUtil;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class DWTenantDataSourceController {
    private static Log log = LogFactory.getLog(DWTenantDataSourceController.class);
    private static final String _KEY_APPID = "appId";
    private String appId;

    @Value(value="${appId}")
    public void setAppId(String appId) {
        this.appId = appId;
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/api/app/tenant/datasource/update"})
    public Object updateDataSource() throws Exception {
        HttpServletRequest httpRequest = HttpServerletUtil.getRequest();
        DWRequestWrapper requestWrapper = new DWRequestWrapper((ServletRequest)httpRequest);
        String body = new String(requestWrapper.getBody(), StandardCharsets.UTF_8);
        if (StringUtils.isBlank((CharSequence)body)) {
            throw new DWBusinessException("body is null");
        }
        DWDataSourceEventParameters orgParameters = new DWDataSourceEventParameters(body);
        Map originalParams = (Map)orgParameters.getPararmeters().get("params");
        if (originalParams.containsKey(_KEY_APPID)) {
            String appIdInBody = (String)originalParams.get(_KEY_APPID);
            if (!this.appId.equals(appIdInBody)) {
                throw new DWBusinessException("request body appId(" + appIdInBody + ") not equal to " + this.appId);
            }
        } else {
            throw new DWBusinessException("request body no appId");
        }
        DWResultHandlerList handler = DWResultHandlerList.getInstance();
        ArrayList<DWDataSourceEventResult> resultList = new ArrayList<DWDataSourceEventResult>();
        List<DWDataSourceEvent> eventList = DWDataSourceEventConfig.getEventList();
        for (DWDataSourceEvent event : eventList) {
            DWDataSourceEventResult result;
            try {
                result = (DWDataSourceEventResult)event.doInvoke(orgParameters);
                resultList.add(result);
            }
            catch (Exception e) {
                log.error((Object)(event.getClass().getName() + ".doInvoke exception occured!"), (Throwable)e);
                result = new DWDataSourceEventResult(event, e);
                resultList.add(result);
            }
        }
        boolean success = !resultList.stream().anyMatch(item -> !item.isSuccess());
        Object finalResult = DWServiceResultBuilder.build((boolean)success, (String)"done!", resultList);
        finalResult = handler.process(finalResult);
        Map headerMap = DWServiceContext.getContext().getResponseHeader();
        HttpHeaders responseHeaders = new HttpHeaders();
        for (String key : headerMap.keySet()) {
            responseHeaders.add(key, String.valueOf(headerMap.getOrDefault(key, "")));
        }
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(responseHeaders)).body(finalResult);
    }
}

