/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.gateway.event;

import com.digiwin.gateway.event.DWDataSourceEvent;
import com.digiwin.gateway.event.DWDataSourceEventImpl;
import com.digiwin.gateway.filter.StandardHeaderFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.annotation.Configuration;

@Configuration
public class DWDataSourceEventConfig {
    private static final Log _log = LogFactory.getLog(DWDataSourceEventImpl.class);
    private static final String _CLASSTAG = "[DWDataSourceEventConfig] ";
    public static final String PATH_TENANT_DATASOURCE_UPDATE = "/api/app/tenant/datasource/update";
    private static Map<DWDataSourceEvent, Integer> eventMap;

    public static void register(DWDataSourceEvent event) {
        DWDataSourceEventConfig.register(event, Integer.MAX_VALUE);
    }

    public static void register(DWDataSourceEvent event, int order) {
        if (event == null) {
            _log.error((Object)"[DWDataSourceEventConfig] event is null!");
        } else {
            eventMap.put(event, order);
        }
    }

    public static List<DWDataSourceEvent> getEventList() {
        LinkedHashMap sortedMap = eventMap.entrySet().stream().sorted(Map.Entry.comparingByValue()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e2, LinkedHashMap::new));
        ArrayList<DWDataSourceEvent> sortedList = new ArrayList<DWDataSourceEvent>(sortedMap.keySet());
        return sortedList;
    }

    public static Integer getOrder(DWDataSourceEvent event) {
        return eventMap.get(event);
    }

    static {
        StandardHeaderFilter.addExtraUrlPatterns((String[])new String[]{PATH_TENANT_DATASOURCE_UPDATE});
        eventMap = new HashMap<DWDataSourceEvent, Integer>();
    }
}

