/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.gateway.spring;

import com.digiwin.app.resource.DWResourceBundleUtils;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Service;
import org.springframework.web.servlet.LocaleResolver;

@Service(value="localeResolver")
public class DWLocaleResolver
implements LocaleResolver {
    public Locale resolveLocale(HttpServletRequest request) {
        String localeString = request.getHeader("locale");
        if (localeString == null) {
            localeString = request.getHeader("digi-locale");
        }
        if (localeString == null) {
            Locale digiAcceptLanguageLocale = this.getDigiAcceptLangueLocale(request);
            if (digiAcceptLanguageLocale != null) {
                return digiAcceptLanguageLocale;
            }
            return request.getLocale();
        }
        return DWResourceBundleUtils.getLocale((String)localeString);
    }

    public void setLocale(HttpServletRequest request, HttpServletResponse response, Locale locale) {
        throw new UnsupportedOperationException("Cannot change locale - use a different locale resolution strategy");
    }

    private Locale getDigiAcceptLangueLocale(HttpServletRequest request) {
        List<Locale.LanguageRange> languageRanges;
        Locale result = null;
        String digiAcceptLanguage = request.getHeader("digi-accept-language");
        if (digiAcceptLanguage != null && (languageRanges = Locale.LanguageRange.parse(digiAcceptLanguage)).size() > 0) {
            String firstRange = languageRanges.get(0).getRange();
            return Locale.forLanguageTag(firstRange);
        }
        return result;
    }
}

