/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.gateway.controller;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.dao.DWServiceResultBuilder;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.gateway.event.DWScheduleEvent;
import com.digiwin.gateway.event.DWScheduleEventConfig;
import com.digiwin.gateway.event.DWScheduleEventParameters;
import com.digiwin.gateway.event.DWScheduleEventResult;
import com.digiwin.gateway.http.DWRequestWrapper;
import com.digiwin.gateway.result.DWResultHandlerList;
import com.digiwin.gateway.utils.HttpServerletUtil;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class DWTenantScheduleController {
    private static Log log = LogFactory.getLog(DWTenantScheduleController.class);
    private String appId = "";

    @Value(value="${appId:}")
    public void setAppId(String appId) {
        this.appId = appId;
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/api/app/tenant/expired/notices"})
    public Object stopSchedule() throws Exception {
        HttpServletRequest httpRequest = HttpServerletUtil.getRequest();
        DWRequestWrapper requestWrapper = new DWRequestWrapper((ServletRequest)httpRequest);
        String body = new String(requestWrapper.getBody(), StandardCharsets.UTF_8);
        DWScheduleEventParameters orgParameters = new DWScheduleEventParameters(body);
        Map originalParams = new HashMap();
        if (orgParameters != null) {
            originalParams = (Map)orgParameters.getPararmeters().get("params");
            if (originalParams.containsKey("appId")) {
                String appIdInBody = (String)originalParams.get("appId");
                if (!this.appId.equals(appIdInBody)) {
                    throw new DWBusinessException("request body appId(" + appIdInBody + ") not equal to " + this.appId);
                }
            } else {
                throw new DWBusinessException("request body no appId");
            }
        }
        DWResultHandlerList handler = DWResultHandlerList.getInstance();
        this.beforeProcess(this.appId);
        ArrayList<DWScheduleEventResult> resultList = new ArrayList<DWScheduleEventResult>();
        List<DWScheduleEvent> eventList = DWScheduleEventConfig.getEventList();
        for (DWScheduleEvent event : eventList) {
            DWScheduleEventResult result;
            try {
                result = event.doInvoke(orgParameters);
                resultList.add(result);
            }
            catch (Exception e) {
                log.error((Object)(event.getClass().getName() + ".stop exception occured!"), (Throwable)e);
                result = new DWScheduleEventResult(event, e);
                resultList.add(result);
            }
        }
        boolean success = !resultList.stream().anyMatch(item -> !item.isSuccess());
        Object finalResult = DWServiceResultBuilder.build((boolean)success, (String)"done!", resultList);
        finalResult = handler.process(finalResult);
        Map headerMap = DWServiceContext.getContext().getResponseHeader();
        HttpHeaders responseHeaders = new HttpHeaders();
        for (String key : headerMap.keySet()) {
            responseHeaders.add(key, String.valueOf(headerMap.getOrDefault(key, "")));
        }
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(responseHeaders)).body(finalResult);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/api/app/tenant/renew/notices"})
    public Object startSchedule() throws Exception {
        HttpServletRequest httpRequest = HttpServerletUtil.getRequest();
        DWRequestWrapper requestWrapper = new DWRequestWrapper((ServletRequest)httpRequest);
        String body = new String(requestWrapper.getBody(), StandardCharsets.UTF_8);
        DWScheduleEventParameters orgParameters = new DWScheduleEventParameters(body);
        Map originalParams = new HashMap();
        if (orgParameters != null) {
            originalParams = (Map)orgParameters.getPararmeters().get("params");
            if (originalParams.containsKey("appId")) {
                String appIdInBody = (String)originalParams.get("appId");
                if (!this.appId.equals(appIdInBody)) {
                    throw new DWBusinessException("request body appId(" + appIdInBody + ") not equal to " + this.appId);
                }
            } else {
                throw new DWBusinessException("request body no appId");
            }
        }
        DWResultHandlerList handler = DWResultHandlerList.getInstance();
        this.beforeProcess(this.appId);
        ArrayList<DWScheduleEventResult> resultList = new ArrayList<DWScheduleEventResult>();
        List<DWScheduleEvent> eventList = DWScheduleEventConfig.getEventList();
        for (DWScheduleEvent event : eventList) {
            DWScheduleEventResult result;
            try {
                result = event.doInvokeForActive(orgParameters);
                resultList.add(result);
            }
            catch (Exception e) {
                log.error((Object)(event.getClass().getName() + ".stop exception occured!"), (Throwable)e);
                result = new DWScheduleEventResult(event, e);
                resultList.add(result);
            }
        }
        boolean success = !resultList.stream().anyMatch(item -> !item.isSuccess());
        Object finalResult = DWServiceResultBuilder.build((boolean)success, (String)"done!", resultList);
        finalResult = handler.process(finalResult);
        Map headerMap = DWServiceContext.getContext().getResponseHeader();
        HttpHeaders responseHeaders = new HttpHeaders();
        for (String key : headerMap.keySet()) {
            responseHeaders.add(key, String.valueOf(headerMap.getOrDefault(key, "")));
        }
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(responseHeaders)).body(finalResult);
    }

    private void beforeProcess(String appId) throws Exception {
        if (StringUtils.isBlank((CharSequence)appId)) {
            appId = "dummy";
        }
        HashMap<String, String> profile = new HashMap<String, String>();
        profile.put("appId", appId);
        DWServiceContext.getContext().setProfile(profile);
    }
}

