/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.gateway.controller;

import com.digiwin.app.container.DWContainerContext;
import com.digiwin.app.container.DWDefaultParameters;
import com.digiwin.app.container.DWHeader;
import com.digiwin.app.container.DWMethod;
import com.digiwin.app.container.DWParameters;
import com.digiwin.app.container.DWTargetAPI;
import com.digiwin.app.eai.CallbackTask;
import com.digiwin.app.eai.DWEAICallback;
import com.digiwin.app.eai.DWEAIProperties;
import com.digiwin.app.eai.DigiSrvcode;
import com.digiwin.app.eai.EAIExceptionHandler;
import com.digiwin.app.eai.FasyncChainTask;
import com.digiwin.app.eai.FasyncTask;
import com.digiwin.app.eai.exception.DWEaiException;
import com.digiwin.app.json.gson.DWGsonProvider;
import com.digiwin.app.log.DapLogUtils;
import com.digiwin.app.log.dto.DapLogDto;
import com.digiwin.app.log.service.DapLogService;
import com.digiwin.app.module.DWModuleClassLoader;
import com.digiwin.app.service.DWEAIChainEndResult;
import com.digiwin.app.service.DWEAIChainProgressResult;
import com.digiwin.app.service.DWEAIChainResult;
import com.digiwin.app.service.DWEAIChainTotalResult;
import com.digiwin.app.service.DWEAIErrorResult;
import com.digiwin.app.service.DWEAIFasyncChainEndResult;
import com.digiwin.app.service.DWEAIFasyncChainResult;
import com.digiwin.app.service.DWEAIFasyncResult;
import com.digiwin.app.service.DWEAIFasyncTaskResult;
import com.digiwin.app.service.DWEAIResult;
import com.digiwin.app.service.DWServiceChainContext;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.app.service.eai.DWEAIHeaderRepository;
import com.digiwin.app.service.utils.DWServiceChainUtils;
import com.digiwin.gateway.controller.EaiInfoUtils;
import com.digiwin.service.permission.pojo.DWSecurityContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.logging.log4j.ThreadContext;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.core.env.Environment;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class EaiController {
    private static Log log = LogFactory.getLog(EaiController.class);
    private static final String CHAIN_PARAMETER_PREFIX = "eai:chain:parameter:";
    private static final String CHAIN_HISTORY_PREFIX = "eai:chain:history:";
    private static final String CHAIN_SIGNAL_PREFIX = "eai:chain:signal:";
    private static final String CHAIN_PROGRESS_SYNC_PREFIX = "eai:chain:progress:sync:";
    private static final String CHAIN_PROGRESS_FASYNC_PREFIX = "eai:chain:progress:fasync:";
    private static final String CHAIN_PROGRESS_FASYNC_HEADER_PREFIX = "eai:chain:progress:fasync:header:";
    private static final String KEY_TARGET_API = "targetAPI";
    private static final String KEY_HEADERS = "headers";
    private static final String KEY_DIGI_SRVVER = "digi-srvver";
    private static final String KEY_DIGI_SRVCODE = "digi-srvcode";
    private static final List<String> SERVICE_HEADER_WHITELIST = Stream.of("token", "routerkey", "locale", "innertoken", "security-token", "digi-compressed", "tx-xid", "Pinpoint-TraceID", "Pinpoint-SpanID", "Pinpoint-pSpanID", "Pinpoint-Flags", "Pinpoint-pAppName", "Pinpoint-pAppType", "Pinpoint-Host", "pinpoint-traceid", "pinpoint-spanid", "pinpoint-pspanid", "pinpoint-flags", "pinpoint-pappname", "pinpoint-papptype", "pinpoint-host", "traceId").collect(Collectors.toCollection(ArrayList::new));
    private static final List<String> CALLBACK_HEADER_WHITELIST = Stream.of("routerkey", "security-token", "digi-compressed", "locale").collect(Collectors.toCollection(ArrayList::new));
    @Autowired
    private EAIExceptionHandler eaiExceptionHandler;
    @Autowired
    private DWContainerContext containerContext;
    @Autowired
    private DWEAIHeaderRepository eaiHeaderRepository;
    @Autowired
    private DWEAIProperties properties;
    @Autowired
    Environment environment;
    @Autowired(required=false)
    @Qualifier(value="redisTemplate")
    private RedisTemplate<String, Object> redis;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object callback() throws Exception {
        HttpServletRequest request = EaiInfoUtils.getRequest();
        HttpServletResponse response = EaiInfoUtils.getResponse();
        Map profile = DWServiceContext.getContext().getProfile();
        if (profile == null) {
            profile = Collections.emptyMap();
        }
        String digiSrvver = this.properties.getHostVer();
        Object result = null;
        DigiSrvcode digiSrvcode = DigiSrvcode.success;
        String parentDigiReqid = this.getParentDigiReqid();
        Map<String, Object> requestHeader = this.getRequestHeader();
        Object invokeResult = null;
        try {
            DWEAIResult dwEaiResult;
            Set keys;
            DWTargetAPI api = (DWTargetAPI)request.getAttribute(KEY_TARGET_API);
            DWParameters apiParameters = (DWParameters)request.getAttribute("targetParameters");
            Map parameters = ((DWDefaultParameters)apiParameters).getPararmeters();
            Map headers = parameters.getOrDefault(KEY_HEADERS, new HashMap());
            if (this.redis.hasKey((Object)(CHAIN_PARAMETER_PREFIX + parentDigiReqid)).booleanValue()) {
                keys = this.redis.opsForHash().keys((Object)(CHAIN_PARAMETER_PREFIX + parentDigiReqid));
                for (Object key : keys) {
                    String chainParameter = (String)this.redis.opsForHash().get((Object)(CHAIN_PARAMETER_PREFIX + parentDigiReqid), key);
                    headers.put((String)key + "-parameter", chainParameter);
                }
            }
            if (this.redis.hasKey((Object)(CHAIN_HISTORY_PREFIX + parentDigiReqid)).booleanValue()) {
                keys = this.redis.opsForHash().keys((Object)(CHAIN_HISTORY_PREFIX + parentDigiReqid));
                for (Object key : keys) {
                    String chainHistory = (String)this.redis.opsForHash().get((Object)(CHAIN_HISTORY_PREFIX + parentDigiReqid), key);
                    headers.put((String)key + "-history", chainHistory);
                }
            }
            parameters.put(KEY_HEADERS, headers);
            apiParameters = new DWDefaultParameters(parameters);
            invokeResult = this.containerContext.invoke(api, apiParameters, profile);
            if (invokeResult != null && invokeResult.getClass().equals(DWEAIResult.class)) {
                digiSrvcode = ((DWEAIResult)invokeResult).getDigiSrvcodeOrDefault(DigiSrvcode.success);
                result = DWGsonProvider.getGson().toJson(invokeResult, DWEAIResult.class);
            } else if (invokeResult != null && invokeResult.getClass().equals(DWEAIChainProgressResult.class)) {
                DWEAIChainProgressResult chainProgressResult = (DWEAIChainProgressResult)invokeResult;
                digiSrvcode = chainProgressResult.getDigiSrvcodeOrDefault(DigiSrvcode.success);
                Map chainParameter = chainProgressResult.getChainParameter();
                String callback = this.getCallbackId();
                this.attachChainParameter(chainParameter, parentDigiReqid, callback);
                DWEAIResult dwEaiResult2 = chainProgressResult.getDWEAIResult();
                result = DWGsonProvider.getGson().toJson((Object)dwEaiResult2, DWEAIResult.class);
                this.redis.opsForHash().put((Object)(CHAIN_HISTORY_PREFIX + parentDigiReqid), (Object)callback, result);
                this.redis.expire((Object)(CHAIN_HISTORY_PREFIX + parentDigiReqid), this.properties.getRedisKeyExpireTime(), TimeUnit.SECONDS);
            } else if (invokeResult != null && invokeResult.getClass().equals(DWEAIFasyncChainEndResult.class)) {
                Object redisValue;
                DWEAIFasyncChainEndResult fasyncChainEndResult = (DWEAIFasyncChainEndResult)invokeResult;
                digiSrvcode = fasyncChainEndResult.getDigiSrvcodeOrDefault(DigiSrvcode.success);
                CallbackTask callbackTask = fasyncChainEndResult.getCallbackTask();
                DWServiceContext finalContext = DWServiceContext.getContext().deepClone();
                DWSecurityContext finalSecurityContext = DWSecurityContext.getSecurityContext().deepClone();
                Map redisCallbackHeader = null;
                if (this.redis != null && (redisValue = this.redis.opsForValue().get((Object)(CHAIN_PROGRESS_FASYNC_HEADER_PREFIX + parentDigiReqid))) != null) {
                    redisCallbackHeader = (Map)redisValue;
                }
                Map<String, Object> callbackHeader = redisCallbackHeader == null || redisCallbackHeader.isEmpty() ? new HashMap<String, Object>(requestHeader) : redisCallbackHeader;
                Locale locale = LocaleContextHolder.getLocale();
                String currentModule = DWModuleClassLoader.getCurrentModuleName();
                DWServiceChainContext serviceChainContext = DWServiceChainContext.getContext();
                String pTxId = ThreadContext.get((String)"PtxId");
                ExecutorService executorService = Executors.newSingleThreadExecutor();
                try {
                    executorService.submit(() -> {
                        try {
                            LocaleContextHolder.setLocale((Locale)locale);
                            DWModuleClassLoader.setCurrentModuleName((String)currentModule);
                            DWServiceChainContext.recovery((DWServiceChainContext)serviceChainContext);
                            ThreadContext.put((String)"PtxId", (String)pTxId);
                            DWServiceContext.setContext((DWServiceContext)finalContext);
                            DWSecurityContext.setSecurityContext((DWSecurityContext)finalSecurityContext);
                            DWEAIFasyncTaskResult eaiFasyncTaskResult = fasyncChainEndResult.getDWEAIFasyncTaskResult();
                            DWServiceContext.getContext().setRequestHeader(callbackHeader);
                            this.onEaiCallback(parentDigiReqid, eaiFasyncTaskResult, callbackTask, callbackHeader);
                        }
                        catch (Throwable e) {
                            this.onFasyncException(e, parentDigiReqid, callbackTask);
                        }
                        finally {
                            this.clearChain(parentDigiReqid);
                        }
                    });
                }
                finally {
                    if (executorService != null) {
                        // empty if block
                    }
                }
                DWEAIResult dwEaiResult3 = fasyncChainEndResult.getDWEAIResult();
                result = DWGsonProvider.getGson().toJson((Object)dwEaiResult3, DWEAIResult.class);
            } else if (invokeResult != null && invokeResult.getClass().equals(DWEAIChainEndResult.class)) {
                DWEAIChainEndResult chainEndResult = (DWEAIChainEndResult)invokeResult;
                digiSrvcode = chainEndResult.getDigiSrvcodeOrDefault(DigiSrvcode.success);
                dwEaiResult = chainEndResult.getDWEAIResult();
                result = DWGsonProvider.getGson().toJson((Object)dwEaiResult, DWEAIResult.class);
                DWEAIChainTotalResult chainTotalResult = chainEndResult.getChainTotalResult();
                String totalResult = DWGsonProvider.getGson().toJson((Object)chainTotalResult, DWEAIChainTotalResult.class);
                this.redis.opsForValue().set((Object)(CHAIN_SIGNAL_PREFIX + parentDigiReqid), (Object)totalResult, this.properties.getRedisKeyExpireTime(), TimeUnit.SECONDS);
            } else if (invokeResult instanceof Map) {
                Map mapResult = (Map)invokeResult;
                if (mapResult.containsKey("std_data")) {
                    result = DWGsonProvider.getGson().toJson(invokeResult);
                } else {
                    dwEaiResult = new DWEAIResult("0", "", "", (Map)invokeResult);
                    result = DWGsonProvider.getGson().toJson((Object)dwEaiResult, DWEAIResult.class);
                }
            } else {
                result = invokeResult;
            }
            response.addHeader(KEY_DIGI_SRVVER, digiSrvver);
            response.addHeader(KEY_DIGI_SRVCODE, digiSrvcode.value());
        }
        catch (Throwable e) {
            try {
                response.addHeader(KEY_DIGI_SRVVER, digiSrvver);
                response.addHeader(KEY_DIGI_SRVCODE, DigiSrvcode.failure.value());
                String code = "-1";
                String sqlCode = "";
                String description = null;
                Map parameter = new HashMap();
                String message = null;
                String stacktrace = null;
                boolean isDwEaiException = false;
                DWEaiException eaiException = new DWEaiException();
                List throwableList = ExceptionUtils.getThrowableList((Throwable)e);
                for (Throwable throwable : throwableList) {
                    if (!(throwable instanceof DWEaiException)) continue;
                    eaiException = (DWEaiException)throwable;
                    isDwEaiException = true;
                }
                if (!isDwEaiException) {
                    eaiException = this.eaiExceptionHandler.parse(e);
                }
                String defaultDescription = this.getRootCausePureMessage(e);
                String defaultMessage = this.getRootCauseMessage(e);
                String defaultStacktrace = this.getStacktrace(e);
                code = eaiException.getCode();
                sqlCode = eaiException.getSqlCode();
                description = eaiException.getDescription(defaultDescription);
                parameter = eaiException.getParameter();
                message = eaiException.getMessage(defaultMessage);
                stacktrace = eaiException.getStacktrace(defaultStacktrace);
                DWEAIErrorResult dwEaiResult = new DWEAIErrorResult(code, sqlCode, description, parameter);
                dwEaiResult.setMessage(message);
                dwEaiResult.setStacktrace(stacktrace);
                result = DWGsonProvider.getGson().toJson((Object)dwEaiResult, dwEaiResult.getClass());
                if (this.redis.hasKey((Object)(CHAIN_PROGRESS_SYNC_PREFIX + parentDigiReqid)).booleanValue()) {
                    this.redis.opsForValue().set((Object)(CHAIN_SIGNAL_PREFIX + parentDigiReqid), result, this.properties.getRedisKeyExpireTime(), TimeUnit.SECONDS);
                } else if (this.redis.hasKey((Object)(CHAIN_PROGRESS_FASYNC_PREFIX + parentDigiReqid)).booleanValue()) {
                    this.onFasyncException(e, parentDigiReqid, null);
                    this.clearChain(parentDigiReqid);
                }
                this.logException(e);
            }
            catch (Throwable throwable) {
                if (DWServiceChainUtils.isServiceChainEnabled()) {
                    requestHeader.put(DWServiceChainUtils.HEADER_KEY_SERVICE_CHAIN_TARGET_ID, DWServiceChainContext.getContext().getId());
                }
                this.logEspUrl("response", invokeResult, requestHeader);
                throw throwable;
            }
            if (DWServiceChainUtils.isServiceChainEnabled()) {
                requestHeader.put(DWServiceChainUtils.HEADER_KEY_SERVICE_CHAIN_TARGET_ID, DWServiceChainContext.getContext().getId());
            }
            this.logEspUrl("response", invokeResult, requestHeader);
        }
        if (DWServiceChainUtils.isServiceChainEnabled()) {
            requestHeader.put(DWServiceChainUtils.HEADER_KEY_SERVICE_CHAIN_TARGET_ID, DWServiceChainContext.getContext().getId());
        }
        this.logEspUrl("response", invokeResult, requestHeader);
        HttpHeaders responseHeaders = new HttpHeaders();
        if (DWServiceChainUtils.isServiceChainEnabled()) {
            responseHeaders.add(DWServiceChainUtils.HEADER_KEY_SERVICE_CHAIN_TARGET_ID, DWServiceChainContext.getContext().getId());
        }
        return ((ResponseEntity.BodyBuilder)ResponseEntity.status((int)200).headers(responseHeaders)).body(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object eai() {
        Object result;
        HttpServletRequest request = EaiInfoUtils.getRequest();
        HttpServletResponse response = EaiInfoUtils.getResponse();
        Map profile = DWServiceContext.getContext().getProfile();
        if (profile == null) {
            profile = Collections.emptyMap();
        }
        String digiSrvver = this.properties.getHostVer();
        DigiSrvcode digiSrvcode = DigiSrvcode.success;
        try {
            DWTargetAPI api = (DWTargetAPI)request.getAttribute(KEY_TARGET_API);
            DWParameters apiParameters = (DWParameters)request.getAttribute("targetParameters");
            Object invokeResult = this.containerContext.invoke(api, apiParameters, profile);
            String digiReqid = this.getDigiReqid();
            Map<String, Object> requestHeader = this.getRequestHeader();
            if (invokeResult.getClass().equals(DWEAIResult.class)) {
                digiSrvcode = ((DWEAIResult)invokeResult).getDigiSrvcodeOrDefault(DigiSrvcode.success);
                result = DWGsonProvider.getGson().toJson(invokeResult, DWEAIResult.class);
                this.addSyncResponseHeader(response, digiReqid);
            } else if (invokeResult.getClass().equals(DWEAIChainResult.class)) {
                DWEAIChainResult chainResult = (DWEAIChainResult)invokeResult;
                Map chainParameter = chainResult.getChainParameter();
                String digiServiceName = DWServiceContext.getContext().getDigiServiceName();
                this.attachChainParameter(chainParameter, digiReqid, digiServiceName);
                this.redis.opsForValue().set((Object)(CHAIN_PROGRESS_SYNC_PREFIX + digiReqid), (Object)true, this.properties.getRedisKeyExpireTime(), TimeUnit.SECONDS);
                while (!this.redis.hasKey((Object)(CHAIN_SIGNAL_PREFIX + digiReqid)).booleanValue()) {
                }
                result = this.redis.opsForValue().get((Object)(CHAIN_SIGNAL_PREFIX + digiReqid));
                this.clearChain(digiReqid);
            } else if (invokeResult.getClass().equals(DWEAIFasyncResult.class)) {
                Object redisValue;
                DWEAIFasyncResult fasyncResult = (DWEAIFasyncResult)invokeResult;
                digiSrvcode = fasyncResult.getDigiSrvcodeOrDefault(DigiSrvcode.success);
                FasyncTask fasyncTask = fasyncResult.getFasyncTask();
                CallbackTask callbackTask = fasyncResult.getCallbackTask();
                DWServiceContext finalContext = DWServiceContext.getContext().deepClone();
                DWSecurityContext finalSecurityContext = DWSecurityContext.getSecurityContext().deepClone();
                Map redisCallbackHeader = null;
                if (this.redis != null && (redisValue = this.redis.opsForValue().get((Object)(CHAIN_PROGRESS_FASYNC_HEADER_PREFIX + digiReqid))) != null) {
                    redisCallbackHeader = (Map)redisValue;
                }
                Map<String, Object> callbackHeader = redisCallbackHeader == null || redisCallbackHeader.isEmpty() ? new HashMap<String, Object>(requestHeader) : redisCallbackHeader;
                Locale locale = LocaleContextHolder.getLocale();
                String currentModule = DWModuleClassLoader.getCurrentModuleName();
                DWServiceChainContext serviceChainContext = DWServiceChainContext.getContext();
                String pTxId = ThreadContext.get((String)"PtxId");
                ExecutorService executorService = Executors.newSingleThreadExecutor();
                try {
                    executorService.submit(() -> {
                        try {
                            LocaleContextHolder.setLocale((Locale)locale);
                            DWModuleClassLoader.setCurrentModuleName((String)currentModule);
                            DWServiceChainContext.recovery((DWServiceChainContext)serviceChainContext);
                            ThreadContext.put((String)"PtxId", (String)pTxId);
                            DWServiceContext.setContext((DWServiceContext)finalContext);
                            DWSecurityContext.setSecurityContext((DWSecurityContext)finalSecurityContext);
                            DWEAIFasyncTaskResult eaiFasyncTaskResult = fasyncTask.execute();
                            DWServiceContext.getContext().setRequestHeader(callbackHeader);
                            this.onEaiCallback(digiReqid, eaiFasyncTaskResult, callbackTask, callbackHeader, true);
                        }
                        catch (Throwable e) {
                            this.onFasyncException(e, digiReqid, callbackTask);
                        }
                        finally {
                            this.clearChain(digiReqid);
                        }
                    });
                }
                finally {
                    if (executorService != null) {
                        // empty if block
                    }
                }
                DWEAIResult dwEaiResult = fasyncResult.getDWEAIResult();
                result = DWGsonProvider.getGson().toJson((Object)dwEaiResult, DWEAIResult.class);
            } else if (invokeResult.getClass().equals(DWEAIFasyncChainResult.class)) {
                DWEAIFasyncChainResult fasyncChainResult = (DWEAIFasyncChainResult)invokeResult;
                digiSrvcode = fasyncChainResult.getDigiSrvcodeOrDefault(DigiSrvcode.success);
                FasyncChainTask fasyncChainTask = fasyncChainResult.getFasyncChainTask();
                CallbackTask callbackTask = fasyncChainResult.getCallbackTaskOnException();
                Map chainParameter = fasyncChainResult.getChainParameter();
                String digiServiceName = this.getDigiServiceName();
                this.attachChainParameter(chainParameter, digiReqid, digiServiceName);
                this.redis.opsForValue().set((Object)(CHAIN_PROGRESS_FASYNC_PREFIX + digiReqid), (Object)true, this.properties.getRedisKeyExpireTime(), TimeUnit.SECONDS);
                DWServiceContext finalContext = DWServiceContext.getContext().deepClone();
                DWSecurityContext finalSecurityContext = DWSecurityContext.getSecurityContext().deepClone();
                Locale locale = LocaleContextHolder.getLocale();
                String currentModule = DWModuleClassLoader.getCurrentModuleName();
                DWServiceChainContext serviceChainContext = DWServiceChainContext.getContext();
                String pTxId = ThreadContext.get((String)"PtxId");
                ExecutorService executorService = Executors.newSingleThreadExecutor();
                try {
                    executorService.submit(() -> {
                        try {
                            LocaleContextHolder.setLocale((Locale)locale);
                            DWModuleClassLoader.setCurrentModuleName((String)currentModule);
                            DWServiceChainContext.recovery((DWServiceChainContext)serviceChainContext);
                            ThreadContext.put((String)"PtxId", (String)pTxId);
                            DWServiceContext.setContext((DWServiceContext)finalContext);
                            DWSecurityContext.setSecurityContext((DWSecurityContext)finalSecurityContext);
                            fasyncChainTask.execute();
                        }
                        catch (Throwable e) {
                            this.onFasyncException(e, digiReqid, callbackTask);
                        }
                    });
                }
                finally {
                    if (executorService != null) {
                        // empty if block
                    }
                }
                DWEAIResult dwEaiResult = fasyncChainResult.getDWEAIResult();
                result = DWGsonProvider.getGson().toJson((Object)dwEaiResult, DWEAIResult.class);
            } else if (invokeResult instanceof Map) {
                Map mapResult = (Map)invokeResult;
                if (mapResult.containsKey("std_data")) {
                    result = DWGsonProvider.getGson().toJson(invokeResult);
                } else {
                    DWEAIResult dwEaiResult = new DWEAIResult("0", "", "", (Map)invokeResult);
                    result = DWGsonProvider.getGson().toJson((Object)dwEaiResult, dwEaiResult.getClass());
                }
                this.addSyncResponseHeader(response, digiReqid);
            } else {
                result = invokeResult;
                this.addSyncResponseHeader(response, digiReqid);
            }
            response.addHeader(KEY_DIGI_SRVVER, digiSrvver);
            response.addHeader(KEY_DIGI_SRVCODE, digiSrvcode.value());
        }
        catch (Throwable e) {
            response.addHeader(KEY_DIGI_SRVVER, digiSrvver);
            response.addHeader(KEY_DIGI_SRVCODE, DigiSrvcode.failure.value());
            String code = "-1";
            String sqlCode = "";
            String description = null;
            Map parameter = new HashMap();
            String message = null;
            String stacktrace = null;
            boolean isDwEaiException = false;
            DWEaiException eaiException = new DWEaiException();
            List throwableList = ExceptionUtils.getThrowableList((Throwable)e);
            for (Throwable throwable : throwableList) {
                if (!(throwable instanceof DWEaiException)) continue;
                eaiException = (DWEaiException)throwable;
                isDwEaiException = true;
            }
            if (!isDwEaiException) {
                eaiException = this.eaiExceptionHandler.parse(e);
            }
            String defaultDescription = this.getRootCausePureMessage(e);
            String defaultMessage = this.getRootCauseMessage(e);
            String defaultStacktrace = this.getStacktrace(e);
            code = eaiException.getCode();
            sqlCode = eaiException.getSqlCode();
            description = eaiException.getDescription(defaultDescription);
            parameter = eaiException.getParameter();
            message = eaiException.getMessage(defaultMessage);
            stacktrace = eaiException.getStacktrace(defaultStacktrace);
            DWEAIErrorResult dwEaiResult = new DWEAIErrorResult(code, sqlCode, description, parameter);
            dwEaiResult.setMessage(message);
            dwEaiResult.setStacktrace(stacktrace);
            result = DWGsonProvider.getGson().toJson((Object)dwEaiResult, dwEaiResult.getClass());
            this.logException(e);
        }
        HttpHeaders responseHeaders = new HttpHeaders();
        if (DWServiceChainUtils.isServiceChainEnabled()) {
            responseHeaders.add(DWServiceChainUtils.HEADER_KEY_SERVICE_CHAIN_TARGET_ID, DWServiceChainContext.getContext().getId());
        }
        return ((ResponseEntity.BodyBuilder)ResponseEntity.status((int)200).headers(responseHeaders)).body(result);
    }

    public Object syncProd() throws Exception {
        HttpServletRequest request = EaiInfoUtils.getRequest();
        String digiService = request.getHeader("digi-service");
        JSONObject digiServiceJo = new JSONObject(digiService);
        String name = digiServiceJo.getString("name");
        Map<Object, Object> result = new HashMap();
        HttpServletResponse response = EaiInfoUtils.getResponse();
        response.addHeader("Content-Type", "application/json; charset=UTF-8");
        switch (name) {
            case "getProdRegInfo": {
                response.addHeader("action", "reg");
                result = EaiInfoUtils.getProdRegInfo(this.environment, this.properties);
                break;
            }
            case "getSrvRegInfo": {
                response.addHeader("action", "reg");
                result = EaiInfoUtils.getSrvRegInfo(() -> ((DWEAIHeaderRepository)this.eaiHeaderRepository).getEaiServiceIdList(), this.properties);
                break;
            }
            case "doSyncProcess": {
                response.addHeader(KEY_DIGI_SRVCODE, "000");
                break;
            }
        }
        return result;
    }

    private String getRootCauseMessage(Throwable exception) {
        return ExceptionUtils.getRootCauseMessage((Throwable)exception);
    }

    private String getRootCausePureMessage(Throwable exception) {
        Throwable rootCause = ExceptionUtils.getRootCause((Throwable)exception);
        Throwable targetCause = rootCause != null ? rootCause : exception;
        String message = targetCause.getMessage();
        if (message == null || message.isEmpty()) {
            message = targetCause.toString();
        }
        return message;
    }

    private String getStacktrace(Throwable exception) {
        return ExceptionUtils.getStackTrace((Throwable)exception);
    }

    private void clearChain(String parentDigiReqid) {
        this.redis.delete((Object)(CHAIN_PARAMETER_PREFIX + parentDigiReqid));
        this.redis.delete((Object)(CHAIN_HISTORY_PREFIX + parentDigiReqid));
        this.redis.delete((Object)(CHAIN_SIGNAL_PREFIX + parentDigiReqid));
        this.redis.delete((Object)(CHAIN_PROGRESS_SYNC_PREFIX + parentDigiReqid));
        this.redis.delete((Object)(CHAIN_PROGRESS_FASYNC_PREFIX + parentDigiReqid));
        this.redis.delete((Object)(CHAIN_PROGRESS_FASYNC_HEADER_PREFIX + parentDigiReqid));
    }

    private void onFasyncException(Throwable e, String digiReqid, CallbackTask callbackTask) {
        this.logException(e);
        String code = "-1";
        String sqlCode = "";
        String description = this.getRootCauseMessage(e);
        DWEAICallback eaiCallback = new DWEAICallback(DigiSrvcode.failure.value(), digiReqid, code, sqlCode, description, new HashMap());
        Map callbackResult = eaiCallback.execute();
        if (callbackTask != null) {
            Map headers = (Map)callbackResult.get(KEY_HEADERS);
            String messageBody = (String)callbackResult.get("messageBody");
            callbackTask.execute(headers, messageBody);
        }
    }

    private void onEaiCallback(String digiReqid, DWEAIFasyncTaskResult eaiFasyncTaskResult, CallbackTask callbackTask, Map<String, Object> requestHeader) {
        this.onEaiCallback(digiReqid, eaiFasyncTaskResult, callbackTask, requestHeader, false);
    }

    /*
     * Unable to fully structure code
     */
    private void onEaiCallback(String digiReqid, DWEAIFasyncTaskResult eaiFasyncTaskResult, CallbackTask callbackTask, Map<String, Object> requestHeader, boolean isLmcLog) {
        eaiCallback = new DWEAICallback(digiReqid, eaiFasyncTaskResult);
        eaiCallback.setDigiDatakey(eaiFasyncTaskResult.getDigiDatakey());
        eaiCallback.setCustomHeader(eaiFasyncTaskResult.getCustomHeader());
        eaiCallback.setCustomCallbackHeader(eaiFasyncTaskResult.getCustomCallbackHeader());
        if (DWServiceChainUtils.isServiceChainEnabled()) {
            DWServiceChainUtils.beforeInvokeEAICallbackAPI(requestHeader);
        }
        if (requestHeader.containsKey("digi-callback-url") || requestHeader.containsKey("digi-callback-servicenameurl")) {
            this.logEspUrl("request", eaiFasyncTaskResult, requestHeader);
            try {
                callbackResult = eaiCallback.decentralization(requestHeader, isLmcLog);
                if (callbackResult == null || !callbackResult.containsKey("eai-response-http-status") || (responseHttpStatus = callbackResult.get("eai-response-http-status")) == null || !(responseHttpStatus instanceof Integer)) ** GOTO lbl22
                httpStatus = (Integer)responseHttpStatus;
                responseHeader = (Map)callbackResult.get("headers");
                responseBody = (String)callbackResult.get("messageBody");
                if ((Integer)responseHttpStatus == 200) ** GOTO lbl22
                this.logCallbackResponseNone200(requestHeader, httpStatus, responseHeader, responseBody);
            }
            catch (Exception e) {
                this.logEspUrl("request", eaiFasyncTaskResult, requestHeader, e);
                throw e;
            }
        } else {
            callbackResult = eaiCallback.execute();
        }
lbl22:
        // 4 sources

        if (callbackTask != null) {
            callbackHeaders = (Map)callbackResult.get("headers");
            callbackMessageBody = (String)callbackResult.get("messageBody");
            callbackTask.execute(callbackHeaders, callbackMessageBody);
        }
    }

    private void attachChainParameter(Map<String, Object> chainParameter, String digiReqid, String key) {
        String chainParameterString = DWGsonProvider.getGson().toJson(chainParameter, Map.class);
        this.redis.opsForHash().put((Object)(CHAIN_PARAMETER_PREFIX + digiReqid), (Object)key, (Object)chainParameterString);
        this.redis.expire((Object)(CHAIN_PARAMETER_PREFIX + digiReqid), this.properties.getRedisKeyExpireTime(), TimeUnit.SECONDS);
    }

    private String getParentDigiReqid() {
        return DWServiceContext.getContext().getRequestHeader().getOrDefault("digi-callback-parent-reqid", "");
    }

    private String getCallbackId() {
        return DWServiceContext.getContext().getRequestHeader().getOrDefault("digi-callback-callback", "");
    }

    private String getDigiReqid() {
        return DWServiceContext.getContext().getRequestHeader().getOrDefault("digi-reqid", "");
    }

    private Map<String, Object> getRequestHeader() {
        return DWServiceContext.getContext().getRequestHeader();
    }

    private String getDigiServiceName() {
        return DWServiceContext.getContext().getDigiServiceName();
    }

    private void logException(Throwable throwable) {
        try {
            String rootCauseMessage = this.getRootCauseMessage(throwable);
            String stacktrace = this.getStacktrace(throwable);
            HttpServletRequest request = EaiInfoUtils.getRequest();
            DWTargetAPI api = (DWTargetAPI)request.getAttribute(KEY_TARGET_API);
            DWHeader header = api.getHeader();
            DWMethod method = api.getMethod();
            String moduleName = header.getModuleName();
            String serviceName = header.getServiceName();
            String methodName = method.getMethodName();
            log.error((Object)String.format("[EaiController] module: %s, service: %s, method: %s", moduleName, serviceName, methodName));
            log.error((Object)String.format("[EaiController] root cause message: %s", rootCauseMessage));
            log.error((Object)String.format("[EaiController] stack trace: %s", stacktrace));
        }
        catch (Throwable ignore) {
            String stacktrace = this.getStacktrace(throwable);
            log.error((Object)String.format("[EaiController] on log exception: %s", stacktrace));
        }
    }

    private void logCallbackResponseNone200(Map<String, Object> requestHeader, int responseHttpStatusCode, Map<String, String> responseHeader, String responseBody) {
        DapLogUtils.DapLogCallbackResponseExtraInfo extraLogInfo = new DapLogUtils.DapLogCallbackResponseExtraInfo(responseHttpStatusCode, responseHeader, responseBody);
        this.logEspUrl("noneHttpStatus200", extraLogInfo, requestHeader, null);
    }

    private void logEspUrl(String logType, Object invokeResult, Map<String, Object> requestHeader) {
        this.logEspUrl(logType, invokeResult, requestHeader, null);
    }

    private void logEspUrl(String logType, Object invokeResult, Map<String, Object> requestHeader, Exception exInInvocation) {
        try {
            if (StringUtils.isBlank((CharSequence)requestHeader.getOrDefault("digi-callback-logurl", "").toString()) && StringUtils.isBlank((CharSequence)requestHeader.getOrDefault("digi-callback-url", "").toString())) {
                return;
            }
            DapLogService.saveLog((DapLogDto)DapLogUtils.getDapCallbackLog((String)logType, (Object)invokeResult, requestHeader, (Exception)exInInvocation));
        }
        catch (Throwable e) {
            log.error((Object)"send esp log fail e:", e);
        }
    }

    private void addSyncResponseHeader(HttpServletResponse response, String digiReqid) {
        Map redisHeader = null;
        if (this.redis != null) {
            Object redisValue = this.redis.opsForValue().get((Object)(CHAIN_PROGRESS_FASYNC_HEADER_PREFIX + digiReqid));
            if (redisValue != null) {
                redisHeader = (Map)redisValue;
            }
            this.redis.delete((Object)(CHAIN_PROGRESS_FASYNC_HEADER_PREFIX + digiReqid));
        }
        Map prepareForResponseHeader = redisHeader == null || redisHeader.isEmpty() ? new HashMap() : redisHeader;
        for (Map.Entry entry : prepareForResponseHeader.entrySet()) {
            String key = (String)entry.getKey();
            if (!SERVICE_HEADER_WHITELIST.contains(key) && !key.startsWith("digi-callback-")) continue;
            Object value = entry.getValue();
            String stringValue = "";
            if (value != null) {
                stringValue = String.valueOf(value);
            }
            response.addHeader(key, stringValue);
        }
    }
}

