/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.gateway.event;

import com.digiwin.app.container.DWDefaultParameters;
import com.digiwin.app.dao.datasource.DWAbstractTenantDataSource;
import com.digiwin.app.dao.datasource.DWDataSourceConstants;
import com.digiwin.app.dao.datasource.DWTenantRoutingDataSource;
import com.digiwin.app.module.spring.SpringContextUtils;
import com.digiwin.app.service.DWServiceGroupInfoProvider;
import com.digiwin.gateway.event.DWDataSourceEvent;
import com.digiwin.gateway.event.DWDataSourceEventParameters;
import com.digiwin.gateway.event.DWDataSourceEventResult;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;

public class DWDataSourceEventImpl
implements DWDataSourceEvent {
    private static final Log log = LogFactory.getLog(DWDataSourceEventImpl.class);
    private static final String CLASS_TAG = "[DWDataSourceEventImpl] ";
    private static final String KEY_DATA_SOURCE_NAME = "DWAbstractTenantDataSource";
    private static final String KEY_ROUTING_DATA_SOURCE_NAME = "AbstractRoutingDataSource";

    @Override
    public DWDataSourceEventResult doInvoke(DWDefaultParameters params) throws Exception {
        return this.invokeDataSourceUpdate(params);
    }

    private DWDataSourceEventResult invokeDataSourceUpdate(DWDefaultParameters params) throws Exception {
        String resultMsg = "";
        log.debug((Object)"[DWDataSourceEventImpl] update starting...");
        List<String> moduleNames = ((DWDataSourceEventParameters)params).getData();
        Map<String, Object> data = this.updateTenantDataSource(this.filterLoadedModules(moduleNames));
        log.debug((Object)"[DWDataSourceEventImpl] update finished");
        return new DWDataSourceEventResult(this, true, resultMsg, data);
    }

    public Map<String, Object> updateTenantDataSource(List<String> moduleNames) throws Exception {
        DWServiceGroupInfoProvider groupInfoProvider = (DWServiceGroupInfoProvider)SpringContextUtils.getContext().getBean(DWServiceGroupInfoProvider.class);
        HashMap<String, Object> result = new HashMap<String, Object>();
        log.debug((Object)("[DWDataSourceEventImpl] need to update " + moduleNames.size() + " module(s)"));
        for (String moduleName : moduleNames) {
            log.debug((Object)(CLASS_TAG + moduleName + " processing..."));
            HashMap<String, Object> moduleResult = new HashMap<String, Object>();
            boolean moduleUpdateSuccess = true;
            if (groupInfoProvider.isLoaded(moduleName)) {
                HashMap<String, String> updateResult = new HashMap<String, String>();
                ApplicationContext moduleSpringContext = groupInfoProvider.getSpringContext(moduleName);
                DWAbstractTenantDataSource tenantDSBean = (DWAbstractTenantDataSource)moduleSpringContext.getBean(DWAbstractTenantDataSource.class);
                DWTenantRoutingDataSource routingDSBean = (DWTenantRoutingDataSource)moduleSpringContext.getBean(DWTenantRoutingDataSource.class);
                if (tenantDSBean != null && routingDSBean != null) {
                    tenantDSBean.initialize(moduleName);
                    routingDSBean.setMultipleDataSources(tenantDSBean);
                    updateResult.put(KEY_DATA_SOURCE_NAME, tenantDSBean.getClass().getName());
                    updateResult.put(KEY_ROUTING_DATA_SOURCE_NAME, routingDSBean.getClass().getName());
                } else {
                    moduleUpdateSuccess = false;
                    updateResult.put("message", "required bean(s) is not existed");
                    String beanName = null;
                    if (tenantDSBean != null) {
                        beanName = tenantDSBean.getClass().getName();
                    }
                    updateResult.put(KEY_DATA_SOURCE_NAME, beanName);
                    beanName = null;
                    if (routingDSBean != null) {
                        beanName = routingDSBean.getClass().getName();
                    }
                    updateResult.put(KEY_ROUTING_DATA_SOURCE_NAME, beanName);
                }
                moduleResult.put("data", updateResult);
                moduleResult.put("success", moduleUpdateSuccess);
                result.put(moduleName, moduleResult);
                continue;
            }
            String message = CLASS_TAG + moduleName + " can not find key in SpringContexts, maybe not loaded yet";
            moduleResult.put("message", message);
            moduleResult.put("success", moduleUpdateSuccess);
            result.put(moduleName, moduleResult);
            log.warn((Object)message);
        }
        return result;
    }

    private List<String> filterLoadedModules(List<String> requestModules) {
        List<String> moduleNames;
        Objects.requireNonNull(requestModules);
        if (requestModules.size() == 1 && "*".equals(requestModules.get(0))) {
            DWServiceGroupInfoProvider groupInfoProvider = (DWServiceGroupInfoProvider)SpringContextUtils.getContext().getBean(DWServiceGroupInfoProvider.class);
            Set loadedModules = groupInfoProvider.getNames();
            moduleNames = loadedModules.stream().collect(Collectors.toList());
        } else {
            moduleNames = requestModules;
        }
        moduleNames.removeAll(DWDataSourceConstants.KEY_MULTIPLE_SYS_MODULES);
        return moduleNames;
    }
}

