/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.gateway.event;

import com.digiwin.app.container.DWContainerContext;
import com.digiwin.app.container.DWDefaultParameters;
import com.digiwin.app.container.DWParameters;
import com.digiwin.app.container.exceptions.DWRuntimeException;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.app.service.DWServiceResult;
import com.digiwin.gateway.event.DWScheduleEvent;
import com.digiwin.gateway.event.DWScheduleEventConfig;
import com.digiwin.gateway.event.DWScheduleEventResult;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.annotation.Configuration;

@Configuration
public class DWScheduleEventImpl
implements DWScheduleEvent {
    private static final Log log = LogFactory.getLog(DWScheduleEventImpl.class);
    private static final String CLASS_TAG = "[DWScheduleEventImpl]";

    private static void staticInitializer() {
        try {
            DWScheduleEventConfig.register(new DWScheduleEventImpl());
        }
        catch (Exception e) {
            throw new DWRuntimeException("[DWScheduleEventImpl] register init event failed. check logs for details!", (Throwable)e);
        }
    }

    @Override
    public DWScheduleEventResult doInvoke(DWDefaultParameters params) throws Exception {
        return this.invokeScheduleStop(params);
    }

    @Override
    public DWScheduleEventResult doInvokeForActive(DWDefaultParameters params) throws Exception {
        return this.invokeScheduleStart(params);
    }

    private DWScheduleEventResult invokeScheduleStop(DWDefaultParameters params) throws Exception {
        String resultMsg = "";
        log.debug((Object)"[DWScheduleEventImpl] start");
        Map profile = DWServiceContext.getContext().getProfile();
        String key_tenant_sid = "tenantSid";
        String key_params = "params";
        ArrayList<Long> tenantSids = new ArrayList<Long>();
        Map paramMap = (Map)params.getPararmeters().get(key_params);
        Long tenantSid = Long.parseLong(Objects.toString(paramMap.get(key_tenant_sid), "0"));
        tenantSids.add(tenantSid);
        paramMap.put(key_tenant_sid, tenantSids);
        params.getPararmeters().put(key_params, paramMap);
        DWServiceResult reportObject = (DWServiceResult)DWContainerContext.getInstance().invoke("DWSys", "ITenantScheduleBatchService", "postStop", (DWParameters)params, profile);
        log.debug((Object)"[DWScheduleEventImpl] end");
        Object data = reportObject.getData();
        return new DWScheduleEventResult(this, true, resultMsg, data);
    }

    private DWScheduleEventResult invokeScheduleStart(DWDefaultParameters params) throws Exception {
        String resultMsg = "";
        log.debug((Object)"[DWScheduleEventImpl] start");
        Map profile = DWServiceContext.getContext().getProfile();
        DWServiceResult reportObject = (DWServiceResult)DWContainerContext.getInstance().invoke("DWSys", "ITenantScheduleBatchService", "postStart", (DWParameters)params, profile);
        log.debug((Object)"[DWScheduleEventImpl] end");
        Object data = reportObject.getData();
        return new DWScheduleEventResult(this, true, resultMsg, data);
    }

    static {
        DWScheduleEventImpl.staticInitializer();
    }
}

