/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.gateway.controller;

import com.digiwin.app.container.DWContainerContext;
import com.digiwin.app.container.DWDefaultParameters;
import com.digiwin.app.container.DWHeader;
import com.digiwin.app.container.DWMethod;
import com.digiwin.app.container.DWParameters;
import com.digiwin.app.container.DWTargetAPI;
import com.digiwin.app.eai.CallbackTask;
import com.digiwin.app.eai.DWEAICallback;
import com.digiwin.app.eai.DWEAIProperties;
import com.digiwin.app.eai.DigiSrvcode;
import com.digiwin.app.eai.EAIExceptionHandler;
import com.digiwin.app.eai.FasyncChainTask;
import com.digiwin.app.eai.FasyncTask;
import com.digiwin.app.eai.exception.DWEaiException;
import com.digiwin.app.json.gson.DWGsonProvider;
import com.digiwin.app.module.DWModuleClassLoader;
import com.digiwin.app.module.spring.DWModuleSpringUtils;
import com.digiwin.app.module.spring.SpringContextUtils;
import com.digiwin.app.service.DWEAIChainEndResult;
import com.digiwin.app.service.DWEAIChainProgressResult;
import com.digiwin.app.service.DWEAIChainResult;
import com.digiwin.app.service.DWEAIChainTotalResult;
import com.digiwin.app.service.DWEAIErrorResult;
import com.digiwin.app.service.DWEAIFasyncChainEndResult;
import com.digiwin.app.service.DWEAIFasyncChainResult;
import com.digiwin.app.service.DWEAIFasyncResult;
import com.digiwin.app.service.DWEAIFasyncTaskResult;
import com.digiwin.app.service.DWEAIResult;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.app.service.eai.DWEAIHeaderRepository;
import com.digiwin.gateway.controller.EaiInfoUtils;
import com.digiwin.gateway.http.DWRequestWrapper;
import com.digiwin.gateway.service.eai.IEAISyncProdService;
import com.digiwin.gateway.service.eai.SyncProdServiceVo;
import com.digiwin.gateway.service.permission.DWSecurityContext;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.Executors;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.core.env.Environment;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class EaiController {
    private static Log log = LogFactory.getLog(EaiController.class);
    private static final String CHAIN_PARAMETER_PREFIX = "eai:chain:parameter:";
    private static final String CHAIN_HISTORY_PREFIX = "eai:chain:history:";
    private static final String CHAIN_SIGNAL_PREFIX = "eai:chain:signal:";
    private static final String CHAIN_PROGRESS_SYNC_PREFIX = "eai:chain:progress:sync:";
    private static final String CHAIN_PROGRESS_FASYNC_PREFIX = "eai:chain:progress:fasync:";
    private static final String KEY_TARGET_API = "targetAPI";
    private static final String KEY_HEADERS = "headers";
    private static final String KEY_DIGI_SRVVER = "digi-srvver";
    private static final String KEY_DIGI_SRVCODE = "digi-srvcode";
    @Autowired
    private EAIExceptionHandler eaiExceptionHandler;
    @Autowired
    private DWContainerContext containerContext;
    @Autowired
    private DWEAIHeaderRepository eaiHeaderRepository;
    @Autowired
    private DWEAIProperties properties;
    @Autowired
    Environment environment;
    @Autowired(required=false)
    @Qualifier(value="redisTemplate")
    private RedisTemplate<String, Object> redis;

    public Object callback() throws Exception {
        Object result;
        HttpServletRequest request = EaiInfoUtils.getRequest();
        HttpServletResponse response = EaiInfoUtils.getResponse();
        Map profile = DWServiceContext.getContext().getProfile();
        if (profile == null) {
            profile = Collections.emptyMap();
        }
        String digiSrvver = this.properties.getHostVer();
        DigiSrvcode digiSrvcode = DigiSrvcode.success;
        String parentDigiReqid = this.getParentDigiReqid();
        Map<String, Object> requestHeader = this.getRequestHeader();
        try {
            DWEAIResult dwEaiResult;
            Set keys;
            DWTargetAPI api = (DWTargetAPI)request.getAttribute(KEY_TARGET_API);
            DWParameters apiParameters = (DWParameters)request.getAttribute("targetParameters");
            Map parameters = ((DWDefaultParameters)apiParameters).getPararmeters();
            Map headers = parameters.getOrDefault(KEY_HEADERS, new HashMap());
            if (this.redis.hasKey((Object)(CHAIN_PARAMETER_PREFIX + parentDigiReqid)).booleanValue()) {
                keys = this.redis.opsForHash().keys((Object)(CHAIN_PARAMETER_PREFIX + parentDigiReqid));
                for (Object key : keys) {
                    String chainParameter = (String)this.redis.opsForHash().get((Object)(CHAIN_PARAMETER_PREFIX + parentDigiReqid), key);
                    headers.put((String)key + "-parameter", chainParameter);
                }
            }
            if (this.redis.hasKey((Object)(CHAIN_HISTORY_PREFIX + parentDigiReqid)).booleanValue()) {
                keys = this.redis.opsForHash().keys((Object)(CHAIN_HISTORY_PREFIX + parentDigiReqid));
                for (Object key : keys) {
                    String chainHistory = (String)this.redis.opsForHash().get((Object)(CHAIN_HISTORY_PREFIX + parentDigiReqid), key);
                    headers.put((String)key + "-history", chainHistory);
                }
            }
            parameters.put(KEY_HEADERS, headers);
            apiParameters = new DWDefaultParameters(parameters);
            Object invokeResult = this.containerContext.invoke(api, apiParameters, profile);
            if (invokeResult != null && invokeResult.getClass().equals(DWEAIResult.class)) {
                digiSrvcode = ((DWEAIResult)invokeResult).getDigiSrvcodeOrDefault(DigiSrvcode.success);
                result = DWGsonProvider.getGson().toJson(invokeResult, DWEAIResult.class);
            } else if (invokeResult != null && invokeResult.getClass().equals(DWEAIChainProgressResult.class)) {
                DWEAIChainProgressResult chainProgressResult = (DWEAIChainProgressResult)invokeResult;
                digiSrvcode = chainProgressResult.getDigiSrvcodeOrDefault(DigiSrvcode.success);
                Map chainParameter = chainProgressResult.getChainParameter();
                String callback = this.getCallbackId();
                this.attachChainParameter(chainParameter, parentDigiReqid, callback);
                DWEAIResult dwEaiResult2 = chainProgressResult.getDWEAIResult();
                result = DWGsonProvider.getGson().toJson((Object)dwEaiResult2, DWEAIResult.class);
                this.redis.opsForHash().put((Object)(CHAIN_HISTORY_PREFIX + parentDigiReqid), (Object)callback, result);
            } else if (invokeResult != null && invokeResult.getClass().equals(DWEAIFasyncChainEndResult.class)) {
                DWEAIFasyncChainEndResult fasyncChainEndResult = (DWEAIFasyncChainEndResult)invokeResult;
                digiSrvcode = fasyncChainEndResult.getDigiSrvcodeOrDefault(DigiSrvcode.success);
                CallbackTask callbackTask = fasyncChainEndResult.getCallbackTask();
                DWServiceContext finalContext = DWServiceContext.getContext().deepClone();
                DWSecurityContext finalSecurityContext = DWSecurityContext.getSecurityContext().deepClone();
                Locale locale = LocaleContextHolder.getLocale();
                String currentModule = DWServiceContext.getContext().getGroupName();
                Executors.newSingleThreadExecutor().submit(() -> {
                    try {
                        LocaleContextHolder.setLocale((Locale)locale);
                        DWModuleClassLoader.setCurrentModuleName((String)currentModule);
                        DWServiceContext.setContext((DWServiceContext)finalContext);
                        DWSecurityContext.setSecurityContext((DWSecurityContext)finalSecurityContext);
                        DWEAIFasyncTaskResult eaiFasyncTaskResult = fasyncChainEndResult.getDWEAIFasyncTaskResult();
                        this.onEaiCallback(parentDigiReqid, eaiFasyncTaskResult, callbackTask, requestHeader);
                    }
                    catch (Throwable e) {
                        this.onFasyncException(e, parentDigiReqid, callbackTask);
                    }
                    finally {
                        this.clearChain(parentDigiReqid);
                    }
                });
                DWEAIResult dwEaiResult3 = fasyncChainEndResult.getDWEAIResult();
                result = DWGsonProvider.getGson().toJson((Object)dwEaiResult3, DWEAIResult.class);
            } else if (invokeResult != null && invokeResult.getClass().equals(DWEAIChainEndResult.class)) {
                DWEAIChainEndResult chainEndResult = (DWEAIChainEndResult)invokeResult;
                digiSrvcode = chainEndResult.getDigiSrvcodeOrDefault(DigiSrvcode.success);
                dwEaiResult = chainEndResult.getDWEAIResult();
                result = DWGsonProvider.getGson().toJson((Object)dwEaiResult, DWEAIResult.class);
                DWEAIChainTotalResult chainTotalResult = chainEndResult.getChainTotalResult();
                String totalResult = DWGsonProvider.getGson().toJson((Object)chainTotalResult, DWEAIChainTotalResult.class);
                this.redis.opsForValue().set((Object)(CHAIN_SIGNAL_PREFIX + parentDigiReqid), (Object)totalResult);
            } else if (invokeResult instanceof Map) {
                Map mapResult = (Map)invokeResult;
                if (mapResult.containsKey("std_data")) {
                    result = DWGsonProvider.getGson().toJson(invokeResult);
                } else {
                    dwEaiResult = new DWEAIResult("0", "", "", (Map)invokeResult);
                    result = DWGsonProvider.getGson().toJson((Object)dwEaiResult, DWEAIResult.class);
                }
            } else {
                result = invokeResult;
            }
            response.addHeader(KEY_DIGI_SRVVER, digiSrvver);
            response.addHeader(KEY_DIGI_SRVCODE, digiSrvcode.value());
        }
        catch (Throwable e) {
            response.addHeader(KEY_DIGI_SRVVER, digiSrvver);
            response.addHeader(KEY_DIGI_SRVCODE, DigiSrvcode.failure.value());
            String code = "-1";
            String sqlCode = "";
            String description = null;
            Map parameter = new HashMap();
            String message = null;
            String stacktrace = null;
            boolean isDwEaiException = false;
            DWEaiException eaiException = new DWEaiException();
            List throwableList = ExceptionUtils.getThrowableList((Throwable)e);
            for (Throwable throwable : throwableList) {
                if (!(throwable instanceof DWEaiException)) continue;
                eaiException = (DWEaiException)throwable;
                isDwEaiException = true;
            }
            if (!isDwEaiException) {
                eaiException = this.eaiExceptionHandler.parse(e);
            }
            String defaultDescription = this.getRootCausePureMessage(e);
            String defaultMessage = this.getRootCauseMessage(e);
            String defaultStacktrace = this.getStacktrace(e);
            code = eaiException.getCode();
            sqlCode = eaiException.getSqlCode();
            description = eaiException.getDescription(defaultDescription);
            parameter = eaiException.getParameter();
            message = eaiException.getMessage(defaultMessage);
            stacktrace = eaiException.getStacktrace(defaultStacktrace);
            DWEAIErrorResult dwEaiResult = new DWEAIErrorResult(code, sqlCode, description, parameter);
            dwEaiResult.setMessage(message);
            dwEaiResult.setStacktrace(stacktrace);
            result = DWGsonProvider.getGson().toJson((Object)dwEaiResult, dwEaiResult.getClass());
            if (this.redis.hasKey((Object)(CHAIN_PROGRESS_SYNC_PREFIX + parentDigiReqid)).booleanValue()) {
                this.redis.opsForValue().set((Object)(CHAIN_SIGNAL_PREFIX + parentDigiReqid), result);
            } else if (this.redis.hasKey((Object)(CHAIN_PROGRESS_FASYNC_PREFIX + parentDigiReqid)).booleanValue()) {
                this.onFasyncException(e, parentDigiReqid, null);
                this.clearChain(parentDigiReqid);
            }
            this.logException(e);
        }
        return result;
    }

    public Object eai() {
        Object result;
        HttpServletRequest request = EaiInfoUtils.getRequest();
        HttpServletResponse response = EaiInfoUtils.getResponse();
        Map profile = DWServiceContext.getContext().getProfile();
        if (profile == null) {
            profile = Collections.emptyMap();
        }
        String digiSrvver = this.properties.getHostVer();
        DigiSrvcode digiSrvcode = DigiSrvcode.success;
        try {
            DWTargetAPI api = (DWTargetAPI)request.getAttribute(KEY_TARGET_API);
            DWParameters apiParameters = (DWParameters)request.getAttribute("targetParameters");
            Object invokeResult = this.containerContext.invoke(api, apiParameters, profile);
            String digiReqid = this.getDigiReqid();
            Map<String, Object> requestHeader = this.getRequestHeader();
            if (invokeResult.getClass().equals(DWEAIResult.class)) {
                digiSrvcode = ((DWEAIResult)invokeResult).getDigiSrvcodeOrDefault(DigiSrvcode.success);
                result = DWGsonProvider.getGson().toJson(invokeResult, DWEAIResult.class);
            } else if (invokeResult.getClass().equals(DWEAIChainResult.class)) {
                DWEAIChainResult chainResult = (DWEAIChainResult)invokeResult;
                Map chainParameter = chainResult.getChainParameter();
                String digiServiceName = DWServiceContext.getContext().getDigiServiceName();
                this.attachChainParameter(chainParameter, digiReqid, digiServiceName);
                this.redis.opsForValue().set((Object)(CHAIN_PROGRESS_SYNC_PREFIX + digiReqid), (Object)true);
                while (!this.redis.hasKey((Object)(CHAIN_SIGNAL_PREFIX + digiReqid)).booleanValue()) {
                }
                result = this.redis.opsForValue().get((Object)(CHAIN_SIGNAL_PREFIX + digiReqid));
                this.clearChain(digiReqid);
            } else if (invokeResult.getClass().equals(DWEAIFasyncResult.class)) {
                DWEAIFasyncResult fasyncResult = (DWEAIFasyncResult)invokeResult;
                digiSrvcode = fasyncResult.getDigiSrvcodeOrDefault(DigiSrvcode.success);
                FasyncTask fasyncTask = fasyncResult.getFasyncTask();
                CallbackTask callbackTask = fasyncResult.getCallbackTask();
                DWServiceContext finalContext = DWServiceContext.getContext().deepClone();
                DWSecurityContext finalSecurityContext = DWSecurityContext.getSecurityContext().deepClone();
                Locale locale = LocaleContextHolder.getLocale();
                String currentModule = DWServiceContext.getContext().getGroupName();
                Executors.newSingleThreadExecutor().submit(() -> {
                    try {
                        LocaleContextHolder.setLocale((Locale)locale);
                        DWModuleClassLoader.setCurrentModuleName((String)currentModule);
                        DWServiceContext.setContext((DWServiceContext)finalContext);
                        DWSecurityContext.setSecurityContext((DWSecurityContext)finalSecurityContext);
                        DWEAIFasyncTaskResult eaiFasyncTaskResult = fasyncTask.execute();
                        this.onEaiCallback(digiReqid, eaiFasyncTaskResult, callbackTask, requestHeader, true);
                    }
                    catch (Throwable e) {
                        this.onFasyncException(e, digiReqid, callbackTask);
                    }
                });
                DWEAIResult dwEaiResult = fasyncResult.getDWEAIResult();
                result = DWGsonProvider.getGson().toJson((Object)dwEaiResult, DWEAIResult.class);
            } else if (invokeResult.getClass().equals(DWEAIFasyncChainResult.class)) {
                DWEAIFasyncChainResult fasyncChainResult = (DWEAIFasyncChainResult)invokeResult;
                digiSrvcode = fasyncChainResult.getDigiSrvcodeOrDefault(DigiSrvcode.success);
                FasyncChainTask fasyncChainTask = fasyncChainResult.getFasyncChainTask();
                CallbackTask callbackTask = fasyncChainResult.getCallbackTaskOnException();
                Map chainParameter = fasyncChainResult.getChainParameter();
                String digiServiceName = this.getDigiServiceName();
                this.attachChainParameter(chainParameter, digiReqid, digiServiceName);
                this.redis.opsForValue().set((Object)(CHAIN_PROGRESS_FASYNC_PREFIX + digiReqid), (Object)true);
                DWServiceContext finalContext = DWServiceContext.getContext().deepClone();
                DWSecurityContext finalSecurityContext = DWSecurityContext.getSecurityContext().deepClone();
                Locale locale = LocaleContextHolder.getLocale();
                String currentModule = DWServiceContext.getContext().getGroupName();
                Executors.newSingleThreadExecutor().submit(() -> {
                    try {
                        LocaleContextHolder.setLocale((Locale)locale);
                        DWModuleClassLoader.setCurrentModuleName((String)currentModule);
                        DWServiceContext.setContext((DWServiceContext)finalContext);
                        DWSecurityContext.setSecurityContext((DWSecurityContext)finalSecurityContext);
                        fasyncChainTask.execute();
                    }
                    catch (Throwable e) {
                        this.onFasyncException(e, digiReqid, callbackTask);
                    }
                });
                DWEAIResult dwEaiResult = fasyncChainResult.getDWEAIResult();
                result = DWGsonProvider.getGson().toJson((Object)dwEaiResult, DWEAIResult.class);
            } else if (invokeResult instanceof Map) {
                Map mapResult = (Map)invokeResult;
                if (mapResult.containsKey("std_data")) {
                    result = DWGsonProvider.getGson().toJson(invokeResult);
                } else {
                    DWEAIResult dwEaiResult = new DWEAIResult("0", "", "", (Map)invokeResult);
                    result = DWGsonProvider.getGson().toJson((Object)dwEaiResult, dwEaiResult.getClass());
                }
            } else {
                result = invokeResult;
            }
            response.addHeader(KEY_DIGI_SRVVER, digiSrvver);
            response.addHeader(KEY_DIGI_SRVCODE, digiSrvcode.value());
        }
        catch (Throwable e) {
            response.addHeader(KEY_DIGI_SRVVER, digiSrvver);
            response.addHeader(KEY_DIGI_SRVCODE, DigiSrvcode.failure.value());
            String code = "-1";
            String sqlCode = "";
            String description = null;
            Map parameter = new HashMap();
            String message = null;
            String stacktrace = null;
            boolean isDwEaiException = false;
            DWEaiException eaiException = new DWEaiException();
            List throwableList = ExceptionUtils.getThrowableList((Throwable)e);
            for (Throwable throwable : throwableList) {
                if (!(throwable instanceof DWEaiException)) continue;
                eaiException = (DWEaiException)throwable;
                isDwEaiException = true;
            }
            if (!isDwEaiException) {
                eaiException = this.eaiExceptionHandler.parse(e);
            }
            String defaultDescription = this.getRootCausePureMessage(e);
            String defaultMessage = this.getRootCauseMessage(e);
            String defaultStacktrace = this.getStacktrace(e);
            code = eaiException.getCode();
            sqlCode = eaiException.getSqlCode();
            description = eaiException.getDescription(defaultDescription);
            parameter = eaiException.getParameter();
            message = eaiException.getMessage(defaultMessage);
            stacktrace = eaiException.getStacktrace(defaultStacktrace);
            DWEAIErrorResult dwEaiResult = new DWEAIErrorResult(code, sqlCode, description, parameter);
            dwEaiResult.setMessage(message);
            dwEaiResult.setStacktrace(stacktrace);
            result = DWGsonProvider.getGson().toJson((Object)dwEaiResult, dwEaiResult.getClass());
            this.logException(e);
        }
        return result;
    }

    public Object syncProd() throws Exception {
        HttpServletRequest request = EaiInfoUtils.getRequest();
        String digiService = request.getHeader("digi-service");
        JSONObject digiServiceJo = new JSONObject(digiService);
        String name = digiServiceJo.getString("name");
        Map<Object, Object> result = new HashMap();
        HttpServletResponse response = EaiInfoUtils.getResponse();
        response.addHeader("Content-Type", "application/json; charset=UTF-8");
        switch (name) {
            case "getProdRegInfo": {
                response.addHeader("action", "reg");
                result = EaiInfoUtils.getProdRegInfo(this.environment, this.properties);
                break;
            }
            case "getSrvRegInfo": {
                response.addHeader("action", "reg");
                result = EaiInfoUtils.getSrvRegInfo(() -> ((DWEAIHeaderRepository)this.eaiHeaderRepository).getEaiServiceIdList(), this.properties);
                break;
            }
            case "doSyncProcess": {
                response.addHeader(KEY_DIGI_SRVCODE, "000");
                break;
            }
            case "doSrvProcess": {
                String doSrcProcessServiceId = this.properties.getSyncProdProperties().getDoSrvProcessServiceId();
                if (doSrcProcessServiceId == null || doSrcProcessServiceId.equals("")) break;
                result = this.executeSyncProdService(doSrcProcessServiceId, request, response);
                break;
            }
            case "doSrvTest": {
                String doSrcTestServiceId = this.properties.getSyncProdProperties().getDoSrvTestServiceId();
                if (doSrcTestServiceId == null || doSrcTestServiceId.equals("")) break;
                result = this.executeSyncProdService(doSrcTestServiceId, request, response);
                break;
            }
        }
        return result;
    }

    private String getRootCauseMessage(Throwable exception) {
        return ExceptionUtils.getRootCauseMessage((Throwable)exception);
    }

    private String getRootCausePureMessage(Throwable exception) {
        Throwable rootCause = ExceptionUtils.getRootCause((Throwable)exception);
        Throwable targetCause = rootCause != null ? rootCause : exception;
        String message = targetCause.getMessage();
        if (message == null || message.isEmpty()) {
            message = targetCause.toString();
        }
        return message;
    }

    private String getStacktrace(Throwable exception) {
        return ExceptionUtils.getStackTrace((Throwable)exception);
    }

    private void clearChain(String parentDigiReqid) {
        this.redis.delete((Object)(CHAIN_PARAMETER_PREFIX + parentDigiReqid));
        this.redis.delete((Object)(CHAIN_HISTORY_PREFIX + parentDigiReqid));
        this.redis.delete((Object)(CHAIN_SIGNAL_PREFIX + parentDigiReqid));
        this.redis.delete((Object)(CHAIN_PROGRESS_SYNC_PREFIX + parentDigiReqid));
        this.redis.delete((Object)(CHAIN_PROGRESS_FASYNC_PREFIX + parentDigiReqid));
    }

    private void onFasyncException(Throwable e, String digiReqid, CallbackTask callbackTask) {
        this.logException(e);
        String code = "-1";
        String sqlCode = "";
        String description = this.getRootCauseMessage(e);
        DWEAICallback eaiCallback = new DWEAICallback(DigiSrvcode.failure.value(), digiReqid, code, sqlCode, description, new HashMap());
        Map callbackResult = eaiCallback.execute();
        if (callbackTask != null) {
            Map headers = (Map)callbackResult.get(KEY_HEADERS);
            String messageBody = (String)callbackResult.get("messageBody");
            callbackTask.execute(headers, messageBody);
        }
    }

    private void onEaiCallback(String digiReqid, DWEAIFasyncTaskResult eaiFasyncTaskResult, CallbackTask callbackTask, Map<String, Object> requestHeader) {
        this.onEaiCallback(digiReqid, eaiFasyncTaskResult, callbackTask, requestHeader, false);
    }

    private void onEaiCallback(String digiReqid, DWEAIFasyncTaskResult eaiFasyncTaskResult, CallbackTask callbackTask, Map<String, Object> requestHeader, boolean isLmcLog) {
        DWEAICallback eaiCallback = new DWEAICallback(digiReqid, eaiFasyncTaskResult);
        eaiCallback.setDigiDatakey(eaiFasyncTaskResult.getDigiDatakey());
        eaiCallback.setCustomHeader(eaiFasyncTaskResult.getCustomHeader());
        eaiCallback.setCustomCallbackHeader(eaiFasyncTaskResult.getCustomCallbackHeader());
        Map callbackResult = new HashMap();
        callbackResult = requestHeader.containsKey("digi-callback-url") ? eaiCallback.decentralization(requestHeader, isLmcLog) : eaiCallback.execute();
        if (callbackTask != null) {
            Map callbackHeaders = (Map)callbackResult.get(KEY_HEADERS);
            String callbackMessageBody = (String)callbackResult.get("messageBody");
            callbackTask.execute(callbackHeaders, callbackMessageBody);
        }
    }

    private void attachChainParameter(Map<String, Object> chainParameter, String digiReqid, String key) {
        String chainParameterString = DWGsonProvider.getGson().toJson(chainParameter, Map.class);
        this.redis.opsForHash().put((Object)(CHAIN_PARAMETER_PREFIX + digiReqid), (Object)key, (Object)chainParameterString);
    }

    private String getParentDigiReqid() {
        return DWServiceContext.getContext().getRequestHeader().getOrDefault("digi-callback-parent-reqid", "");
    }

    private String getCallbackId() {
        return DWServiceContext.getContext().getRequestHeader().getOrDefault("digi-callback-callback", "");
    }

    private String getDigiReqid() {
        return DWServiceContext.getContext().getRequestHeader().getOrDefault("digi-reqid", "");
    }

    private Map<String, Object> getRequestHeader() {
        return DWServiceContext.getContext().getRequestHeader();
    }

    private String getDigiServiceName() {
        return DWServiceContext.getContext().getDigiServiceName();
    }

    private void logException(Throwable throwable) {
        try {
            String rootCauseMessage = this.getRootCauseMessage(throwable);
            String stacktrace = this.getStacktrace(throwable);
            HttpServletRequest request = EaiInfoUtils.getRequest();
            DWTargetAPI api = (DWTargetAPI)request.getAttribute(KEY_TARGET_API);
            DWHeader header = api.getHeader();
            DWMethod method = api.getMethod();
            String moduleName = header.getModuleName();
            String serviceName = header.getServiceName();
            String methodName = method.getMethodName();
            log.error((Object)String.format("[EaiController] module: %s, service: %s, method: %s", moduleName, serviceName, methodName));
            log.error((Object)String.format("[EaiController] root cause message: %s", rootCauseMessage));
            log.error((Object)String.format("[EaiController] stack trace: %s", stacktrace));
        }
        catch (Throwable ignore) {
            String stacktrace = this.getStacktrace(throwable);
            log.error((Object)String.format("[EaiController] on log exception: %s", stacktrace));
        }
    }

    private Map<String, Object> executeSyncProdService(String serviceId, HttpServletRequest request, HttpServletResponse response) {
        Map<String, Object> result = new HashMap<String, Object>();
        try {
            DWRequestWrapper requestWrapper = new DWRequestWrapper((ServletRequest)request);
            String bodyString = new String(requestWrapper.getBody(), StandardCharsets.UTF_8);
            Map requestBody = (Map)DWGsonProvider.getGson().fromJson(bodyString, Map.class);
            TreeMap<String, String> requestHeaders = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
            Enumeration headerNames = request.getHeaderNames();
            while (headerNames.hasMoreElements()) {
                String key = (String)headerNames.nextElement();
                requestHeaders.put((String)headerNames.nextElement(), request.getHeader(key));
            }
            SyncProdServiceVo syncProdServiceVoRequest = new SyncProdServiceVo(requestBody, requestHeaders);
            IEAISyncProdService syncProdService = null;
            if (serviceId.contains(":")) {
                String[] moduleNameAndServiceId = serviceId.split(":");
                syncProdService = (IEAISyncProdService)DWModuleSpringUtils.getBean((String)moduleNameAndServiceId[0], (String)moduleNameAndServiceId[1]);
            } else {
                syncProdService = (IEAISyncProdService)SpringContextUtils.getBean((String)serviceId);
            }
            SyncProdServiceVo syncProdServiceVoResult = syncProdService.execute(syncProdServiceVoRequest);
            if (syncProdServiceVoResult.getHeaders() != null) {
                syncProdServiceVoResult.getHeaders().forEach((arg_0, arg_1) -> ((HttpServletResponse)response).addHeader(arg_0, arg_1));
            }
            if (syncProdServiceVoResult.getDigiSrvCode() != null) {
                response.addHeader(KEY_DIGI_SRVCODE, syncProdServiceVoResult.getDigiSrvCode());
            } else {
                response.addHeader(KEY_DIGI_SRVCODE, DigiSrvcode.success.value());
            }
            result = syncProdServiceVoResult.getBody();
        }
        catch (Exception e) {
            log.error((Object)"executeSyncProdService exception", (Throwable)e);
            response.addHeader(KEY_DIGI_SRVCODE, DigiSrvcode.failure.value());
            result.put("message", this.getRootCauseMessage(e));
            result.put("stacktrace", this.getStacktrace(e));
        }
        return result;
    }
}

