/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.gateway.controller;

import com.digiwin.app.container.DWContainerContext;
import com.digiwin.app.container.DWParameters;
import com.digiwin.app.container.DWTargetAPI;
import com.digiwin.app.eai.DWEAIProperties;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.app.service.eai.DWEAIHeaderRepository;
import com.digiwin.gateway.controller.EaiInfoUtils;
import com.digiwin.gateway.controller.ServiceInvoker;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.async.DeferredResult;

@RestController
public class EaiNioController {
    @Autowired
    private ServiceInvoker serviceInvoker;
    @Autowired
    private DWContainerContext containerContext;
    @Autowired
    private DWEAIHeaderRepository eaiHeaderRepository;
    @Autowired
    private DWEAIProperties properties;
    @Autowired
    Environment environment;

    public DeferredResult<Object> callback() throws Exception {
        HttpServletRequest request = EaiInfoUtils.getRequest();
        Map profile = DWServiceContext.getContext().getProfile();
        String digiSrvver = this.properties.getHostVer();
        DWTargetAPI api = (DWTargetAPI)request.getAttribute("targetAPI");
        DWParameters invokeParameters = (DWParameters)request.getAttribute("targetParameters");
        return this.serviceInvoker.eai(api, digiSrvver, invokeParameters, profile);
    }

    public DeferredResult<Object> eai() throws Exception {
        HttpServletRequest request = EaiInfoUtils.getRequest();
        Map profile = DWServiceContext.getContext().getProfile();
        String digiSrvver = this.properties.getHostVer();
        DWTargetAPI api = (DWTargetAPI)request.getAttribute("targetAPI");
        DWParameters invokeParameters = (DWParameters)request.getAttribute("targetParameters");
        return this.serviceInvoker.eai(api, digiSrvver, invokeParameters, profile);
    }

    public Object syncProd() throws Exception {
        HttpServletRequest request = EaiInfoUtils.getRequest();
        String digiService = request.getHeader("digi-service");
        JSONObject digiServiceJo = new JSONObject(digiService);
        String name = digiServiceJo.getString("name");
        Map<Object, Object> result = new HashMap();
        HttpServletResponse response = EaiInfoUtils.getResponse();
        response.addHeader("Content-Type", "application/json; charset=UTF-8");
        switch (name) {
            case "getProdRegInfo": {
                response.addHeader("action", "reg");
                result = EaiInfoUtils.getProdRegInfo(this.environment, this.properties);
                break;
            }
            case "getSrvRegInfo": {
                response.addHeader("action", "reg");
                result = EaiInfoUtils.getSrvRegInfo(() -> ((DWEAIHeaderRepository)this.eaiHeaderRepository).getEaiServiceIdList(), this.properties);
                break;
            }
            case "doSyncProcess": {
                response.addHeader("digi-srvcode", "000");
                break;
            }
        }
        return result;
    }
}

