/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.gateway.event;

import com.digiwin.gateway.event.DWDataSourceEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DWDataSourceEventConfig {
    private static final Log log = LogFactory.getLog(DWDataSourceEventConfig.class);
    private static final String CLASS_TAG = "[DWDataSourceEventConfig] ";
    public static final String PATH_TENANT_DATASOURCE_UPDATE = "/api/app/tenant/datasource/update";
    private static Map<DWDataSourceEvent, Integer> eventMap = new HashMap<DWDataSourceEvent, Integer>();

    public static void register(DWDataSourceEvent event) {
        DWDataSourceEventConfig.register(event, Integer.MAX_VALUE);
    }

    public static void register(DWDataSourceEvent event, int order) {
        if (event == null) {
            log.error((Object)"[DWDataSourceEventConfig] event is null!");
        } else {
            eventMap.put(event, order);
        }
    }

    public static List<DWDataSourceEvent> getEventList() {
        LinkedHashMap sortedMap = eventMap.entrySet().stream().sorted(Map.Entry.comparingByValue()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e2, LinkedHashMap::new));
        return new ArrayList<DWDataSourceEvent>(sortedMap.keySet());
    }

    public static Integer getOrder(DWDataSourceEvent event) {
        return eventMap.get(event);
    }
}

