/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.utils;

import com.digiwin.app.module.spring.SpringContextUtils;

public class DBUtils {
    public static boolean isDM8() {
        return SpringContextUtils.getEnvironment().getProperty("dbUrl").toLowerCase().contains(":dm:");
    }

    public static boolean isOceanBase() {
        return SpringContextUtils.getEnvironment().getProperty("dbUrl").toLowerCase().contains(":oceanbase:");
    }

    public static boolean isShenTong() {
        return SpringContextUtils.getEnvironment().getProperty("dbUrl").toLowerCase().contains(":oscar:");
    }

    public static boolean isPostgreSQL() {
        return SpringContextUtils.getEnvironment().getProperty("dbUrl").toLowerCase().contains(":postgresql:");
    }

    public static String getGeneratedKeyColumnName(String defaultColumnName) {
        String idColumnName = defaultColumnName;
        if (DBUtils.isDM8()) {
            idColumnName = "AUTO_GEN_KEY";
        } else if (DBUtils.isOceanBase()) {
            idColumnName = "GENERATED_KEY";
        } else if (DBUtils.isShenTong()) {
            idColumnName = "ID";
        } else if (DBUtils.isPostgreSQL()) {
            idColumnName = "id";
        }
        return idColumnName;
    }
}

