/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.module.spring;

import com.digiwin.app.container.exceptions.DWRuntimeException;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;

public final class SpringContextUtils
implements ApplicationContextAware,
EnvironmentAware {
    private static ApplicationContext _context;
    private static Environment environment;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        _context = applicationContext;
    }

    public static ApplicationContext getContext() {
        return _context;
    }

    public static <T> T getBean(String name) {
        Object bean = _context.getBean(name);
        return (T)bean;
    }

    public static boolean containsBean(String name) {
        return _context.containsBean(name);
    }

    public void setEnvironment(Environment environment) {
        SpringContextUtils.environment = environment;
    }

    public static Environment getEnvironment() {
        if (environment == null) {
            throw new DWRuntimeException("SpringContextUtils environment is not ready, please contact DAP for this issue.");
        }
        return environment;
    }
}

