/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.gateway.token;

import com.digiwin.app.resource.DWApplicationMessageResourceBundleUtils;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.gateway.token.JwtTokenBean;
import com.digiwin.gateway.token.exception.DWTokenExpiredException;
import com.digiwin.gateway.token.exception.DWTokenSignatureException;
import com.digiwin.gateway.token.exception.DWTokenVerifyFailedException;
import com.digiwin.iam.HttpResponseModel;
import com.digiwin.iam.UserTokenService;
import com.digiwin.utils.DWTenantUtils;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.MalformedJwtException;
import io.jsonwebtoken.SignatureAlgorithm;
import io.jsonwebtoken.SignatureException;
import java.security.Key;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public final class TokenService {
    @Autowired
    @Qualifier(value="dwUserTokenService")
    UserTokenService userTokenService;
    private static final String PRIVATE_KEY = "%^*(LongAndHardToGuessValueWithSpecialCharacters@%&$";
    private static final SignatureAlgorithm SIGNATURE_ALGORITHM = SignatureAlgorithm.HS512;
    private static final byte[] API_BYTES_KEY = DatatypeConverter.parseBase64Binary((String)"%^*(LongAndHardToGuessValueWithSpecialCharacters@%&$");
    private static final Key SIGNING_KEY = new SecretKeySpec(API_BYTES_KEY, SIGNATURE_ALGORITHM.getJcaName());
    public static final long EFFECTIVE_TIME = 86400000L;

    public Map<String, Object> getProfile() {
        Map profile = DWServiceContext.getContext().getProfile();
        if (profile == null) {
            return Collections.emptyMap();
        }
        return profile;
    }

    public String generateToken(JwtTokenBean<?> jwtTokenBean) {
        if (jwtTokenBean == null) {
            throw new IllegalArgumentException("TokenBean is null!");
        }
        String issuer = jwtTokenBean.getIssuer();
        String subject = jwtTokenBean.getSubject();
        String audience = jwtTokenBean.getAudience();
        Date expiration = jwtTokenBean.getExpiration();
        Date notBefore = jwtTokenBean.getNotBefore();
        Date issuedAt = jwtTokenBean.getIssuedAt();
        String jwtId = jwtTokenBean.getPrimerKey();
        String token = Jwts.builder().setIssuer(issuer).setSubject(subject).setAudience(audience).setExpiration(expiration).setNotBefore(notBefore).setIssuedAt(issuedAt).setId(jwtId).signWith(SignatureAlgorithm.HS512, SIGNING_KEY).compact();
        return token;
    }

    public void verifyToken(String token) throws DWTokenSignatureException, DWTokenExpiredException {
        Claims claims = null;
        try {
            claims = (Claims)Jwts.parser().setSigningKey(SIGNING_KEY).parseClaimsJws(token).getBody();
        }
        catch (MalformedJwtException | SignatureException e) {
            throw new DWTokenSignatureException();
        }
        catch (ExpiredJwtException e) {
            throw new DWTokenExpiredException();
        }
        String subject = claims.getSubject();
        Map profile = Collections.emptyMap();
        if (subject != null && subject.length() != 0) {
            subject = subject.replace("\\\"", "\"").replace("\"{", "{").replace("}\"", "}");
            JSONObject jo = new JSONObject(subject);
            profile = jo.getJSONObject("profile").toMap();
        }
        DWServiceContext.getContext().setToken(token);
        DWServiceContext.getContext().setProfile(profile);
    }

    public void verifyIamToken(String token) throws Exception {
        Map<String, Object> tokenMap;
        Map profile = Collections.emptyMap();
        HttpResponseModel iamResult = null;
        String originIamUrlKey = DWServiceContext.getContext().getRequestHeader().getOrDefault("origin-iam-url-key", "");
        iamResult = StringUtils.isBlank((CharSequence)originIamUrlKey) ? this.userTokenService.verifyToken(token) : this.userTokenService.verifyTokenWithoutCache(token);
        if (iamResult != null) {
            tokenMap = this.getIamResult(iamResult);
            if (!tokenMap.containsKey("success") || !((Boolean)tokenMap.get("success")).booleanValue()) {
                StringBuilder extraMessage = new StringBuilder();
                extraMessage.append("status:").append(iamResult.getHttpStatusCode());
                extraMessage.append(", response:").append(iamResult.getResponseBody());
                throw new DWTokenVerifyFailedException("10902", DWApplicationMessageResourceBundleUtils.getApplicationResourceBundle((String)"10902", (String)"10902", (Object[])new Object[]{iamResult.getHttpStatusCode(), iamResult.getResponseBody()}));
            }
        } else {
            throw new DWTokenVerifyFailedException("10901", DWApplicationMessageResourceBundleUtils.getApplicationResourceBundle((String)"10901", (String)"10901", (Object[])new Object[0]));
        }
        profile = (Map)tokenMap.get("datas");
        DWServiceContext.getContext().setToken(token);
        DWServiceContext.getContext().setProfile(profile);
    }

    private Map<String, Object> getIamResult(HttpResponseModel iamResponse) throws Exception {
        int httpStatusCode = iamResponse.getHttpStatusCode();
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        HashMap<String, Object> response = new HashMap<String, Object>();
        if (httpStatusCode == 200) {
            String responseBody = iamResponse.getResponseBody();
            JSONObject responseJson = new JSONObject(responseBody);
            String userId = (String)responseJson.get("id");
            String userName = (String)responseJson.get("name");
            if (DWTenantUtils.isTenantenabled()) {
                if (responseJson.has("tenantId")) {
                    dataMap.put("tenantId", (String)responseJson.get("tenantId"));
                }
                if (responseJson.has("tenantName")) {
                    dataMap.put("tenantName", (String)responseJson.get("tenantName"));
                }
            }
            Long tenantSid = ((Number)responseJson.get("tenantSid")).longValue();
            dataMap.put("tenantSid", tenantSid);
            dataMap.put("userId", userId);
            dataMap.put("userName", userName);
            response.put("datas", dataMap);
            response.put("success", true);
        } else {
            dataMap.put("iamHttpStatusCode", httpStatusCode);
            dataMap.put("message", iamResponse.getResponseBody());
            response.put("datas", dataMap);
            response.put("success", false);
            response.put("description", "\u8abf\u7528IAM \u670d\u52d9\u5931\u6557\u932f\u8aa4");
        }
        return response;
    }
}

