/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.gateway.tracing.interceptor;

import brave.Span;
import brave.Tracer;
import brave.Tracing;
import com.digiwin.gateway.tracing.DWTracing;
import com.digiwin.gateway.tracing.DWTracingContext;
import com.digiwin.gateway.tracing.handler.DWTracerHandler;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;

public class HttpClientInterceptor
implements MethodInterceptor {
    private static String tracingServiceName = "HttpClient";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        Object result = null;
        if (!DWTracingContext.getInstance().isTracingEnable()) return methodInvocation.proceed();
        String reqUrl = "";
        Object[] args = methodInvocation.getArguments();
        Object arg0 = args[0];
        DWTracing dwTracing = new DWTracing("api:" + tracingServiceName);
        Tracing tracing = dwTracing.getCurrentTracing();
        DWTracerHandler dwTracerHandler = new DWTracerHandler(tracing);
        Tracer tracer = dwTracerHandler.getTracer();
        Span span = tracer.nextSpan().name("execute");
        try (Tracer.SpanInScope ws = tracer.withSpanInScope(span.start());){
            HttpPost httpPost;
            if (arg0 instanceof HttpRequestBase && StringUtils.isNotBlank((CharSequence)(reqUrl = (httpPost = (HttpPost)arg0).getURI().toURL().toString()))) {
                span.tag("url", reqUrl);
            }
            span.kind(Span.Kind.CLIENT);
            result = methodInvocation.proceed();
            if (!(result instanceof CloseableHttpResponse)) return result;
            int responseCode = ((CloseableHttpResponse)result).getStatusLine().getStatusCode();
            span.tag("statusCode", String.valueOf(responseCode));
            return result;
        }
        catch (Exception e) {
            span.error((Throwable)e);
            throw e;
        }
        finally {
            span.finish();
        }
    }
}

