/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.gateway.tracing;

import brave.Tracing;
import brave.http.HttpTracing;
import brave.sampler.BoundarySampler;
import com.digiwin.gateway.tracing.DWTracingContext;
import com.digiwin.gateway.tracing.config.DWTracingConfig;
import com.digiwin.gateway.tracing.config.TracingConfig;
import zipkin2.reporter.Reporter;

public class DWTracing {
    private static DWTracingContext dwTracingContext = DWTracingContext.getInstance();
    private static DWTracingConfig dwTracingConfig = dwTracingContext.getDwTracingConfig();
    DWTracing dwTracing;
    String serviceName;
    Tracing tracing;
    String ipAddress;
    Tracing.Builder builder;
    HttpTracing httpTracing;
    String productName = System.getProperty("appName", "app-none");

    public static DWTracingConfig getDWTracingConfig() {
        return dwTracingConfig;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public String getProductName() {
        return this.productName;
    }

    public Tracing getConfiguredTracing() {
        String serviceName = dwTracingConfig.getServiceName();
        this.tracing = this.getTracing(serviceName);
        return this.tracing;
    }

    public Tracing getTracing(String serviceName) {
        return this.tracing;
    }

    public DWTracing(String serviceName) {
        dwTracingConfig.setServiceName(serviceName);
        this.tracing = this.build(dwTracingConfig);
        this.httpTracing = HttpTracing.create((Tracing)this.tracing).clientOf(serviceName);
    }

    public Tracing build(TracingConfig dwTracingConfig) {
        this.builder = Tracing.newBuilder().localServiceName(dwTracingConfig.getServiceName()).spanReporter((Reporter)dwTracingConfig.getSpanReporter()).sampler(BoundarySampler.create((float)dwTracingConfig.getSampleRate()));
        if (dwTracingConfig.isHasLocalIp()) {
            this.builder = this.builder.localIp(dwTracingConfig.getLocalIp());
        }
        this.tracing = this.builder.build();
        return this.tracing;
    }

    public Tracing getCurrentTracing() {
        return this.tracing;
    }

    public HttpTracing getHttpTracing() {
        return this.httpTracing;
    }
}

