/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.gateway.tracing;

import brave.Tracing;
import brave.internal.Platform;
import com.digiwin.app.module.spring.SpringContextUtils;
import com.digiwin.gateway.tracing.config.DWTracingConfig;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.commons.lang3.StringUtils;
import zipkin2.Span;
import zipkin2.reporter.Reporter;

public class DWTracingContext {
    private DWTracingConfig dwTracingConfig = (DWTracingConfig)SpringContextUtils.getBean((String)"dwTracingConfig");
    private static Reporter<Span> spanReporter;
    private static String serviceName;
    private static Tracing tracing;
    private static float sampleRate;
    private static boolean tracingEnable;
    private static String productName;
    private String requestUrl;
    private static DWTracingContext context;

    private DWTracingContext() {
        if (context == null) {
            String configedLocalIp;
            sampleRate = this.dwTracingConfig.getSampleRate();
            tracingEnable = this.dwTracingConfig.isEnabled();
            spanReporter = (Reporter)this.dwTracingConfig.getSpanReporter();
            String configedServiceName = this.dwTracingConfig.getServiceName();
            if (StringUtils.isNotBlank((CharSequence)configedServiceName)) {
                serviceName = configedServiceName;
            }
            if (StringUtils.isNotBlank((CharSequence)(configedLocalIp = this.dwTracingConfig.getLocalIp()))) {
                this.dwTracingConfig.setLocalIp(configedLocalIp);
                this.dwTracingConfig.setHasLocalIp(true);
            } else {
                String localIpAddress = DWTracingContext.getLocalIpAddress();
                if (StringUtils.isNotBlank((CharSequence)localIpAddress)) {
                    this.dwTracingConfig.setLocalIp(localIpAddress);
                    this.dwTracingConfig.setHasLocalIp(true);
                }
            }
        }
    }

    public static DWTracingContext getInstance() {
        return DWTracingContexHolder.context;
    }

    private static String getLocalIpAddress() {
        String ipAddress = Platform.get().linkLocalIp();
        if (StringUtils.isBlank((CharSequence)ipAddress)) {
            try {
                InetAddress jdkInetAddress = InetAddress.getLocalHost();
                ipAddress = jdkInetAddress.getHostAddress();
            }
            catch (UnknownHostException e) {
                System.out.println("Can't get local address by InetAddress");
                ipAddress = null;
            }
        }
        return ipAddress;
    }

    public DWTracingConfig getDwTracingConfig() {
        return this.dwTracingConfig;
    }

    public void setDwTracingConfig(DWTracingConfig dwTracingConfig) {
        this.dwTracingConfig = dwTracingConfig;
    }

    public Reporter<Span> getSpanReporter() {
        return spanReporter;
    }

    public void setSpanReporter(Reporter<Span> spanReporter) {
        DWTracingContext.spanReporter = spanReporter;
    }

    public boolean isTracingEnable() {
        return tracingEnable;
    }

    public void setTracingEnable(boolean tracingEnable) {
        DWTracingContext.tracingEnable = tracingEnable;
    }

    public float getSampleRate() {
        return sampleRate;
    }

    public void setSampleRate(float sampleRate) {
        DWTracingContext.sampleRate = sampleRate;
    }

    public void destroyInstance(Object instance) {
        ((Tracing)instance).close();
    }

    public Tracing getTracing() {
        return tracing;
    }

    public void setTracing(Tracing tracing) {
        DWTracingContext.tracing = tracing;
    }

    public String getServiceName() {
        return serviceName;
    }

    public void setServiceName(String serviceName) {
        DWTracingContext.serviceName = serviceName;
    }

    public static String getProductName() {
        return productName;
    }

    public static void setProductName(String productName) {
        DWTracingContext.productName = productName;
    }

    public String getRequestUrl() {
        return this.requestUrl;
    }

    public void setRequestUrl(String requestUrl) {
        this.requestUrl = requestUrl;
    }

    private static class DWTracingContexHolder {
        private static DWTracingContext context = new DWTracingContext();

        private DWTracingContexHolder() {
        }
    }
}

