/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.gateway.tracing.interceptor;

import brave.Span;
import brave.Tracer;
import brave.Tracing;
import com.digiwin.gateway.tracing.DWTracing;
import com.digiwin.gateway.tracing.DWTracingContext;
import com.digiwin.gateway.tracing.handler.DWTracerHandler;
import java.util.List;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.lang3.StringUtils;

public class DBUtilsInterceptor
implements MethodInterceptor {
    private static String tracingServiceName = "DBUtils";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        String methodName = methodInvocation.getMethod().getName();
        Object[] args = methodInvocation.getArguments();
        String sqlId = (String)args[0];
        Object result = null;
        if (!DWTracingContext.getInstance().isTracingEnable()) return methodInvocation.proceed();
        DWTracing dwTracing = new DWTracing("api:" + tracingServiceName);
        Tracing tracing = dwTracing.getCurrentTracing();
        DWTracerHandler dwTracerHandler = new DWTracerHandler(tracing);
        Tracer tracer = dwTracerHandler.getTracer();
        Span span = tracer.nextSpan().name(StringUtils.appendIfMissingIgnoreCase((String)"execute-", (CharSequence)methodName, (CharSequence[])new CharSequence[0]));
        span.tag("exec_method", methodName);
        span.tag("sql", sqlId);
        try (Tracer.SpanInScope ws = tracer.withSpanInScope(span.start());){
            span.kind(Span.Kind.CLIENT);
            result = methodInvocation.proceed();
            if (result instanceof Integer) {
                span.tag("result-int", ((Number)result).toString());
                return result;
            } else {
                if (!(result instanceof List)) return result;
                span.tag("result-list", String.valueOf(((List)result).size()));
            }
            return result;
        }
        catch (Exception e) {
            span.error((Throwable)e);
            throw e;
        }
        finally {
            span.finish();
        }
    }
}

