/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.estools.common.esclient;

import com.digiwin.estools.common.esclient.HttpOprationEsClient;
import com.digiwin.estools.common.esclient.request.HttpIndexRequest;
import com.digiwin.estools.utils.HttpUtils;
import com.digiwin.estools.utils.JSONUtils;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public final class HttpIndicesClient {
    private static final Logger log = LoggerFactory.getLogger(HttpIndicesClient.class);
    private final HttpOprationEsClient httpOprationEsClient;

    public HttpIndicesClient(HttpOprationEsClient httpOprationEsClient) {
        this.httpOprationEsClient = httpOprationEsClient;
    }

    public String create(HttpIndexRequest indexRequest) {
        String url = String.format("%s/%s", this.httpOprationEsClient.getHttpUrl(), indexRequest.getName());
        Map<String, String> headerMap = this.httpOprationEsClient.getHttpEsHeader();
        return HttpUtils.put(url, indexRequest.getIndexParam(), null, headerMap);
    }

    public Boolean exists(HttpIndexRequest indexRequest) {
        Boolean flag = true;
        String url = String.format("%s/%s", this.httpOprationEsClient.getHttpUrl(), "_cat/indices");
        Map<String, String> headerMap = this.httpOprationEsClient.getHttpEsHeader();
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("index", indexRequest.getName());
        String resultInfo = HttpUtils.get(url, null, param, headerMap);
        if (JSONUtils.checkJsonValid(resultInfo)) {
            log.info("http es index exists :{}", (Object)resultInfo);
            flag = false;
        }
        return flag;
    }
}

