/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.estools.dto;

import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.estools.dto.DocOperationBase;
import com.digiwin.estools.utils.CollectionsUtils;
import com.digiwin.estools.utils.ElasticRestClientUtils;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.springframework.util.CollectionUtils;

public class DocInsert
extends DocOperationBase {
    private Map<String, String> dataMap;
    private Map<String, JSONObject> dataJsonMap;
    private String attachment;

    @JsonCreator
    public DocInsert(String index, String type, Map<String, String> dataMap, Map<String, JSONObject> dataJsonMap) {
        this.index = index;
        this.type = type;
        this.dataMap = dataMap;
        this.dataJsonMap = dataJsonMap;
        this.init();
    }

    private void init() {
        this.type = Optional.ofNullable(this.type).orElse("_doc");
        Optional.ofNullable(this.dataJsonMap).filter(CollectionsUtils::notEmpty).ifPresent(list -> {
            if (CollectionUtils.isEmpty(this.dataMap)) {
                HashMap<String, String> map = new HashMap<String, String>();
                this.dataJsonMap.forEach((key, value) -> map.put((String)key, JSONUtil.toJsonStr((Object)value)));
                this.dataMap = map;
            }
        });
        this.setEsOprationTypeEnum(ElasticRestClientUtils.readConfigEsOpMode(this.index));
    }

    public Map<String, String> getDataMap() {
        return this.dataMap;
    }

    public Map<String, JSONObject> getDataJsonMap() {
        return this.dataJsonMap;
    }

    public String getAttachment() {
        return this.attachment;
    }

    public void setDataMap(Map<String, String> dataMap) {
        this.dataMap = dataMap;
    }

    public void setDataJsonMap(Map<String, JSONObject> dataJsonMap) {
        this.dataJsonMap = dataJsonMap;
    }

    public void setAttachment(String attachment) {
        this.attachment = attachment;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DocInsert)) {
            return false;
        }
        DocInsert other = (DocInsert)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, String> this$dataMap = this.getDataMap();
        Map<String, String> other$dataMap = other.getDataMap();
        if (this$dataMap == null ? other$dataMap != null : !((Object)this$dataMap).equals(other$dataMap)) {
            return false;
        }
        Map<String, JSONObject> this$dataJsonMap = this.getDataJsonMap();
        Map<String, JSONObject> other$dataJsonMap = other.getDataJsonMap();
        if (this$dataJsonMap == null ? other$dataJsonMap != null : !((Object)this$dataJsonMap).equals(other$dataJsonMap)) {
            return false;
        }
        String this$attachment = this.getAttachment();
        String other$attachment = other.getAttachment();
        return !(this$attachment == null ? other$attachment != null : !this$attachment.equals(other$attachment));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof DocInsert;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, String> $dataMap = this.getDataMap();
        result = result * 59 + ($dataMap == null ? 43 : ((Object)$dataMap).hashCode());
        Map<String, JSONObject> $dataJsonMap = this.getDataJsonMap();
        result = result * 59 + ($dataJsonMap == null ? 43 : ((Object)$dataJsonMap).hashCode());
        String $attachment = this.getAttachment();
        result = result * 59 + ($attachment == null ? 43 : $attachment.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "DocInsert(dataMap=" + this.getDataMap() + ", dataJsonMap=" + this.getDataJsonMap() + ", attachment=" + this.getAttachment() + ")";
    }

    public DocInsert() {
    }
}

