/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.estools.enums;

import org.springframework.util.ObjectUtils;

public enum EsOprationTypeEnum {
    REST_CLIENT(1, "REST_CLIENT"),
    JAVA_API(2, "JAVA_API"),
    HTTP_CLIENT(3, "HTTP_CLIENT"),
    ES_SQL_DIRECT(4, "ES_SQL_DIRECT"),
    CUSTOM_DSL_DIRECT(5, "CUSTOM_DSL_DIRECT");

    private final int code;
    private final String desc;

    private EsOprationTypeEnum(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static Integer code(String name) {
        if (name == null) {
            return null;
        }
        for (EsOprationTypeEnum ty : EsOprationTypeEnum.values()) {
            if (!ObjectUtils.nullSafeEquals((Object)ty.name(), (Object)name)) continue;
            return ty.getCode();
        }
        return null;
    }

    public static EsOprationTypeEnum of(String desc) {
        for (EsOprationTypeEnum ty : EsOprationTypeEnum.values()) {
            if (!ObjectUtils.nullSafeEquals((Object)ty.getDesc(), (Object)desc)) continue;
            return ty;
        }
        return null;
    }

    public static EsOprationTypeEnum of(int type) {
        for (EsOprationTypeEnum ty : EsOprationTypeEnum.values()) {
            if (ty.getCode() != type) continue;
            return ty;
        }
        return null;
    }

    public int getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }
}

