/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.estools.utils;

import com.digiwin.estools.enums.EsOprationTypeEnum;
import com.digiwin.estools.exceptions.BusinessException;
import com.digiwin.estools.utils.CollectionsUtils;
import com.digiwin.estools.utils.StringUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.http.HttpEntity;
import org.apache.http.util.EntityUtils;
import org.elasticsearch.action.bulk.BackoffPolicy;
import org.elasticsearch.action.bulk.BulkProcessor;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class ElasticRestClientUtils {
    private static final Logger log = LoggerFactory.getLogger(ElasticRestClientUtils.class);
    @Value(value="${default.elastic.insert.batch-size:5}")
    private Integer batchSize;
    @Value(value="${default.elastic.insert.batch-record:1000}")
    private Integer batchRecord;
    private static String lmcOpMode;
    private static String dmcOpMode;
    private static String opMode;

    public static EsOprationTypeEnum readConfigEsOpMode(String index) {
        if (StringUtils.isBlank(index)) {
            return null;
        }
        EsOprationTypeEnum esOprationTypeEnum = null;
        esOprationTypeEnum = "lmc_eventlog".equals(index) || "alias_lmc_eventlog".equals(index) || "lmc_devlog".equals(index) || "alias_lmc_devlog".equals(index) ? EsOprationTypeEnum.of(lmcOpMode) : ("dmc_index".equals(index) ? EsOprationTypeEnum.of(dmcOpMode) : EsOprationTypeEnum.of(opMode));
        return esOprationTypeEnum;
    }

    @Value(value="${default.elastic.lmc-op-mode:HTTP_CLIENT}")
    public void setLmcOpMode(String lmcOpMode) {
        ElasticRestClientUtils.lmcOpMode = lmcOpMode;
    }

    @Value(value="${default.elastic.dmc-op-mode:HTTP_CLIENT}")
    public void setDmcOpMode(String dmcOpMode) {
        ElasticRestClientUtils.dmcOpMode = dmcOpMode;
    }

    public static String getRes(Response response) throws IOException {
        String responseContent = "";
        if (response.getStatusLine().getStatusCode() == 200) {
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                responseContent = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
            } else {
                log.warn("http entity is null");
            }
        } else {
            log.error("error response : {}", (Object)response.toString());
            throw new BusinessException(" analysis res error !");
        }
        return responseContent;
    }

    public static String getHighlightValue(HighlightField highlightField) {
        Text[] fragments;
        StringBuilder sb = new StringBuilder();
        if (highlightField == null) {
            return "";
        }
        for (Text item : fragments = highlightField.fragments()) {
            sb.append(item);
        }
        return String.valueOf(sb);
    }

    public static String handleArrayFieldHighlight(List<Object> list, HighlightField highlightField) {
        ArrayList valueList = new ArrayList();
        Text[] fragments = highlightField.fragments();
        list.stream().forEach(item -> {
            List collect = Arrays.stream(fragments).filter(text -> item.equals(String.valueOf(text).replace("<span class=\"highlight-red\">", "").replace("</span>", ""))).collect(Collectors.toList());
            if (CollectionsUtils.notEmpty(collect).booleanValue()) {
                valueList.add(String.valueOf(collect.stream().findFirst().get()));
            } else {
                valueList.add(String.valueOf(item));
            }
        });
        String result = valueList.stream().map(String::valueOf).collect(Collectors.joining(" "));
        return result;
    }

    public BulkProcessor getBulkProcessor(RestHighLevelClient client) {
        return BulkProcessor.builder((request, bulkListener) -> client.bulkAsync(request, RequestOptions.DEFAULT, bulkListener), (BulkProcessor.Listener)new BulkProcessor.Listener(){

            public void beforeBulk(long executionId, BulkRequest request) {
                log.info("order id : {} ready to execute insert ,record size {} ", (Object)executionId, (Object)request.numberOfActions());
            }

            public void afterBulk(long executionId, BulkRequest request, BulkResponse response) {
                if (response.hasFailures()) {
                    log.error("Bulk {} executed with failures, response : {}", (Object)executionId, (Object)response.buildFailureMessage());
                } else {
                    log.info("order id : {} execute success ,{} records cost {} ms", new Object[]{executionId, request.numberOfActions(), response.getTook().getMillis()});
                }
            }

            public void afterBulk(long executionId, BulkRequest request, Throwable failure) {
                log.error("order id : {} execute failure ,record size : {} , e : {}", new Object[]{executionId, request.numberOfActions(), failure.getMessage()});
                throw new BusinessException(failure.getMessage());
            }
        }, (String)"").setBulkActions(this.batchRecord.intValue()).setBulkSize(new ByteSizeValue((long)this.batchSize.intValue(), ByteSizeUnit.MB)).setFlushInterval(TimeValue.timeValueSeconds((long)2L)).setConcurrentRequests(1).setBackoffPolicy(BackoffPolicy.exponentialBackoff((TimeValue)TimeValue.timeValueMillis((long)100L), (int)3)).build();
    }

    @Value(value="${default.elastic.op-mode:REST_CLIENT}")
    public void setOpMode(String opMode) {
        ElasticRestClientUtils.opMode = opMode;
    }
}

