/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.estools.utils;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import com.digiwin.estools.exceptions.BusinessException;
import com.digiwin.estools.utils.StringUtils;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtils {
    public static final Logger logger = LoggerFactory.getLogger(HttpUtils.class);

    public static String get(String url, String param, Map<String, Object> formParam, Map<String, String> header) {
        HttpRequest get = HttpRequest.get((String)url).form(formParam);
        get.addHeaders(header);
        if (StringUtils.isNotBlank(param)) {
            get.body(param);
        }
        get.timeout(20000);
        HttpResponse execute = get.execute();
        String result = "";
        if (execute.getStatus() != 200 && execute.getStatus() != 404) {
            logger.error("http get url:{} response status code is not 200!response:{}", (Object)url, (Object)execute.body());
            throw new BusinessException(execute.body());
        }
        result = execute.body();
        return result;
    }

    public static String post(String url, String param, Map<String, Object> formParam, Map<String, String> header) {
        HttpRequest post = HttpRequest.post((String)url);
        post.addHeaders(header);
        post.body(param);
        post.form(formParam);
        post.timeout(20000);
        HttpResponse execute = post.execute();
        String result = "";
        if (execute.getStatus() != 200) {
            logger.error("http post url:{} response status code is not 200!response:{}", (Object)url, (Object)execute.body());
            throw new BusinessException(execute.body());
        }
        result = execute.body();
        return result;
    }

    public static String put(String url, String param, Map<String, Object> formParam, Map<String, String> header) {
        HttpRequest put = HttpRequest.put((String)url);
        put.addHeaders(header);
        put.body(param);
        put.form(formParam);
        put.timeout(20000);
        HttpResponse execute = put.execute();
        String result = "";
        if (execute.getStatus() != 200) {
            logger.error("http put url:{} response status code is not 200!response:{}", (Object)url, (Object)execute.body());
            throw new BusinessException(execute.body());
        }
        result = execute.body();
        return result;
    }

    public static String delete(String url, String param, Map<String, Object> formParam, Map<String, String> header) throws Exception {
        HttpRequest delete = HttpRequest.delete((String)url);
        delete.addHeaders(header);
        delete.body(param);
        delete.form(formParam);
        delete.timeout(20000);
        HttpResponse execute = delete.execute();
        String result = "";
        if (execute.getStatus() != 200) {
            logger.error("http delete url:{} response status code is not 200!response:{}", (Object)url, (Object)execute.body());
            throw new BusinessException(execute.body());
        }
        result = execute.body();
        return result;
    }

    public static void concatHeader(Map<String, String> header, HttpRequestBase post) {
        Optional.ofNullable(header).filter(i -> !i.isEmpty()).ifPresent(i -> i.entrySet().forEach(entry -> post.addHeader((String)entry.getKey(), (String)entry.getValue())));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getReq(String url) throws IOException {
        CloseableHttpClient httpclient = HttpClients.createDefault();
        try {
            HttpGet httpget = new HttpGet(url);
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(60000).setConnectionRequestTimeout(60000).setSocketTimeout(60000).setRedirectsEnabled(true).build();
            httpget.setConfig(requestConfig);
            String responseContent = null;
            CloseableHttpResponse response = null;
            response = httpclient.execute((HttpUriRequest)httpget);
            if (response.getStatusLine().getStatusCode() == 200) {
                HttpEntity entity = response.getEntity();
                if (entity != null) {
                    responseContent = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
                } else {
                    logger.warn("http entity is null");
                }
            } else {
                logger.error("http get:{} response status code is not 200!", (Object)response.getStatusLine().getStatusCode());
            }
            String string = responseContent;
            return string;
        }
        finally {
            if (Collections.singletonList(httpclient).get(0) != null) {
                httpclient.close();
            }
        }
    }
}

