/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.aop;

import com.digiwin.app.service.DWServiceContext;
import com.digiwin.lcdp.modeldriven.aop.DWEAICrudInvocationListener;
import com.digiwin.lcdp.modeldriven.aop.DWEAICrudInvocationListenerRegistry;
import java.util.HashMap;
import java.util.Map;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.lang3.time.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DWEAICommonCrudInterceptor
implements MethodInterceptor,
DWEAICrudInvocationListenerRegistry {
    private static Logger logger = LoggerFactory.getLogger(DWEAICommonCrudInterceptor.class);
    Map<String, DWEAICrudInvocationListener> listeners = new HashMap<String, DWEAICrudInvocationListener>();

    public Map<String, DWEAICrudInvocationListener> getListeners() {
        return this.listeners;
    }

    public void setListeners(Map<String, DWEAICrudInvocationListener> listeners) {
        this.listeners = listeners;
    }

    @Override
    public void register(String eaiId, DWEAICrudInvocationListener listener) {
        logger.debug("[DWEAICommonCrudInterceptor] add eaiId({}), listener({})", (Object)eaiId, (Object)listener.getClass().getTypeName());
        this.listeners.put(eaiId, listener);
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        String digiServiceName = DWServiceContext.getContext().getDigiServiceName();
        logger.debug("DWEAICommonCrudInterceptor invoke eaiId({})", (Object)digiServiceName);
        DWEAICrudInvocationListener targetListener = this.listeners.get(digiServiceName);
        Object result = null;
        if (targetListener != null) {
            logger.debug("DWEAICommonCrudInterceptor invoke ({}) , target interceptor({})", (Object)digiServiceName, (Object)targetListener.getClass().getTypeName());
            Object[] objects = invocation.getArguments();
            Map headers = (Map)objects[0];
            Map messageBody = (Map)objects[1];
            StopWatch stopWatch = StopWatch.createStarted();
            StringBuffer timeRecord = new StringBuffer();
            try {
                timeRecord.append(String.format("beforeInvoke(%d) ", stopWatch.getTime()));
                logger.debug(timeRecord.toString());
                targetListener.beforeInvoke(headers, messageBody);
                timeRecord.append(String.format("afterBeforeInvoke(%d) ", stopWatch.getTime()));
                result = invocation.proceed();
                timeRecord.append(String.format("invocation.proceed()(%d) ", stopWatch.getTime()));
                targetListener.around(headers, messageBody);
            }
            catch (Throwable e) {
                timeRecord.append(String.format("before doException(%d) ", stopWatch.getTime()));
                targetListener.doException(e);
                timeRecord.append(String.format("after doException(%d) ", stopWatch.getTime()));
                if (!stopWatch.isStopped()) {
                    stopWatch.stop();
                }
                throw e;
            }
            finally {
                targetListener.afterInvoke(invocation, result);
                if (!stopWatch.isStopped()) {
                    stopWatch.stop();
                }
            }
        } else {
            logger.debug("[DWEAICommonCrudInterceptor] didn't have registered interceptor when invoke eaiId({})", (Object)digiServiceName);
            result = invocation.proceed();
        }
        return result;
    }
}

